/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.management;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeRMIConnector;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class XqeRmiRegistry {
    private boolean portBound = false;
    private static int registryPort = -1;
    private Registry registry;

    public static int getRegistryPort() {
        return registryPort;
    }

    public void checkRMIRegistryAndStart() {
        if (!this.checkRMIRegistry()) {
            while (!this.portBound) {
                this.startRMIRegistry();
            }
        }
    }

    boolean checkRMIRegistry() {
        return this.registry != null;
    }

    private void startRMIRegistry() {
        try {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            registryPort = 0;
            if (config != null) {
                registryPort = config.getIntProperty("network.rmiRegistry[@port]", 0);
            }
            if (registryPort == 0) {
                ServerSocket socket = new ServerSocket(0);
                registryPort = socket.getLocalPort();
                socket.close();
            }
            this.registry = LocateRegistry.createRegistry(registryPort);
            XqeRMIConnector.setRmiPort(registryPort);
            this.portBound = true;
        }
        catch (RemoteException e) {
            this.portBound = false;
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (BindException e) {
            this.portBound = false;
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (IOException e) {
            this.portBound = false;
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
        catch (Exception e) {
            this.portBound = false;
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
    }

    public void stopRMIRegistry() {
        registryPort = -1;
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
            catch (NoSuchObjectException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
            }
            finally {
                this.registry = null;
            }
        }
    }
}

