/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.function.set.Any;
import com.cognos.xqe.function.set.Avg;
import com.cognos.xqe.function.set.Count;
import com.cognos.xqe.function.set.FirstValue;
import com.cognos.xqe.function.set.LastValue;
import com.cognos.xqe.function.set.Max;
import com.cognos.xqe.function.set.Min;
import com.cognos.xqe.function.set.StdDevPop;
import com.cognos.xqe.function.set.Sum;
import com.cognos.xqe.function.set.VarPop;
import com.cognos.xqe.metadata.IAggregateTypeEnumConstants;

public enum AggregateTypeEnum implements IAggregateTypeEnumConstants
{
    ANY("unknown", "ANY", "automatic"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Any.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    AVG("average", "AVG", "average"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Avg.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    AVG_CALENDAR_DAYS("unknown", "AVG_CALENDAR_DAYS", "UNKNOWN"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Avg.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    AVG_CHILDREN("unknown", "UNKNOWN", "UNKNOWN"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Avg.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    AVG_NON_ZERO("unknown", "AVG_NON_ZERO", "automatic"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Avg.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    AVG_PERIOD("unknown", "AVG_PERIOD", "UNKNOWN"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Avg.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    BY_ACCOUNT("unknown", "UNKNOWN", "UNKNOWN"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return preAggregationDataType;
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    CALC("unknown", "CALC", "UNKNOWN"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return preAggregationDataType;
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    CALCULATED("calculated", "Calculated", "calculated"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return preAggregationDataType;
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    COUNT("count", "COUNT", "count"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Count.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    COUNT_DISTINCT("countDistinct", "COUNT_DISTINCT", "countDistinct"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Count.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    COUNT_NON_ZERO("countNonZero", "COUNT_NON_ZERO", "automatic"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Count.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    CURRENTPERIOD("currentPeriod", "CURRENT_PERIOD", "UNKNOWN"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return LastValue.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    EXTERNAL("unknown", "UNKNOWN", "automatic"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return preAggregationDataType;
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    FIRST("firstPeriod", "FIRST", "UNKNOWN"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return FirstValue.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    FIRST_NON_EMPTY("unknown", "UNKNOWN", "UNKNOWN"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return FirstValue.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    LAST("lastPeriod", "LAST", "UNKNOWN"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return LastValue.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    LAST_NON_EMPTY("unknown", "UNKNOWN", "UNKNOWN"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return LastValue.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    MAX("maximum", "MAX", "maximum"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Max.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return true;
        }
    }
    ,
    MEDIAN("median", "MEDIAN", "median"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Avg.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    MIN("minimum", "MIN", "minimum"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Min.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return true;
        }
    }
    ,
    NONE("none", "NONE", "none"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return preAggregationDataType;
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    UNSUPPORTED("unsupported", "UNSUPPORTED", "unsupported"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return preAggregationDataType;
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    STDDEV("standardDeviation", "STDDEV", "standardDeviation"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return StdDevPop.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    SUM("sum", "SUM", "total"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return Sum.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return true;
        }
    }
    ,
    UNKNOWN("unknown", "UNKNOWN", "automatic"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return preAggregationDataType;
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    }
    ,
    VAR("variance", "VAR", "variance"){

        @Override
        public IDataType getPostAggregationDataType(IDataType preAggregationDataType) {
            return VarPop.getOutputType(new IDataType[]{preAggregationDataType});
        }

        @Override
        public boolean isAdditive() {
            return false;
        }
    };

    private String modelAggregateString;
    private final String mddsStringType;
    private final String v5StringType;

    private AggregateTypeEnum(String modelName, String theMDDSString, String theV5StringType) {
        this.modelAggregateString = modelName;
        this.mddsStringType = theMDDSString;
        this.v5StringType = theV5StringType;
    }

    public String toMDDSType() {
        return this.mddsStringType;
    }

    public String toV5Type() {
        return this.v5StringType;
    }

    public static AggregateTypeEnum valueOf(int ordinal) throws IllegalArgumentException {
        for (AggregateTypeEnum e : AggregateTypeEnum.values()) {
            if (e.ordinal() != ordinal) continue;
            return e;
        }
        StringBuilder buffer = new StringBuilder("Invalid ordinal: ");
        buffer.append(ordinal);
        throw new IllegalArgumentException(buffer.toString());
    }

    public static AggregateTypeEnum valueOfModelString(String name) {
        if (name == null || name.equals("unknown") || name.equals("")) {
            return UNKNOWN;
        }
        for (AggregateTypeEnum e : AggregateTypeEnum.values()) {
            if (!e.modelAggregateString.equals(name)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static AggregateTypeEnum valueOfMDDSString(String name) {
        if (name == null || name.equals("UNKNOWN") || name.equals("")) {
            return UNKNOWN;
        }
        for (AggregateTypeEnum e : AggregateTypeEnum.values()) {
            if (!e.mddsStringType.equals(name)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static AggregateTypeEnum valueOfV5String(String name) {
        if (name == null || name.equals("UNKNOWN") || name.equals("")) {
            return UNKNOWN;
        }
        for (AggregateTypeEnum e : AggregateTypeEnum.values()) {
            if (!e.v5StringType.equals(name)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public String getModelName() {
        return this.modelAggregateString;
    }

    public abstract IDataType getPostAggregationDataType(IDataType var1);

    public abstract boolean isAdditive();
}

