/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata;

public enum DimensionTypeEnum {
    REGULAR("Regular", "regular"),
    MEASURE("Measure", "measure"),
    TIME("Time", "time"),
    SAPTIME("SAPTime", "SAPTime"),
    ACCOUNT("Account", "regular"),
    SCENARIO("Scenario", "regular"),
    ORGANIZATION("Organization", "regular"),
    CUSTOMER("Customer", "regular"),
    GEOGRAPHY("Geography", "regular"),
    BUSINESS_UNIT("Business Unit", "regular"),
    PRODUCT("Product", "regular"),
    UNKNOWN("Unknown", "unknown"),
    CURRENCY("Currency", "currency"),
    ATTRIBUTE("attribute", "attribute"),
    INTERNAL("XQEInternal", "xqeinternal");

    private final String mddsStringType;
    private final String fmStringType;

    private DimensionTypeEnum(String theMDDSString, String theFMString) {
        this.mddsStringType = theMDDSString;
        this.fmStringType = theFMString;
    }

    public String toMDDSType() {
        return this.mddsStringType;
    }

    public String toFMType() {
        return this.fmStringType;
    }

    public static DimensionTypeEnum fromFMDimensionTypeString(String fmDimensionType) {
        for (DimensionTypeEnum e : DimensionTypeEnum.values()) {
            if (!e.toFMType().equals(fmDimensionType)) continue;
            return e;
        }
        return REGULAR;
    }

    public static DimensionTypeEnum fromMDDSTypeString(String mddsType) {
        for (DimensionTypeEnum e : DimensionTypeEnum.values()) {
            if (!e.toMDDSType().equals(mddsType)) continue;
            return e;
        }
        return REGULAR;
    }

    public static DimensionTypeEnum valueOf(int ordinal) {
        for (DimensionTypeEnum e : DimensionTypeEnum.values()) {
            if (e.ordinal() != ordinal) continue;
            return e;
        }
        StringBuilder buffer = new StringBuilder("Invalid ordinal (");
        buffer.append(ordinal);
        buffer.append(")");
        throw new IllegalArgumentException(buffer.toString());
    }
}

