/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata;

import com.cognos.xqe.metadata.IMetadata;

public interface IRelationship
extends IMetadata {
    public static final String ZERO = "zero";
    public static final String ONE = "one";
    public static final String MANY = "many";

    public IMetadata getLeftRefObject();

    public IMetadata getRightRefObject();

    public String getLeftRefObjectId();

    public String getRightRefObjectId();

    public String getExpression();

    public Enum<Cardinality> getLeftCardinality();

    public Enum<Cardinality> getRightCardinality();

    public boolean isMany(Enum<Cardinality> var1);

    public boolean isOne(Enum<Cardinality> var1);

    public boolean isDummy();

    public JoinFilterType getJoinFilterType();

    public String getFJOAdvancedProperty();

    public static enum JoinFilterType {
        FILTER_TYPE_NONE,
        FILTER_TYPE_IN,
        FILTER_TYPE_BETWEEN,
        FILTER_TYPE_TABLE,
        FILTER_TYPE_FLEXIBLE;


        public static JoinFilterType toJoinFilterType(String inValue) {
            String inUppercase = inValue.toUpperCase();
            if ("IN".equals(inUppercase)) {
                return FILTER_TYPE_IN;
            }
            if ("BETWEEN".equals(inUppercase)) {
                return FILTER_TYPE_BETWEEN;
            }
            if ("TABLE".equals(inUppercase)) {
                return FILTER_TYPE_TABLE;
            }
            if ("FLEXIBLE".equals(inUppercase)) {
                return FILTER_TYPE_FLEXIBLE;
            }
            return FILTER_TYPE_NONE;
        }
    }

    public static enum Cardinality {
        ZERO_ONE,
        ZERO_MANY,
        ONE_ONE,
        ONE_MANY;


        public static Cardinality toCardinality(String cardinality) {
            String lowercaseCard = cardinality != null ? cardinality.toLowerCase() : "1:n";
            if ("0:1".equals(lowercaseCard)) {
                return ZERO_ONE;
            }
            if ("0:n".equals(lowercaseCard)) {
                return ZERO_MANY;
            }
            if ("1:1".equals(lowercaseCard)) {
                return ONE_ONE;
            }
            return ONE_MANY;
        }

        public static String getMinCard(Enum<Cardinality> cardinality) {
            if (cardinality.equals((Object)ZERO_ONE) || cardinality.equals((Object)ZERO_MANY)) {
                return IRelationship.ZERO;
            }
            return IRelationship.ONE;
        }

        public static String getMaxCard(Enum<Cardinality> cardinality) {
            if (cardinality.equals((Object)ZERO_ONE) || cardinality.equals((Object)ONE_ONE)) {
                return IRelationship.ONE;
            }
            return IRelationship.MANY;
        }
    }
}

