/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQEUberNodeFactory;
import com.cognos.xqe.ast.macro.MXNodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.v5.V5NodeFactory;
import com.cognos.xqe.ast.v5Exp.V5ExpNodeFactory;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.BinaryType;
import com.cognos.xqe.data.types.BlobType;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.data.types.ClobType;
import com.cognos.xqe.data.types.DataLinkType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.DimensionUniqueNameType;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.FloatType;
import com.cognos.xqe.data.types.HierarchyUniqueNameType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.types.LevelLabelType;
import com.cognos.xqe.data.types.LevelNumberType;
import com.cognos.xqe.data.types.LevelUniqueNameType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.types.MeasureType;
import com.cognos.xqe.data.types.MemberCaptionType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.types.MemberUniqueNameType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.types.NCharType;
import com.cognos.xqe.data.types.NVarcharType;
import com.cognos.xqe.data.types.NullType;
import com.cognos.xqe.data.types.ParentLevelNumberType;
import com.cognos.xqe.data.types.ParentUniqueNameType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.types.SmallintType;
import com.cognos.xqe.data.types.StructType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimeWithTZType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.types.TimestampWithTZType;
import com.cognos.xqe.data.types.UnknownType;
import com.cognos.xqe.data.types.VarBinaryType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.data.types.XmlType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.ICalculationUnknown;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IFolder;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.xml.XMLEscCharacter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetadataUtil {
    private static final String REF_OBJ_TAG_OPEN = "<refobj>";
    private static final String REF_OBJ_TAG_CLOSE = "</refobj>";
    private static final String REFOBJ_VIA_SHORTCUT_TAG_OPEN = "<refobjViaShortcut";
    private static final String TAGS_TOBEREMOVED = "</?refobj>|</?expression>|</?refobjViaShortcut>";
    private static final String EXPRESSION_TAG = "<expression>";
    private static final String EMPTY_STRING = "";
    private static final String POUND = "#";
    private static final Pattern FMID_PATTERN = Pattern.compile("^\\[?([A-Za-z])+\\d+\\]?\\.\\[.*");
    public static final EnumSet<TreeOperatorEnum> TREEOPENUMSELF = EnumSet.of(TreeOperatorEnum.SELF);
    public static final EnumSet<TreeOperatorEnum> TREEOPENUMPARENT = EnumSet.of(TreeOperatorEnum.PARENT);
    public static final EnumSet<TreeOperatorEnum> TREEOPENUMCHILDREN = EnumSet.of(TreeOperatorEnum.CHILDREN);
    public static final EnumSet<TreeOperatorEnum> TREEOPENUMANCESTORS = EnumSet.of(TreeOperatorEnum.ANCESTORS);
    public static final EnumSet<TreeOperatorEnum> TREEOPENUMDESCENDANTS = EnumSet.of(TreeOperatorEnum.DESCENDANTS);
    public static final EnumSet<TreeOperatorEnum> TREEOPENUMSELFANCESTORS = EnumSet.of(TreeOperatorEnum.SELF, TreeOperatorEnum.ANCESTORS);
    public static final EnumSet<TreeOperatorEnum> TREEOPENUMALL = EnumSet.allOf(TreeOperatorEnum.class);
    private static final Map<String, IDataType> DATA_TYPE_MAP = Collections.unmodifiableMap(new HashMap<String, IDataType>(){
        {
            this.put("binary", BinaryType.DEFAULTBINARYTYPE);
            this.put("binaryLength16", BinaryType.DEFAULTBINARYTYPE);
            this.put("blob", BlobType.BLOBTYPE);
            this.put("boolean", BooleanType.BOOLEANTYPE);
            this.put("character", CharType.DEFAULTCHARTYPE);
            this.put("characterLength16", VarcharType.DEFAULTVARCHARTYPE);
            this.put("characterLength32", VarcharType.DEFAULTVARCHARTYPE);
            this.put("date", DateType.DATETYPE);
            this.put("dateTime", TimestampType.TIMESTAMPTYPE);
            this.put("decimal", DecimalType.DEFAULT_DECIMALTYPE);
            this.put("float", FloatType.FLOATTYPE);
            this.put("float32", FloatType.FLOATTYPE);
            this.put("float64", DoubleType.DOUBLETYPE);
            this.put("intervalYM", IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE);
            this.put("int16", SmallintType.SMALLINTTYPE);
            this.put("int32", IntegerType.INTEGERTYPE);
            this.put("int64", LongType.LONGTYPE);
            this.put("nChar", NCharType.DEFAULTNCHARTYPE);
            this.put("nVarChar", NVarcharType.DEFAULTNVARCHARTYPE);
            this.put("numeric", DecimalType.DEFAULT_DECIMALTYPE);
            this.put("textBlob", ClobType.CLOBTYPE);
            this.put("time", TimeType.TIMETYPE);
            this.put("timeInterval", IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE);
            this.put("timeStampTZ", TimestampWithTZType.TIMESTAMPWITHTZTYPE);
            this.put("timeTZ", TimeWithTZType.TIMEWITHTZTYPE);
            this.put("url", DataLinkType.DATALINKTYPE);
            this.put("xml", XmlType.XMLTYPE);
            this.put("struct", StructType.STRUCTTYPE);
            this.put("multiset", MultisetType.MULTISETTYPE);
            this.put("null", NullType.NULLTYPE);
            this.put("unknown", UnknownType.UNKNOWNTYPE);
            this.put("cclDTypeBinary", BinaryType.DEFAULTBINARYTYPE);
            this.put("cclDTypeVarBinary", VarBinaryType.DEFAULTVARBINARYTYPE);
            this.put("cclDTypeString", VarcharType.DEFAULTVARCHARTYPE);
            this.put("cclDTypeBlob", BlobType.BLOBTYPE);
            this.put("cclDTypeTextBlob", ClobType.CLOBTYPE);
            this.put("cclDTypeBoolean", BooleanType.BOOLEANTYPE);
            this.put("cclDTypeDecimal", DecimalType.DEFAULT_DECIMALTYPE);
            this.put("cclDTypeNumeric", DecimalType.DEFAULT_DECIMALTYPE);
            this.put("cclDTypeFloat", FloatType.FLOATTYPE);
            this.put("cclDTypeDouble", DoubleType.DOUBLETYPE);
            this.put("cclDTypeInt16", SmallintType.SMALLINTTYPE);
            this.put("cclDTypeInt32", IntegerType.INTEGERTYPE);
            this.put("cclDTypeInt64", LongType.LONGTYPE);
            this.put("cclDTypeNChar", NCharType.DEFAULTNCHARTYPE);
            this.put("cclDTypeNVarChar", NVarcharType.DEFAULTNVARCHARTYPE);
            this.put("cclDTypeDate2", DateType.DATETYPE);
            this.put("cclDTypeTime2", TimeType.TIMETYPE);
            this.put("cclDTypeDateTime", TimestampType.TIMESTAMPTYPE);
            this.put("cclDTypeInterval2", IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE);
            this.put("cclDTypeYMInterval", IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE);
            this.put("cclDTypeTimestamp2", TimestampType.TIMESTAMPTYPE);
            this.put("cclDTypeTimestampTZ", TimestampWithTZType.TIMESTAMPWITHTZTYPE);
            this.put("cclDTypeTimeTZ", TimeWithTZType.TIMEWITHTZTYPE);
            this.put("cclDTypeVariant", VariantType.VARIANT);
            this.put("cclDTypeUnknown", VariantType.VARIANT);
            this.put("cclDTypeMemberUniqueName", MemberUniqueNameType.DEFAULTMEMBERUNIQUENAMETYPE);
            this.put("cclDTypeDimensionUniqueName", DimensionUniqueNameType.DEFAULTDIMENSIONUNIQUENAMETYPE);
            this.put("cclDTypeParentUniqueName", ParentUniqueNameType.DEFAULTPARENTUNIQUENAMETYPE);
            this.put("cclDTypeHierarchyUniqueName", HierarchyUniqueNameType.DEFAULTHIERARCHYUNIQUENAMETYPE);
            this.put("cclDTypeLevelUniqueName", LevelUniqueNameType.DEFAULTLEVELUNIQUENAMETYPE);
            this.put("cclDTypeMemberCaption", MemberCaptionType.DEFAULTMEMBERCAPTIONTYPE);
            this.put("cclDTypeMemberType", MemberType.MEMBERTYPE);
            this.put("cclDTypeParentLevel", ParentLevelNumberType.DEFAULTPARENTLEVELNUMBERTYPE);
            this.put("cclDTypeLevelNumber", LevelNumberType.LEVELNUMBERTYPE);
            this.put("cclDTypeLevelLabel", LevelLabelType.DEFAULTLEVELLABELTYPE);
            this.put("cclDTypeMeasureItem", MeasureType.MEASURETYPE);
            this.put("cclDTypeURL", DataLinkType.DATALINKTYPE);
            this.put("cclDTypeXml", XmlType.XMLTYPE);
            this.put("CCLDTYPEROW", RowType.ROWTYPE);
            this.put("cclDTypeArray", ArrayType.ARRAYTYPE);
            this.put("cclDTypeMultiset", MultisetType.MULTISETTYPE);
            this.put("cclDTypeNull", NullType.NULLTYPE);
            this.put("cclDTypeStruct", StructType.STRUCTTYPE);
        }
    });
    static final Set<String> INTRINSIC_OBJECTS_SET = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("_memberDescription");
            this.add("_businessKey");
            this.add("_longName");
            this.add("_shortName");
        }
    });

    public static String getProviderCode(ICube cube) {
        return cube.getModelDataSource().getInterface();
    }

    public static String getProviderCode(IDimension dimension) {
        return MetadataUtil.getProviderCode(dimension.getCube());
    }

    public static String getProviderCode(IHierarchy hierarchy) {
        return MetadataUtil.getProviderCode(hierarchy.getDimension());
    }

    public static String getProviderCode(IMember member) {
        return MetadataUtil.getProviderCode(member.getLevel());
    }

    public static String getProviderCode(ILevel level) {
        return MetadataUtil.getProviderCode(level.getHierarchy());
    }

    public static IProperty getPropertyByRole(ILevel aLevel, String roleType) {
        for (IProperty prop : aLevel.getMemberProperties()) {
            if (!prop.getRoles().contains(roleType) && !prop.getName().equals(roleType)) continue;
            return prop;
        }
        return null;
    }

    public static IMetadata findGrandParent(IMetadata metadata) {
        IMetadata parent = metadata.getParentObject();
        if (null == parent) {
            return null;
        }
        return parent.getParentObject();
    }

    public static IMetadata findChild(IMetadata metadata, String name) {
        if (!metadata.hasChildMetadataObjects()) {
            return null;
        }
        List<IMetadata> children = metadata.getChildMetadataObjects();
        for (IMetadata child : children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public static IMetadata findChild(IMetadata metadata, MetadataType type, String name) {
        if (!metadata.hasChildMetadataObjects()) {
            return null;
        }
        List<IMetadata> children = metadata.getChildMetadataObjects();
        for (IMetadata child : children) {
            if (child.getObjectType() != type || !child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public static List<IMetadata> findChildren(IMetadata metadata, MetadataType type) {
        if (!metadata.hasChildMetadataObjects()) {
            return Collections.emptyList();
        }
        List<IMetadata> children = metadata.getChildMetadataObjects();
        ArrayList<IMetadata> result = new ArrayList<IMetadata>(children.size());
        for (IMetadata child : children) {
            if (child.getObjectType() != type) continue;
            result.add(child);
        }
        return result;
    }

    public static IMetadata findPredeccessor(IMetadata metadata, MetadataType type, String name, boolean includeSelf) {
        Iterator<IMetadata> iter = MetadataUtil.predecessorsIterator(metadata, includeSelf);
        while (iter.hasNext()) {
            IMetadata m = iter.next();
            if (m.getObjectType() != type || !m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static IMetadata findPredeccessor(IMetadata metadata, MetadataType type, boolean includeSelf) {
        Iterator<IMetadata> iter = MetadataUtil.predecessorsIterator(metadata, includeSelf);
        while (iter.hasNext()) {
            IMetadata m = iter.next();
            if (m.getObjectType() != type) continue;
            return m;
        }
        return null;
    }

    public static Iterator<IMetadata> descendantsIterator(IMetadata root, boolean includeRoot) {
        LinkedList<IMetadata> initialQueue = new LinkedList<IMetadata>();
        if (includeRoot) {
            initialQueue.add(root);
        } else {
            initialQueue.addAll(root.getChildMetadataObjects());
        }
        return new MetadataDescendentsIterator(initialQueue);
    }

    public static Iterator<IMetadata> predecessorsIterator(IMetadata root, boolean includeRoot) {
        if (includeRoot) {
            return new MetadataPredecessorIterator(root);
        }
        return new MetadataPredecessorIterator(root.getParentObject());
    }

    public static <T extends MetadataRecord> List<T> applyFromSizeRestrictions(List<T> metadataList, IRestrictions restrictions) {
        int from = restrictions.getValueOf(RestrictionType.FROM, 0);
        int size = restrictions.getValueOf(RestrictionType.SIZE, Integer.MAX_VALUE);
        if (from != 0) {
            int toIndex = metadataList.size();
            if (size != 0) {
                size = Math.min(size, metadataList.size());
                toIndex = Math.min(from + size, metadataList.size());
            }
            if (from >= toIndex) {
                return Collections.emptyList();
            }
            return metadataList.subList(from, toIndex);
        }
        if (0 != size) {
            int toIndex = metadataList.size();
            toIndex = Math.min(size, metadataList.size());
            return metadataList.subList(from, toIndex);
        }
        return metadataList;
    }

    public static ICube getCube(IMetadata metadata) {
        IDimension dimension;
        ICube cube = null;
        if (metadata != null && (dimension = MetadataUtil.getDimension(metadata)) != null) {
            cube = dimension.getCube();
        }
        return cube;
    }

    public static IHierarchy getHierarchy(IMetadata metadata) {
        IHierarchy hierarchy = null;
        if (metadata != null) {
            MetadataType objectType = metadata.getObjectType();
            switch (objectType) {
                case HIERARCHY: {
                    hierarchy = (IHierarchy)metadata;
                    break;
                }
                case LEVEL: {
                    hierarchy = ((ILevel)metadata).getHierarchy();
                    break;
                }
                case MEMBER: {
                    ILevel level = ((IMember)metadata).getLevel();
                    if (level == null) break;
                    hierarchy = level.getHierarchy();
                    break;
                }
                case MEASURE: {
                    hierarchy = ((IMeasure)metadata).getHierarchy();
                    break;
                }
                case DIMENSION: {
                    if (!((IDimension)metadata).isMeasuresDimension()) break;
                    hierarchy = ((IDimension)metadata).getDefaultHierarchy();
                    break;
                }
                case CALCULATION: {
                    if (!((ICalculation)metadata).getCalcType().equals("namedSet")) break;
                    hierarchy = ((INamedSet)metadata).getHierarchy();
                    break;
                }
                case QUERY_ITEM: {
                    if (!(metadata instanceof IProperty)) break;
                    hierarchy = ((IProperty)metadata).getHierarchy();
                    break;
                }
                case NAMED_SET: {
                    hierarchy = ((INamedSet)metadata).getHierarchy();
                    break;
                }
            }
        }
        return hierarchy;
    }

    public static ILevel getLevel(IMetadata metadata) {
        ILevel level = null;
        if (metadata != null) {
            List<ILevel> levels;
            if (metadata instanceof ILevel) {
                level = (ILevel)metadata;
            } else if (metadata instanceof IProperty) {
                level = ((IProperty)metadata).getLevel();
            } else if (metadata instanceof IMember) {
                level = ((IMember)metadata).getLevel();
            } else if (metadata instanceof IMeasure) {
                level = ((IMeasure)metadata).getLevel();
            } else if (metadata instanceof INamedSet && (levels = ((INamedSet)metadata).getLevels()) != null && levels.size() == 1) {
                level = levels.get(0);
            }
        }
        return level;
    }

    @Deprecated
    public static String extractExpressionFromModelString(String modelExpression) {
        String expression = modelExpression;
        if (!expression.contains(EXPRESSION_TAG)) {
            return expression;
        }
        int startShortcutPos = expression.indexOf(REFOBJ_VIA_SHORTCUT_TAG_OPEN);
        if (startShortcutPos != -1) {
            int startPosSC = expression.indexOf(REF_OBJ_TAG_OPEN, startShortcutPos);
            int endPosSC = expression.indexOf(REF_OBJ_TAG_CLOSE, startPosSC);
            String expressionSC = expression.substring(startPosSC + REF_OBJ_TAG_OPEN.length(), endPosSC);
            int startPosTarget = expression.indexOf(REF_OBJ_TAG_OPEN, startPosSC + REF_OBJ_TAG_OPEN.length());
            int endPosTarget = expression.indexOf(REF_OBJ_TAG_CLOSE, startPosTarget + REF_OBJ_TAG_OPEN.length());
            String target = expression.substring(startPosTarget + REF_OBJ_TAG_OPEN.length(), endPosTarget);
            String itemReference = null;
            itemReference = MetadataUtil.concatShortcutReferenceWithTargetItemName(expressionSC, target);
            String subExpr = expression.substring(0, startShortcutPos) + itemReference;
            expression = subExpr + expression.substring(endPosTarget + REF_OBJ_TAG_CLOSE.length(), expression.length());
            return MetadataUtil.extractExpressionFromModelString(expression);
        }
        expression = expression.replaceAll(TAGS_TOBEREMOVED, EMPTY_STRING);
        expression = XMLEscCharacter.unescapeString(expression);
        return expression.trim();
    }

    public static String extractExpressionFromModelString(String modelExpression, PlanningEnvironment environment) {
        String expression = modelExpression;
        if (!expression.contains(EXPRESSION_TAG)) {
            return expression;
        }
        int startShortcutPos = expression.indexOf(REFOBJ_VIA_SHORTCUT_TAG_OPEN);
        if (startShortcutPos != -1) {
            int startPosSC = expression.indexOf(REF_OBJ_TAG_OPEN, startShortcutPos);
            int endPosSC = expression.indexOf(REF_OBJ_TAG_CLOSE, startPosSC);
            String expressionSC = expression.substring(startPosSC + REF_OBJ_TAG_OPEN.length(), endPosSC);
            int startPosTarget = expression.indexOf(REF_OBJ_TAG_OPEN, startPosSC + REF_OBJ_TAG_OPEN.length());
            int endPosTarget = expression.indexOf(REF_OBJ_TAG_CLOSE, startPosTarget + REF_OBJ_TAG_OPEN.length());
            String target = expression.substring(startPosTarget + REF_OBJ_TAG_OPEN.length(), endPosTarget);
            String itemReference = null;
            itemReference = RQPUtilities.isShortcutTreatedAsAliasForUnwinding(expressionSC, environment) ? MetadataUtil.concatShortcutReferenceWithTargetItemName(expressionSC, target) : target;
            String subExpr = expression.substring(0, startShortcutPos) + itemReference;
            expression = subExpr + expression.substring(endPosTarget + REF_OBJ_TAG_CLOSE.length(), expression.length());
            return MetadataUtil.extractExpressionFromModelString(expression, environment);
        }
        expression = expression.replaceAll(TAGS_TOBEREMOVED, EMPTY_STRING);
        expression = XMLEscCharacter.unescapeString(expression);
        return expression.trim();
    }

    private static String concatShortcutReferenceWithTargetItemName(String shortcutReference, String target) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse(target, -1);
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_ParsingException, (Throwable)e, target);
        }
        StringBuilder sb = new StringBuilder(shortcutReference);
        for (int i = 2; i < parts.length; ++i) {
            sb.append(".[");
            sb.append(parts[i]);
            sb.append("]");
        }
        return sb.toString();
    }

    public static IDimension getDimension(IMetadata metadata) {
        IDimension dimension = null;
        if (metadata != null) {
            if (metadata instanceof IDimension) {
                dimension = (IDimension)metadata;
            } else if (metadata instanceof IHierarchy) {
                dimension = ((IHierarchy)metadata).getDimension();
            } else if (metadata instanceof ILevel) {
                dimension = ((ILevel)metadata).getDimension();
            } else if (metadata instanceof IProperty) {
                dimension = ((IProperty)metadata).getDimension();
            } else if (metadata instanceof IMember) {
                dimension = ((IMember)metadata).getDimension();
            } else if (metadata instanceof IMeasure) {
                dimension = ((IMeasure)metadata).getDimension();
            } else if (metadata instanceof INamedSet) {
                dimension = ((INamedSet)metadata).getDimension();
            }
        }
        return dimension;
    }

    public static String getKeydateWithConfig(String validFrom, String validTo, boolean useFromDate) {
        DateValue fromDate = DataValueFactory.createDateValue();
        fromDate.set(validFrom);
        DateValue toDate = DataValueFactory.createDateValue();
        toDate.set(validTo);
        return MetadataUtil.getKeydateWithConfig(fromDate, toDate, useFromDate);
    }

    public static String getKeydateWithConfig(DateValue fromDate, DateValue toDate, boolean useFromDate) {
        if (fromDate.isNull() && toDate.isNull()) {
            return null;
        }
        if (useFromDate) {
            if (fromDate.isNull() && toDate.isOK()) {
                return toDate.getString();
            }
            if (fromDate.isOK() && toDate.isOK() && fromDate.compareTo(toDate) >= 0) {
                return null;
            }
            return fromDate.toString();
        }
        if (fromDate.isOK() && toDate.isOK() && fromDate.compareTo(toDate) >= 0) {
            return null;
        }
        if (toDate.isNull()) {
            String dateFormat = "yyyy-MM-dd";
            GregorianCalendar calendar = new GregorianCalendar();
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            return sdf.format(calendar.getTime());
        }
        return toDate.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDataType calculateExpressionDataType(IMetadata metadata) {
        String expression = null;
        if (metadata instanceof IQueryItem) {
            IQueryItem qi = (IQueryItem)metadata;
            expression = qi.getExpression();
        } else if (metadata instanceof IMeasure) {
            IMeasure measure = (IMeasure)metadata;
            expression = measure.getExpression();
        } else if (metadata instanceof ICalculationUnknown) {
            ICalculationUnknown calc = (ICalculationUnknown)metadata;
            expression = calc.getExpression();
        }
        IDataType dataType = null;
        if (expression != null) {
            MetadataConnection connection = metadata.getConnection();
            ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            LoopDetectionChain loopDetectionChain = execEnv.getMetadataLoopDetection();
            if (!loopDetectionChain.push(metadata.getV5UniqueName())) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, "Model Expression", loopDetectionChain.serialize());
            }
            try {
                PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(execEnv.getRequestEnvironment());
                planEnv.setMetdataConnection(connection);
                XQETrace trace = new XQETrace();
                XQEIDGenerator idGenerator = new XQEIDGenerator();
                XQEUberNodeFactory nodeFactory = new XQEUberNodeFactory();
                nodeFactory.addNodeFactory(new V5NodeFactory());
                nodeFactory.addNodeFactory(new V5ExpNodeFactory());
                nodeFactory.addNodeFactory(new MXNodeFactory());
                nodeFactory.setNodeIDGenerator(idGenerator);
                nodeFactory.setTrace(trace);
                nodeFactory.setPlanningEnvironment(planEnv);
                planEnv.setTrace(trace);
                planEnv.setNodeFactory(nodeFactory);
                expression = MetadataUtil.extractExpressionFromModelString(expression, planEnv);
                if (expression.length() == 0) {
                    IDataType iDataType = null;
                    return iDataType;
                }
                if (expression.contains(POUND)) {
                    MacroExpander expander = new MacroExpander();
                    expression = expander.expand(metadata, planEnv, expression);
                }
                IXQEQueryNode node = V5ExpressionProcessor.process(expression, planEnv, connection.getDefaultLocale(metadata));
                dataType = ((V5SimpleNode)node).getDataType();
            }
            finally {
                loopDetectionChain.pop();
            }
        }
        if (dataType == null) {
            dataType = UnknownType.UNKNOWNTYPE;
        }
        return dataType;
    }

    public static int getLevelDistanceOfDescendantsFunc(IRestrictions restrictions) {
        Integer descRangeFlag = restrictions.getValueOf(RestrictionType.DESCENDANTSOPT, null);
        Integer levelDistance = restrictions.getValueOf(RestrictionType.DESCENDANTSLEVELDISTANCE, null);
        if (levelDistance == null) {
            return 1000;
        }
        int intLevelDistance = levelDistance;
        if (descRangeFlag == null) {
            return intLevelDistance;
        }
        switch (descRangeFlag) {
            case 0: 
            case 5: 
            case 7: 
            case 8: {
                return intLevelDistance;
            }
            case 1: {
                return intLevelDistance - 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                return 1000;
            }
        }
        return intLevelDistance;
    }

    public static boolean shortcutTreatedAsAlias(IShortcut shortcut) {
        MetadataConnection mdConnection = shortcut.getConnection();
        IMetadata theTarget = shortcut.getTarget();
        String targetNS = null;
        String shortcutNS = null;
        String targetFolder = null;
        String shortcutFolder = null;
        IMetadata parent = mdConnection.getParentObject(theTarget);
        while (parent != null) {
            if (targetFolder == null && parent instanceof IFolder) {
                targetFolder = parent.getName();
            }
            if (parent instanceof INamespace) {
                targetNS = parent.getName();
                break;
            }
            parent = mdConnection.getParentObject(parent);
        }
        parent = mdConnection.getParentObject(shortcut);
        while (parent != null) {
            if (shortcutFolder == null && parent instanceof IFolder) {
                shortcutFolder = parent.getName();
            }
            if (parent instanceof INamespace) {
                shortcutNS = parent.getName();
                break;
            }
            parent = mdConnection.getParentObject(parent);
        }
        return shortcutNS.equals(targetNS) && (targetFolder == null ? shortcutFolder == null : targetFolder.equals(shortcutFolder));
    }

    public static IDimension getTargetDim(IDimension aDimension) {
        if (aDimension instanceof IAccessedViaShortcut) {
            if (((IAccessedViaShortcut)((Object)aDimension)).isAccessedViaShortcut()) {
                return (IDimension)((IAccessedViaShortcut)((Object)aDimension)).getShortcut().getTarget();
            }
            if (aDimension instanceof IDimension && aDimension.isUnderNamespaceShortcut()) {
                return aDimension.getDimUnderTargetNamespace();
            }
        }
        return aDimension;
    }

    public static IDataType constructDatatype(String mfwDatatype, int scale, int precision) {
        return MetadataUtil.constructDatatype(null, mfwDatatype, scale, precision);
    }

    private static IDataType constructDataType(IMetadata metadata, IDataType dataType) {
        IDataType result = dataType;
        if (dataType == StructType.STRUCTTYPE) {
            StructType sType = DataTypeFactory.getStructType();
            List<IMetadata> metadataObjects = metadata.getChildMetadataObjects();
            for (IMetadata attribute : metadataObjects) {
                sType.addField(attribute.getName(), MetadataUtil.constructDataType(attribute, attribute.getDataType()));
            }
            result = sType;
        } else if (dataType == MultisetType.MULTISETTYPE) {
            List<IMetadata> metadataObjects = metadata.getChildMetadataObjects();
            RowType elementType = DataTypeFactory.getRowType();
            for (IMetadata attribute : metadataObjects) {
                elementType.addField(attribute.getName(), MetadataUtil.constructDataType(attribute, attribute.getDataType()));
            }
            result = DataTypeFactory.getMultisetType(elementType);
        }
        return result;
    }

    public static IDataType convertDataType(String mfwType) {
        return DATA_TYPE_MAP.get(mfwType);
    }

    public static IDataType constructDatatype(IMetadata metadata, String mfwDatatype, int scale, int precision) {
        IDataType dataType = MetadataUtil.convertDataType(mfwDatatype);
        if (dataType == null) {
            dataType = DataTypeFactory.getType(mfwDatatype);
        }
        if (dataType == DecimalType.DEFAULT_DECIMALTYPE) {
            dataType = DataTypeFactory.getDecimalType(precision, scale);
        } else if (dataType == SmallintType.SMALLINTTYPE) {
            dataType = DataTypeFactory.getSmallintType(scale);
        } else if (dataType == IntegerType.INTEGERTYPE) {
            dataType = DataTypeFactory.getIntegerType(scale);
        } else if (dataType == LongType.LONGTYPE) {
            dataType = DataTypeFactory.getLongType(scale);
        } else if (dataType == NVarcharType.DEFAULTNVARCHARTYPE) {
            if (precision != 0) {
                dataType = DataTypeFactory.getNVarcharType(precision);
            }
        } else if (dataType == NCharType.DEFAULTNCHARTYPE) {
            if (precision != 0) {
                dataType = DataTypeFactory.getNCharType(precision);
            }
        } else if (dataType == CharType.DEFAULTCHARTYPE) {
            if (precision != 0) {
                dataType = DataTypeFactory.getCharType(precision);
            }
        } else if (dataType == VarcharType.DEFAULTVARCHARTYPE) {
            if (precision != 0) {
                dataType = DataTypeFactory.getVarcharType(precision);
            }
        } else if (dataType == ArrayType.ARRAYTYPE) {
            IMetadata childObj = metadata.getChildMetadataObjects().get(0);
            dataType = DataTypeFactory.getArrayType(childObj.getDataType(), precision);
        } else if (dataType == StructType.STRUCTTYPE || dataType == MultisetType.MULTISETTYPE) {
            dataType = MetadataUtil.constructDataType(metadata, dataType);
        }
        return dataType;
    }

    public static boolean isIdForPackage(String ref) {
        Matcher matcher = FMID_PATTERN.matcher(ref);
        return matcher.matches();
    }

    public static String generateUniqueName(String suggestedName, List<IMetadata> mdObjects) {
        HashSet<String> usedNames = new HashSet<String>();
        for (IMetadata q : mdObjects) {
            usedNames.add(q.getName());
        }
        return MetadataUtil.generateUniqueName(suggestedName, usedNames);
    }

    public static String generateUniqueName(String suggestedName, Set<String> usedNames) {
        int i;
        String name = suggestedName;
        int maxIters = 100000;
        for (i = 1; i < 100000 && usedNames.contains(name); ++i) {
            name = suggestedName + i;
        }
        if (i == 100000) {
            throw new RuntimeException("Internal error. Maximum number of iterations exceeded in MetadataUtil.generateUniqueName()");
        }
        return name;
    }

    public static boolean isVisibleRole(String roleName) {
        return !roleName.startsWith("_") || MetadataUtil.isAlwaysVisibleBuiltinRole(roleName);
    }

    private static boolean isAlwaysVisibleBuiltinRole(String name) {
        if (INTRINSIC_OBJECTS_SET.size() > 0) {
            for (String propertyName : INTRINSIC_OBJECTS_SET) {
                if (!propertyName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static INamespace getParentNamespace(IMetadata obj) {
        IMetadata parent;
        for (parent = obj.getParentObject(); parent != null && !(parent instanceof INamespace); parent = parent.getParentObject()) {
        }
        if (parent != null) {
            return (INamespace)parent;
        }
        return null;
    }

    private static class MetadataPredecessorIterator
    implements Iterator<IMetadata> {
        private IMetadata next;

        MetadataPredecessorIterator(IMetadata first) {
            this.next = first;
        }

        @Override
        public boolean hasNext() {
            return null != this.next;
        }

        @Override
        public IMetadata next() {
            IMetadata result = this.next;
            if (null == result) {
                throw new NoSuchElementException();
            }
            this.next = this.next.getParentObject();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MetadataDescendentsIterator
    implements Iterator<IMetadata> {
        private final LinkedList<IMetadata> queue = new LinkedList();

        MetadataDescendentsIterator(List<IMetadata> initialQueue) {
            this.queue.addAll(initialQueue);
        }

        @Override
        public boolean hasNext() {
            return this.queue.size() > 0;
        }

        @Override
        public IMetadata next() {
            IMetadata next = this.queue.poll();
            if (null == next) {
                throw new NoSuchElementException();
            }
            this.queue.addAll(next.getChildMetadataObjects());
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

