/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.mdquery.MDMetadataQuery;
import com.cognos.xqe.metadata.mdquery.parser.PropertiesLibrary;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.util.LocalizedString;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class MDMetadataResponse {
    private static final String EMPTY_STRING = "";
    private static final String XML_NAMESPACE = "";
    private static final String XML_ELEMENT_ENTITY = "entity";
    private static final String XML_ELEMENT_RESPONSE = "response";
    private static final String XML_ELEMENT_CONNECTION = "connectionID";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private List<Entity> entities = new LinkedList<Entity>();
    private Map<String, String> locales = null;

    private MDMetadataResponse() {
    }

    public static MDMetadataResponse constructRecordResponse(MDMetadataQuery query, List<? extends MetadataRecord> records) {
        MDMetadataResponse response = new MDMetadataResponse();
        response.locales = query.getLocales();
        for (MetadataRecord metadataRecord : records) {
            Entity entity = response.new Entity();
            for (String prop : query.getProperties()) {
                MDMetadataResponse.addPropertyValue(entity, prop, metadataRecord);
            }
            response.entities.add(entity);
        }
        return response;
    }

    public static MDMetadataResponse constructLocaleResponse(MDMetadataQuery query, List<String> locales) {
        MDMetadataResponse response = new MDMetadataResponse();
        for (String locale : locales) {
            Entity entity = response.new Entity();
            entity.put("language", (Object)locale);
            response.entities.add(entity);
        }
        return response;
    }

    private static void addPropertyValue(Entity entity, String property, MetadataRecord record) {
        String mappedPropertyStr = PropertiesLibrary.getMappedProperty(record.getRecordType(), property);
        if (mappedPropertyStr == null) {
            return;
        }
        Object value = null;
        value = mappedPropertyStr.startsWith("@") ? record.getDynamicField(mappedPropertyStr.substring(1)) : MDMetadataResponse.getPropertyValue(property, record, mappedPropertyStr);
        if (value != null) {
            entity.put(property, value);
        }
    }

    private static Object getPropertyValue(String property, MetadataRecord record, String methodName) {
        Object value = null;
        Class[] params = new Class[]{};
        Object[] args = new Object[]{};
        try {
            Method method = record.getClass().getMethod(methodName, params);
            value = method.invoke((Object)record, args);
            value = PropertiesLibrary.translatePropertyValue(property, value);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        return value;
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeStartElement("", XML_ELEMENT_RESPONSE);
        writer.writeStartElement("", XML_ELEMENT_CONNECTION);
        writer.writeAttribute(XML_ATTRIBUTE_VALUE, "***");
        writer.writeEndElement();
        for (Entity entity : this.entities) {
            entity.writeXML(writer);
        }
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    private class Entity
    extends TreeMap<String, Object> {
        private static final long serialVersionUID = 1L;
        private static final String DEFAULT_PRECISION_SCALE_VALUE = "0";
        private static final String PROPERTY_DATA_TYPE = "Data_Type";
        private static final String PROPERTY_SCALE = "Scale";
        private static final String PROPERTY_PRECISION = "Precision";
        private static final String XML_ATTRIBUTE_LOCALE = "locale";
        private static final String XML_ATTRIBUTE_CAPTION = "Caption";
        private static final String XML_ELEMENT_ALIAS = "alias";

        Entity() {
        }

        @Override
        public Object put(String key, Object value) {
            Object obj = null;
            if (value instanceof IDataType) {
                IDataType type = (IDataType)value;
                obj = key.equals(PROPERTY_PRECISION) ? (type.hasPrecision() ? super.put(PROPERTY_PRECISION, type.getPrecision()) : super.put(PROPERTY_PRECISION, DEFAULT_PRECISION_SCALE_VALUE)) : (key.equals(PROPERTY_SCALE) ? (type.hasScale() ? super.put(PROPERTY_SCALE, type.getScale()) : super.put(PROPERTY_SCALE, DEFAULT_PRECISION_SCALE_VALUE)) : (key.equals(PROPERTY_DATA_TYPE) ? super.put(PROPERTY_DATA_TYPE, type.getTypeName()) : super.put(key, type.getTypeName())));
            } else {
                obj = super.put(key, value);
            }
            return obj;
        }

        public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("", MDMetadataResponse.XML_ELEMENT_ENTITY);
            LocalizedString caption = null;
            for (String key : this.keySet()) {
                if (key.equals(XML_ATTRIBUTE_CAPTION)) {
                    caption = (LocalizedString)this.get(key);
                }
                writer.writeAttribute(key, this.get(key).toString());
            }
            if (caption != null && MDMetadataResponse.this.locales != null) {
                List<String> supportedLocales = Arrays.asList(caption.getSupportedLocales());
                for (String locale : MDMetadataResponse.this.locales.keySet()) {
                    if (locale.equals(caption.getDefaultLocale()) || !supportedLocales.contains(locale)) continue;
                    writer.writeStartElement("", XML_ELEMENT_ALIAS);
                    writer.writeAttribute(XML_ATTRIBUTE_CAPTION, caption.toString(locale));
                    writer.writeAttribute(XML_ATTRIBUTE_LOCALE, locale);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
    }
}

