/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery.parser;

import com.cognos.pogo.util.base64;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.connection.properties.ConnectionProperties;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.mdquery.parser.ConnectionPropertyMapper;
import com.cognos.xqe.metadata.mdquery.parser.MDDataSource;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ConnectionHandler
implements IStaxComponentHandler {
    private static final String PARAM_PRODUCT_LOCALE = "productLocale";
    private static final String PARAM_RUN_LOCALE = "runLocale";
    private static final String XML_ELEMENT_CUBE = "cube";
    private static final String XML_ELEMENT_CATALOG = "catalog";
    static final String PROVIDER_TYPE = "providerType";
    private static final String XML_ELEMENT_DATA_SOURCE_NAME = "dataSourceName";
    private static final String XML_ELEMENT_DATA_SOURCE_TYPE = "dataSourceType";
    private static final String XML_ELEMENT_DATA_PASSWORD = "password";
    private static final String XML_ELEMENT_DATA_CUBE_PASSWORD = "cubePassword";
    private static final String XML_ELEMENT_DATA_SAP_TICKET = "SAPLogonTicket";
    private static final String EMPTY_STRING = "";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private static final String NAMESPACE = "";
    public static final String XML_ELEM_OIDC_ACCESS_TOKEN = "oidcAccessToken";
    public static final String XML_ELEM_OIDC_ID_TOKEN = "oidcIdToken";
    private static final String UTF_8_CHARSET = "UTF-8";
    private MetadataQueryArguments queryArgs = null;
    private String runLocale = "";
    private RequestEnvironment reqEnv = null;

    @Override
    public void consume(XMLStreamReader reader) throws XMLStreamException {
        this.reset();
        TreeMap<String, String> params = new TreeMap<String, String>();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        String dsName = "MDQueryDataSource";
        while (childIter.next()) {
            String name = reader.getLocalName();
            if (name.equals(XML_ELEMENT_DATA_SOURCE_NAME)) {
                dsName = reader.getAttributeValue("", XML_ATTRIBUTE_VALUE);
                params.put(name, dsName);
                StaxUtil.skipElement(reader);
                continue;
            }
            if (name.equals(XML_ELEMENT_DATA_SOURCE_TYPE)) {
                String providerName = reader.getAttributeValue("", XML_ATTRIBUTE_VALUE);
                String providerType = DataSourceTypeEnum.getProviderCode(providerName);
                if (null == providerType) {
                    throw new RuntimeException("Unsupported Provider Name: " + providerName);
                }
                params.put(PROVIDER_TYPE, providerType);
                StaxUtil.skipElement(reader);
                continue;
            }
            if (name.equals(XML_ELEMENT_DATA_PASSWORD) || name.equals(XML_ELEMENT_DATA_CUBE_PASSWORD) || name.equals(XML_ELEMENT_DATA_SAP_TICKET) || XML_ELEM_OIDC_ACCESS_TOKEN.equals(name) || XML_ELEM_OIDC_ID_TOKEN.equals(name)) {
                String value = reader.getAttributeValue("", XML_ATTRIBUTE_VALUE);
                if (value == null || value.length() == 0) {
                    ChildElementIterator iter = new ChildElementIterator(reader);
                    while (iter.next()) {
                        String encrypted = reader.getAttributeValue("", XML_ATTRIBUTE_VALUE);
                        String string = this.decrypt(encrypted);
                        StaxUtil.skipElement(reader);
                        if (string == null) continue;
                        params.put(name, string);
                    }
                    continue;
                }
                params.put(name, reader.getAttributeValue("", XML_ATTRIBUTE_VALUE));
                StaxUtil.skipElement(reader);
                continue;
            }
            params.put(name, reader.getAttributeValue("", XML_ATTRIBUTE_VALUE));
            StaxUtil.skipElement(reader);
        }
        HashMap<String, Object> metadataProps = new HashMap<String, Object>();
        metadataProps.put(XML_ELEMENT_CATALOG, params.get(XML_ELEMENT_CATALOG));
        metadataProps.put(XML_ELEMENT_CUBE, params.get(XML_ELEMENT_CUBE));
        this.queryArgs = null;
        Map<String, String> convertedParams = ConnectionPropertyMapper.toConnStr((String)params.get(PROVIDER_TYPE), params);
        ConnectionProperties properties = new ConnectionProperties((String)params.get(PROVIDER_TYPE));
        for (Map.Entry entry : convertedParams.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (null == value || value.length() <= 0 || !properties.contains(name)) continue;
            try {
                properties.setValue(name, value);
            }
            catch (IllegalArgumentException ex) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_IllegalConnectionProperty, ex, (Object)properties.getProviderType(), (Object)name, (Object)value);
            }
        }
        if (!properties.isValid()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_InvalidConnectionProperties, properties.getProviderType(), properties.toString());
        }
        String connStr = properties.toString();
        this.runLocale = (String)params.get(PARAM_RUN_LOCALE);
        String string = (String)params.get(PARAM_PRODUCT_LOCALE);
        if (null == this.reqEnv) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_RequestEnvironmentMissing_INTERNAL);
        }
        if (null != string && string.length() != 0) {
            this.reqEnv.setProductLocale(string);
        }
        if (null != this.runLocale && this.runLocale.length() != 0) {
            this.reqEnv.setRunLocale(this.runLocale);
        }
        MDDataSource dataSource = new MDDataSource(dsName, (String)params.get(PROVIDER_TYPE), params, connStr, metadataProps);
        this.queryArgs = MetadataQueryArguments.buildArguments(dataSource, (ExecutionEnvironment)this.reqEnv.getExecutionEnvironment(), null);
    }

    public void setRequestEnvironment(RequestEnvironment aReqEnv) {
        this.reqEnv = aReqEnv;
    }

    public void reset() {
        this.queryArgs = null;
    }

    public MetadataQueryArguments getQueryArguments() {
        return this.queryArgs;
    }

    public String getRunLocale() {
        return this.runLocale;
    }

    private String decrypt(String encrypted) {
        String decrypted = null;
        byte[] data = base64.decode((int)0, (String)encrypted);
        try {
            data = CryptoProvider.decrypt((byte[])data);
            decrypted = new String(data, UTF_8_CHARSET);
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.SEC_DecryptionFailure, (Throwable)ex);
        }
        return decrypted;
    }
}

