/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery.parser;

import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.metadata.mdquery.parser.ConstraintsLibrary;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ConstraintsHandler
implements IStaxComponentHandler {
    private static final String SYM_VALUE_START_END = "'";
    private static final String SYM_NAME_END = "=";
    private static final String SYM_NAME_START = "@";
    private static final String XML_NAMESPACE = "";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private static final String XML_ATTRIBUTE_CONDITION = "condition";
    private static final String XML_ELEMENT_CONSTRAINT = "constraint";
    private static final String XML_ELEMENT_PROVIDER_CONSTRAINTS = "providerConstraints";
    private MetadataRestriction restrictions = null;

    public ConstraintsHandler() {
        this.reset();
    }

    @Override
    public void consume(XMLStreamReader reader) throws XMLStreamException {
        this.reset();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String name = reader.getLocalName();
            if (name.equals(XML_ELEMENT_CONSTRAINT)) {
                String value = reader.getAttributeValue(XML_NAMESPACE, XML_ATTRIBUTE_CONDITION);
                this.processConstraint(value);
                StaxUtil.skipElement(reader);
                continue;
            }
            if (name.equals(XML_ELEMENT_PROVIDER_CONSTRAINTS)) {
                this.processProviderConstraints(reader);
                continue;
            }
            StaxUtil.skipElement(reader);
        }
    }

    private void processConstraint(String condition) {
        int startIdx = condition.indexOf(SYM_NAME_START) + 1;
        int endIdx = condition.indexOf(SYM_NAME_END);
        String name = condition.substring(startIdx, endIdx);
        startIdx = condition.indexOf(SYM_VALUE_START_END) + 1;
        endIdx = condition.lastIndexOf(SYM_VALUE_START_END);
        String value = condition.substring(startIdx, endIdx);
        ConstraintsLibrary.addMetadataRestriction(this.restrictions, name, value);
    }

    private void processProviderConstraints(XMLStreamReader reader) throws XMLStreamException {
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String name = reader.getLocalName();
            if (name != null && name.equals(XML_ELEMENT_CONSTRAINT)) {
                String condition = reader.getAttributeValue(XML_NAMESPACE, XML_ATTRIBUTE_CONDITION);
                this.processConstraint(condition);
            } else {
                String value = reader.getAttributeValue(XML_NAMESPACE, XML_ATTRIBUTE_VALUE);
                ConstraintsLibrary.addMetadataRestriction(this.restrictions, name, value);
            }
            StaxUtil.skipElement(reader);
        }
    }

    public MetadataRestriction getRestrictions() {
        return this.restrictions;
    }

    public void reset() {
        this.restrictions = new MetadataRestriction();
    }
}

