/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery.parser;

import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnection;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnectionSignon;
import com.cognos.xqe.data.model.AbstractDataSource;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.metadata.mdquery.parser.MDDataSourceConnection;
import com.cognos.xqe.security.EncryptedObject;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqebifw.bibushandler.content.GenCredCommand;
import java.util.Locale;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

final class MDDataSource
extends AbstractDataSource {
    private final IDataSourceConnection connection;

    MDDataSource(String theName, String theType, Map<String, String> parameters, String theConnectionString, Map<String, Object> theMetadataProperties) {
        super(theName, theType, theMetadataProperties);
        IEncryptedObject<String> oidcIdToken = null;
        IEncryptedObject<String> oidcAccessToken = null;
        if ("TMR".equals(theType)) {
            String oidcIdTokenParam = parameters.get("oidcIdToken");
            String oidcAccessTokenParam = parameters.get("oidcAccessToken");
            if (oidcAccessTokenParam != null && oidcIdTokenParam != null) {
                oidcIdToken = new EncryptedObject<String>(oidcIdTokenParam);
                oidcAccessToken = new EncryptedObject<String>(oidcAccessTokenParam);
            }
            if (null == oidcIdToken) {
                String paramCamPassport = parameters.get("CAMPassport");
                String nameSpace = parameters.get("namespace");
                String paramLocale = parameters.get("productLocale");
                if (paramCamPassport != null && nameSpace != null && paramLocale != null) {
                    DataSourceConnection.Credentials credentials;
                    Locale productLocale = new Locale(paramLocale);
                    CAMPassport camPassport = new CAMPassport();
                    camPassport.setId(paramCamPassport);
                    GenCredCommand credRetriever = new GenCredCommand(nameSpace, camPassport, theConnectionString, productLocale);
                    String encryptedVal = credRetriever.getEncryptedCredentials();
                    if (encryptedVal != null && (credentials = DataSourceConnection.retrieveCredentials(encryptedVal)) != null) {
                        oidcIdToken = credentials.getIdToken();
                        oidcAccessToken = credentials.getAccessToken();
                    }
                }
            }
        }
        IDataSourceConnectionSignon signon = DataSourceConnectionSignon.createSignon(this.getType(), "MDDataSourceConnectionSignon", null, parameters.get("username"), new EncryptedObject<String>(parameters.get("password")), parameters.get("SSOTicket"), null, new EncryptedObject<String>(parameters.get("cubePassword")), parameters.get("userClassIds"), null, null, null, oidcIdToken, oidcAccessToken, null, null);
        this.connection = new MDDataSourceConnection(theConnectionString, signon);
        if (LOGGER.isOn()) {
            LOGGER.log("Create new " + this.toString());
        }
    }

    @Override
    public Element asXML() {
        Element dataSourceElement = DocumentHelper.createElement((String)"dataSource");
        Element nameElement = dataSourceElement.addElement("name");
        nameElement.addAttribute("value", this.getName());
        Element typeElement = dataSourceElement.addElement("type");
        typeElement.addAttribute("value", this.getType());
        dataSourceElement.add(this.connection.asXML());
        return dataSourceElement;
    }

    @Override
    public IDataSourceConnection getDataSourceConnection() throws DataSourceException, XQESOAPFaultException {
        return this.connection;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getName());
        buffer.append("[connection=").append(this.getDataSourceConnection().toString());
        buffer.append(", metadataProps=").append(this.getMetadataProperties().toString());
        buffer.append("]");
        return buffer.toString();
    }
}

