/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery.parser;

import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionCommandBlock;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.connection.ConnectionStringBuilder;
import com.cognos.xqe.exception.XQESOAPFaultException;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

final class MDDataSourceConnection
implements IDataSourceConnection {
    private final String connectionString;
    private final IDataSourceConnectionSignon signon;
    private String userGroups;

    MDDataSourceConnection(String theConnectionString, IDataSourceConnectionSignon theSignon) {
        this.connectionString = theConnectionString;
        this.signon = theSignon;
        this.userGroups = null;
    }

    @Override
    public String getConnectionString(IDataSourceConnectionSignon dataSourceConnectionSignon) {
        return ConnectionStringBuilder.substituteSignonInConnectionString(this.connectionString, dataSourceConnectionSignon);
    }

    @Override
    public String getConnectionString() {
        return this.getConnectionString(this.signon);
    }

    @Override
    public IDataSourceConnectionSignon getSignon() throws DataSourceException, XQESOAPFaultException {
        return this.signon;
    }

    public String getEncryptedSignonString() {
        return null;
    }

    public void setEncryptedSigonString(String encryptedSignonString) {
    }

    @Override
    public Object getConnectionParameter(String key) {
        return null;
    }

    @Override
    public void setConnectionParameter(String key, Object value) {
    }

    @Override
    public List<IDataSourceConnectionCommandBlock> getCommandBlock(Commands key) {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getIsolationLevel() {
        return null;
    }

    @Override
    public String getApiToken() {
        return null;
    }

    @Override
    public String getSearchPath() {
        return null;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public Element asXML() {
        Element connectionElement = DocumentHelper.createElement((String)"connection");
        Element nameElement = connectionElement.addElement("name");
        nameElement.addAttribute("value", "MDDataSourceConnection");
        if (this.getSignon() != null) {
            connectionElement.add(this.getSignon().asXML());
        }
        return connectionElement;
    }

    @Override
    public boolean hasResolvedSignon() {
        return true;
    }

    @Override
    public void invalidateResolvedSignon() {
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("MDDataSourceConnection[name=").append(this.getName());
        buffer.append(", connectionString=").append(this.getConnectionString(null));
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String getUserGroups() {
        return this.userGroups;
    }

    @Override
    public void setUserGroups(String newUserGroups) {
        this.userGroups = newUserGroups;
    }

    @Override
    public boolean isModelConnection() {
        return false;
    }

    @Override
    public String getEncryptedSignon() {
        return null;
    }

    @Override
    public String getDBUserNameFromConnectionElementOrCredential() {
        return null;
    }
}

