/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.mdquery.parser;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.mdquery.MDQueryAdapter;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.trace.LogLevel;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class PropertiesLibrary {
    private static final String HAS_CHILDREN = "Has_Children";
    private static final String GET_NAME = "getName";
    private static final String GET_UNIQUE_NAME = "getUniqueName";
    private static final String M_IS_HIDDEN = "isHidden";
    private static final String IS_HIDDEN = "Is_Hidden";
    private static final String SCALE = "Scale";
    private static final String PRECISION = "Precision";
    private static final String GET_DATA_TYPE = "getDataType";
    private static final String MEMBER_NAME = "Member_Name";
    private static final String MEMBER_UNIQUE_NAME = "Member_Unique_Name";
    private static final String LEVEL_UNIQUE_NAME = "Level_Unique_Name";
    private static final String GET_HIERARCHY_UNIQUE_NAME = "getHierarchyUniqueName";
    private static final String HIERARCHY_UNIQUE_NAME = "Hierarchy_Unique_Name";
    private static final String GET_DIMENSION_UNIQUE_NAME = "getDimensionUniqueName";
    private static final String DIMENSION_UNIQUE_NAME = "Dimension_Unique_Name";
    private static final String CUBE_NAME = "Cube_Name";
    private static final String CATALOG_NAME = "Catalog_Name";
    private static final String CAPTION = "Caption";
    public static final String EMPTY_STRING = "";
    private static Map<String, String> commonLib = new HashMap<String, String>();
    private static Map<RecordType, Map<String, String>> recordsLib = new HashMap<RecordType, Map<String, String>>();

    public static String getMappedProperty(RecordType recordType, String propertyName) {
        String methodName;
        Map<String, String> propertiesMap = recordsLib.get((Object)recordType);
        if (propertiesMap == null) {
            MDQueryAdapter.getLogger().log(LogLevel.ERROR, "Properties Library for " + recordType.name() + " doesn't exist.");
        }
        if ((methodName = propertiesMap.get(propertyName)) == null) {
            methodName = commonLib.get(propertyName);
        }
        return methodName;
    }

    public static Object translatePropertyValue(String propertyName, Object obj) {
        Object value = EMPTY_STRING;
        if (propertyName.equals(CAPTION)) {
            value = obj;
        } else if (propertyName.equals(HAS_CHILDREN)) {
            Integer num = (Integer)obj;
            value = String.valueOf(num > 0);
        } else if (obj instanceof Enum) {
            Class[] args = new Class[]{};
            Object[] params = new Object[]{};
            try {
                Method method = obj.getClass().getMethod("toMDDSType", args);
                value = (String)method.invoke(obj, params);
            }
            catch (Exception e) {
                value = obj.toString();
            }
        } else if (obj instanceof IDataType) {
            value = obj;
        } else if (obj != null) {
            value = obj.toString();
        }
        return value;
    }

    static {
        commonLib.put(CAPTION, "getCaption");
        commonLib.put("Description", "getDescription");
        commonLib.put(CATALOG_NAME, "getCatalogName");
        commonLib.put("Schema_Name", "getSchemaName");
        commonLib.put(CUBE_NAME, "getCubeName");
        commonLib.put(DIMENSION_UNIQUE_NAME, GET_DIMENSION_UNIQUE_NAME);
        commonLib.put(HIERARCHY_UNIQUE_NAME, GET_HIERARCHY_UNIQUE_NAME);
        commonLib.put(LEVEL_UNIQUE_NAME, "getLevelUniqueName");
        commonLib.put("Level_Number", "getLevelNumber");
        commonLib.put(MEMBER_UNIQUE_NAME, "getMemberUniqueName");
        commonLib.put(MEMBER_NAME, "getMemberName");
        commonLib.put("Cardinality", "getCardinality");
        commonLib.put("Data_Type", GET_DATA_TYPE);
        commonLib.put(PRECISION, GET_DATA_TYPE);
        commonLib.put(SCALE, GET_DATA_TYPE);
        commonLib.put("PPDS_CODE", "getUniqueId");
        commonLib.put(IS_HIDDEN, M_IS_HIDDEN);
        commonLib.put("Display_Path", "getDisplayPath");
        commonLib.put("Type", "getType");
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("Name", GET_UNIQUE_NAME);
        action.put("CommandType", "getCommandType");
        action.put("Command", "getCommand");
        action.put("CoordinateType", "getCoordinateType");
        action.put("CoordinateValue", "getCoordinateValue");
        recordsLib.put(RecordType.ACTION, action);
        HashMap<String, String> alias = new HashMap<String, String>();
        alias.put("Alias_Table_Name", GET_NAME);
        recordsLib.put(RecordType.ALIAS, alias);
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("Attribute_Name", GET_NAME);
        attr.put("Attribute_Unique_Name", GET_UNIQUE_NAME);
        attr.put("Role", "getRoleType");
        recordsLib.put(RecordType.PROPERTY, attr);
        HashMap<String, String> catalog = new HashMap<String, String>();
        catalog.put(CATALOG_NAME, GET_UNIQUE_NAME);
        recordsLib.put(RecordType.CATALOG, catalog);
        HashMap<String, String> cube = new HashMap<String, String>();
        cube.put(CUBE_NAME, GET_UNIQUE_NAME);
        cube.put("Created_On", "getCreatedDate");
        cube.put("Last_Schema_Update", "getSchemaUpdateDate");
        cube.put("Last_Data_Update", "getDataUpdateDate");
        cube.put("Current_Period", "getCurrentPeriod");
        cube.put("Default_Measure", "@DefaultMeasure");
        cube.put("Suppression", "getSuppressionType");
        cube.put("Is_Optimized", "getIsOptimized");
        recordsLib.put(RecordType.CUBE, cube);
        HashMap<String, String> dim = new HashMap<String, String>();
        dim.put(DIMENSION_UNIQUE_NAME, GET_UNIQUE_NAME);
        dim.put("Dimension_Name", GET_NAME);
        dim.put("Default_Hierarchy", "getDefaultHierarchyUniqueName");
        dim.put("Measure_Dimension", "getIsMeasureDimension");
        dim.put("Regular_Dimension", null);
        dim.put("Time_Dimension", null);
        dim.put("Dimension_Group_Name", "getDimensionGroupName");
        dim.put("Dimension_Group_Description", "getDimensionGroupDescription");
        dim.put(IS_HIDDEN, M_IS_HIDDEN);
        recordsLib.put(RecordType.DIMENSION, dim);
        HashMap<String, String> hier = new HashMap<String, String>();
        hier.put(HIERARCHY_UNIQUE_NAME, GET_UNIQUE_NAME);
        hier.put("Hierarchy_Name", GET_NAME);
        hier.put("Balanced_Hierarchy", "isBalanced");
        hier.put("Ragged_Hierarchy", "isRagged");
        hier.put("Parent_Child_Hierarchy", "isParentChild");
        hier.put("Default_Member", "getDefaultMemberUniqueName");
        hier.put("Highest_Level_Rollup", "getHighestRollupMemberUniqueName");
        hier.put("Level_Semantics", null);
        hier.put("SSAS_Attribute_Hierarchy", "getAttributeHierarchy");
        hier.put("Valid_From", "getValidFrom");
        hier.put("Valid_To", "getValidTo");
        hier.put(IS_HIDDEN, M_IS_HIDDEN);
        recordsLib.put(RecordType.HIERARCHY, hier);
        HashMap<String, String> lvl = new HashMap<String, String>();
        lvl.put(LEVEL_UNIQUE_NAME, GET_UNIQUE_NAME);
        lvl.put("Level_Name", GET_NAME);
        lvl.put("Is_Unique", "hasUniqueMemberNames");
        lvl.put("Base_Attribute_Hierarchy", "getAttributeHierarchyName");
        lvl.put(IS_HIDDEN, M_IS_HIDDEN);
        recordsLib.put(RecordType.LEVEL, lvl);
        HashMap<String, String> macro = new HashMap<String, String>();
        macro.put("Macro_Name", GET_NAME);
        macro.put("Macro_Type", GET_DATA_TYPE);
        recordsLib.put(RecordType.MACRO, macro);
        HashMap<String, String> meas = new HashMap<String, String>();
        meas.put("Measure_Unique_Name", GET_UNIQUE_NAME);
        meas.put("Measure_Name", GET_NAME);
        meas.put("Aggregator", "getRegularAggregate");
        meas.put("Units", "getUnits");
        meas.put("Timestate_Aggregator", "getSemiAggregate");
        meas.put("Timestate_Aggregator_Dimension", "getTimestateAggregatorDimension");
        meas.put(PRECISION, null);
        meas.put(SCALE, null);
        meas.put("Measure_Folder", "getMeasureFolder");
        meas.put("Format", null);
        recordsLib.put(RecordType.MEASURE, meas);
        HashMap<String, String> member = new HashMap<String, String>();
        member.put(MEMBER_UNIQUE_NAME, GET_UNIQUE_NAME);
        member.put(MEMBER_NAME, GET_NAME);
        member.put("Parent_Unique_Name", "getParentUniqueName");
        member.put(HAS_CHILDREN, "getChildCardinality");
        member.put("Number_Of_Parents", "getParentCount");
        member.put("Parent_Level", "getParentLevelNumber");
        member.put("_rollupType", "getRollupType");
        member.put("Is_Suppressed", null);
        member.put("Suppressed_Parent_Count", null);
        recordsLib.put(RecordType.MEMBER, member);
        HashMap<String, String> set = new HashMap<String, String>();
        set.put("Named_Set_Name", GET_NAME);
        set.put("Expression", "getExpression");
        recordsLib.put(RecordType.NAMEDSET, set);
        HashMap<String, String> var = new HashMap<String, String>();
        var.put("Variable_Unique_Name", GET_UNIQUE_NAME);
        var.put("Reference_Dimension_Unique_Name", GET_DIMENSION_UNIQUE_NAME);
        var.put("Reference_Hierarchy_Unique_Name", GET_HIERARCHY_UNIQUE_NAME);
        var.put("Selection_Type", "getSelectionType");
        var.put("Entry_Type", "getEntryType");
        var.put("Default_Low", "getDefaultLow");
        var.put("Default_High", "getDefaultHigh");
        var.put("Default_Low_Caption", "getLowCaption");
        var.put("Default_High_Caption", "getHighCaption");
        recordsLib.put(RecordType.VARIABLE, var);
    }
}

