/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.DimensionType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Cube;
import com.cognos.xqe.metadata.provider.Folder;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Measure;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Dimension
extends Metadata
implements IDimension {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Dimension.class);
    static final long serialVersionUID = 7647274105530911872L;
    protected ICube cube;
    protected int dimensionIndex = -1;
    protected List<IHierarchy> hierarchies = new ArrayList<IHierarchy>();
    protected IHierarchy defaultHierarchy;
    private Lock hierarchiesReadLock;
    private Lock hierarchiesWriteLock;
    protected DimensionTypeEnum dimensionType = DimensionTypeEnum.REGULAR;
    protected int cardinality = -1;
    protected boolean membersRollup = true;
    protected double orderOfMagnitude = 0.0;
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public Dimension(String objectName) {
        super(objectName);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.hierarchiesReadLock = lock.readLock();
        this.hierarchiesWriteLock = lock.writeLock();
    }

    public Dimension() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.hierarchiesReadLock = lock.readLock();
        this.hierarchiesWriteLock = lock.writeLock();
    }

    @Override
    public List<IHierarchy> getHierarchies() {
        this.initialiseChildren();
        if (this.childMetadataObjects == null) {
            this.populateChildren();
        }
        this.hierarchiesReadLock.lock();
        try {
            ArrayList<IHierarchy> arrayList = new ArrayList<IHierarchy>(this.hierarchies);
            return arrayList;
        }
        finally {
            this.hierarchiesReadLock.unlock();
        }
    }

    @Override
    public IHierarchy getDefaultHierarchy() {
        this.initialiseChildren();
        return this.defaultHierarchy;
    }

    protected void createDefaultHierarchy(String defaultHierName) {
        Map<String, String> dsProperties;
        String defaultMeasureMUN;
        Hierarchy hierarchy = new Hierarchy(defaultHierName);
        this.hierarchies.add(hierarchy);
        this.defaultHierarchy = hierarchy;
        hierarchy.setUniqueName(this.getUniqueName());
        hierarchy.setAutoGenerated(true);
        hierarchy.setDimension(this);
        hierarchy.setConnection(this.getConnection());
        if (this.isMeasuresDimension() && (defaultMeasureMUN = (dsProperties = this.getConnection().getDataSourceProperties()).get("cubeDefaultMeasure")) != null) {
            Measure defaultMeasure = new Measure(defaultMeasureMUN);
            defaultMeasure.setUniqueName(defaultMeasureMUN);
            defaultMeasure.setInitialised();
            hierarchy.setDefaultMember(defaultMeasure);
        }
    }

    public void setDefaultHierarchy(IHierarchy hierarchy) {
        this.hierarchiesWriteLock.lock();
        try {
            this.defaultHierarchy = hierarchy;
        }
        finally {
            this.hierarchiesWriteLock.unlock();
        }
    }

    @Override
    public IMember[] getMembers() {
        return this.getDefaultHierarchy().getMembers();
    }

    @Override
    public synchronized ICube getCube() {
        if (this.cube == null) {
            IMetadata ns = this.getConnection().getParentObject(this);
            while (ns instanceof Folder) {
                ns = this.getConnection().getParentObject(ns);
            }
            if (ns instanceof Cube) {
                this.cube = (Cube)ns;
            } else if (ns instanceof INamespace) {
                Cube tempCube = new Cube(ns.getName());
                tempCube.setConnection(ns.getConnection());
                this.cube = tempCube;
            }
        }
        return this.cube;
    }

    public synchronized void setCube(ICube aCube) {
        this.cube = aCube;
    }

    public void addHierarchy(IHierarchy hierarchy) {
        this.hierarchiesWriteLock.lock();
        try {
            this.hierarchies.add(hierarchy);
            if (this.defaultHierarchy == null) {
                this.defaultHierarchy = hierarchy;
            }
        }
        finally {
            this.hierarchiesWriteLock.unlock();
        }
    }

    public Hierarchy addHierarchy(String name) {
        Hierarchy hierarchy = new Hierarchy(name);
        this.addHierarchy(hierarchy);
        hierarchy.setDimension(this);
        return hierarchy;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int theCardinality) {
        this.cardinality = theCardinality;
    }

    @Override
    public int getHierarchyCount() {
        this.initialiseChildren();
        this.hierarchiesReadLock.lock();
        try {
            int n = this.hierarchies.size();
            return n;
        }
        finally {
            this.hierarchiesReadLock.unlock();
        }
    }

    @Override
    public boolean isMeasuresDimension() {
        this.initialiseProperties();
        return this.getType() == DimensionTypeEnum.MEASURE;
    }

    @Override
    public boolean isRegularDimension() {
        this.initialiseProperties();
        return this.getType() == DimensionTypeEnum.REGULAR;
    }

    @Override
    public boolean isTimeDimension() {
        this.initialiseProperties();
        return this.getType() == DimensionTypeEnum.TIME;
    }

    @Override
    protected synchronized void initialiseProperties() {
        if (!this.initialisedProperties && this.getConnection() != null) {
            Dimension result = (Dimension)this.getConnection().initialiseObjectProperties(this);
            if (result != this) {
                this.name = result.getName();
                this.copyFrom(result);
            }
            this.initialisedProperties = true;
            this.initialised = this.initialisedChildren;
        }
    }

    @Override
    protected synchronized void initialiseChildren() {
        if (!this.initialisedChildren && this.getConnection() != null) {
            Dimension result = (Dimension)this.getConnection().initialiseObjectChildren(this);
            if (result != this) {
                this.hierarchiesWriteLock.lock();
                try {
                    this.hierarchies = result.hierarchies;
                    this.defaultHierarchy = result.defaultHierarchy;
                }
                finally {
                    this.hierarchiesWriteLock.unlock();
                }
            }
            this.hierarchiesWriteLock.lock();
            try {
                if (this.defaultHierarchy == null && this.hierarchies.size() > 0) {
                    this.defaultHierarchy = this.hierarchies.get(0);
                }
                if (this.defaultHierarchy == null) {
                    this.createDefaultHierarchy(this.getName());
                }
            }
            finally {
                this.hierarchiesWriteLock.unlock();
            }
            this.initialisedChildren = true;
            this.initialised = this.initialisedProperties;
        }
    }

    @Override
    public IDataType getDataType() {
        return DimensionType.DIMENSIONTYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IHierarchy getHierarchy(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        this.initialiseChildren();
        this.hierarchiesReadLock.lock();
        try {
            for (IHierarchy aHierarchy : this.hierarchies) {
                if (!name.equals(aHierarchy.getUniqueName())) continue;
                IHierarchy iHierarchy = aHierarchy;
                return iHierarchy;
            }
        }
        finally {
            this.hierarchiesReadLock.unlock();
        }
        return null;
    }

    @Override
    public IHierarchy getHierarchy(String hierarchyUniqueName, String keyDate, DateValue validFrom, DateValue validTo) {
        return this.getHierarchy(hierarchyUniqueName);
    }

    @Override
    public DimensionTypeEnum getType() {
        this.initialiseProperties();
        return this.dimensionType;
    }

    public void setType(DimensionTypeEnum dimType) {
        this.dimensionType = dimType;
    }

    @Override
    public boolean getMembersRollup() {
        this.initialiseProperties();
        return this.membersRollup;
    }

    public void setMembersRollup(boolean theMembersRollup) {
        this.membersRollup = theMembersRollup;
    }

    public void setHierarchy(IHierarchy h) {
    }

    @Override
    public int getIndex() {
        if (this.dimensionIndex == -1) {
            this.dimensionIndex = this.getCube().getDimensionIndex(this);
        }
        return this.dimensionIndex;
    }

    @Override
    public int getIndex(String cubeName) {
        return this.getIndex();
    }

    @Override
    public int getLevelIndex(ILevel d) {
        return -1;
    }

    @Override
    public ILevel getLevel(int index) {
        return null;
    }

    @Override
    @Deprecated
    public int getHierarchyIndex(IHierarchy h) {
        return -1;
    }

    @Override
    public int getLevelCount() {
        return this.getDefaultHierarchy().getLevelCount();
    }

    @Override
    public IMember getMember(String memberName) {
        return null;
    }

    @Override
    public ILevel getLevel(String levName) {
        return null;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.DIMENSION;
    }

    @Override
    public IHierarchy getHierarchy(int index) {
        if (index >= this.hierarchies.size()) {
            return null;
        }
        return this.hierarchies.get(index);
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            this.v5UniqueName = UniqueNameGenerator.createV5UniqueName(this);
        }
        return this.v5UniqueName;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    public void copyFrom(Dimension from) {
        super.copyFrom(from);
        this.cardinality = from.cardinality;
        this.defaultHierarchy = from.defaultHierarchy;
        this.dimensionType = from.dimensionType;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Dimension", -1);
        xmlWriter.attribute("name", this.getName());
        for (IHierarchy hierarchy : this.getHierarchies()) {
            ((Hierarchy)hierarchy).toXML(xmlWriter);
        }
        xmlWriter.endElement();
    }

    protected Lock getHierarchiesReadLock() {
        return this.hierarchiesReadLock;
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isShareable() {
        return false;
    }

    @Override
    public double getOrderOfMagnitude() {
        return this.orderOfMagnitude;
    }

    public void setOrderOfMagnitude(double oom) {
        this.orderOfMagnitude = oom;
    }

    @Override
    public boolean isUnderNamespaceShortcut() {
        return false;
    }

    @Override
    public boolean isDBMeasureDimension() {
        return false;
    }

    @Override
    public String[] getParentNamespaces() {
        return null;
    }

    @Override
    public boolean isDefaultHierarchyExistInModel() {
        return false;
    }

    @Override
    public IDimension getDimUnderTargetNamespace() {
        return null;
    }

    @Override
    public IScopeRelationship getScopeRelationship(IMetadata otherMetadata) {
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getFilters() {
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getPreviewFilters() {
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getSecurityFilters() {
        return null;
    }

    @Override
    public boolean compareTDHierarchies(IHierarchy hier1, IHierarchy hier2) {
        return false;
    }

    @Override
    public boolean isKeyFigureStructure() {
        return false;
    }

    @Override
    public boolean isAttributeDimension() {
        return false;
    }

    @Override
    public boolean getSortMembersData() {
        return false;
    }

    @Override
    public boolean getSortMembersAndEnableMrf() {
        return false;
    }

    @Override
    public IDimension getShortcutTarget(IDimension dimension) {
        return null;
    }

    @Override
    public boolean isAccessedViaShortcut() {
        return false;
    }

    @Override
    public IShortcut getShortcut() {
        return null;
    }

    @Override
    public boolean convertedFromDBQuerySubject() {
        return false;
    }

    @Override
    public INamespace getParentNamespace() {
        return null;
    }
}

