/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Folder;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Level
extends Metadata
implements ILevel {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Level.class);
    private static final String LEVEL = " Level ";
    static final long serialVersionUID = 7647274105530911872L;
    protected IHierarchy hierarchy = null;
    protected List<IMember> members = new ArrayList<IMember>();
    protected List<IProperty> memberProperties = new ArrayList<IProperty>();
    protected int levelIndex = -1;
    protected int cardinality = -1;
    private ReadWriteLock membersLock = new ReentrantReadWriteLock(true);
    private ReadWriteLock memberPropertiesLock = new ReentrantReadWriteLock(true);
    protected boolean isUnique = true;
    protected double orderOfMagnitude = 0.0;
    protected boolean autoGenerated = false;
    private ReadWriteLock sortItemsLock = new ReentrantReadWriteLock(true);
    private ArrayList<ISortItem> sortItems = new ArrayList();

    public Level(String objectName) {
        super(objectName);
    }

    public Level() {
    }

    @Override
    public List<IMember> getMembers() {
        this.membersLock.readLock().lock();
        try {
            ArrayList<IMember> arrayList = new ArrayList<IMember>(this.members);
            return arrayList;
        }
        finally {
            this.membersLock.readLock().unlock();
        }
    }

    @Override
    public synchronized IHierarchy getHierarchy() {
        if (this.hierarchy == null) {
            if (this.getConnection() == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "No connection object exists for level " + this);
            }
            IMetadata hier = this.getConnection().getParentObject(this);
            while (hier instanceof Folder) {
                hier = this.getConnection().getParentObject(hier);
            }
            if (hier == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Hierarchy object not found for " + this);
            }
            if (hier instanceof Hierarchy) {
                this.hierarchy = (Hierarchy)hier;
            } else {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Hierarchy object not of correct type " + hier.getClass());
            }
        }
        return this.hierarchy;
    }

    public synchronized void setHierarchy(IHierarchy refHierarchy) {
        this.hierarchy = refHierarchy;
    }

    public void addMember(Member member, Member parentMember) {
        this.membersLock.writeLock().lock();
        try {
            this.members.add(member);
        }
        finally {
            this.membersLock.writeLock().unlock();
        }
        member.setLevel(this);
        member.setParent(parentMember);
    }

    public void addMemberProperty(IProperty property) {
        this.memberPropertiesLock.writeLock().lock();
        try {
            this.memberProperties.add(property);
        }
        finally {
            this.memberPropertiesLock.writeLock().unlock();
        }
    }

    public Member addMember(String name, Member parentMember) {
        Member member = new Member(name);
        this.addMember(member, parentMember);
        return member;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinalityParam) {
        this.cardinality = cardinalityParam;
    }

    @Override
    public List<IMember> getMembers(int startIndex, int count) {
        List<IMember> items = this.getMembers();
        return items.subList(startIndex, count);
    }

    @Override
    public synchronized ILevel getNextLevel() {
        ILevel result = null;
        Hierarchy hier = (Hierarchy)this.getHierarchy();
        List<ILevel> levels = hier.getLevels();
        int index = this.levelIndex;
        if (index == -1) {
            index = levels.indexOf(this);
        }
        if (++index < levels.size()) {
            result = levels.get(index);
        }
        return result;
    }

    @Override
    public synchronized ILevel getPreviousLevel() {
        ILevel result = null;
        Hierarchy hier = (Hierarchy)this.getHierarchy();
        List<ILevel> levels = hier.getLevels();
        int index = this.levelIndex;
        if (index == -1) {
            index = levels.indexOf(this);
        }
        if (--index >= 0) {
            result = levels.get(index);
        }
        return result;
    }

    @Override
    public boolean isLeafLevel() {
        int levelCount;
        int index = this.getIndex();
        return index == (levelCount = this.getHierarchy().getLevelCount()) - 1;
    }

    @Override
    public boolean isRootLevel() {
        int index = this.getIndex();
        return index == 0;
    }

    @Override
    public List<IProperty> getMemberProperties() {
        return this.memberProperties;
    }

    public void addMemberProperties(List<IProperty> memberPropertiesList) {
        this.memberPropertiesLock.writeLock().lock();
        try {
            this.memberProperties.addAll(memberPropertiesList);
        }
        finally {
            this.memberPropertiesLock.writeLock().unlock();
        }
    }

    @Override
    public IDataType getDataType() {
        return LevelType.LEVELTYPE;
    }

    @Override
    public boolean isUnique() {
        this.initialiseProperties();
        return this.isUnique;
    }

    @Override
    public double getOrderOfMagnitude() {
        return this.orderOfMagnitude;
    }

    public void setOrderOfMagnitude(double oom) {
        this.orderOfMagnitude = oom;
    }

    public void setIsUnique(boolean unique) {
        this.isUnique = unique;
    }

    @Override
    public synchronized int getIndex() {
        if (this.levelIndex == -1) {
            IHierarchy hier = this.getHierarchy();
            List<ILevel> levels = hier.getLevels();
            this.levelIndex = levels.indexOf(this);
        }
        return this.levelIndex;
    }

    @Override
    public IDimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.LEVEL;
    }

    @Override
    public IProperty getMemberProperty(String name) {
        return null;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            this.v5UniqueName = UniqueNameGenerator.createV5UniqueName(this);
        }
        return this.v5UniqueName;
    }

    protected static String createLevelUniqueName(IHierarchy aHierarchy, int levelNumber) {
        MetadataConnection connection;
        if (!aHierarchy.isShell() && (connection = aHierarchy.getConnection()) == null) {
            connection = aHierarchy.getDimension().getConnection();
        }
        StringBuilder strBuf = new StringBuilder(aHierarchy.getName());
        strBuf.append(LEVEL).append(levelNumber);
        return UniqueNameGenerator.createUniqueName(aHierarchy.getDimension().getName(), aHierarchy.getName(), strBuf.toString());
    }

    public void copyFrom(Level from) {
        super.copyFrom(from);
        this.cardinality = from.cardinality;
        this.hierarchy = from.hierarchy;
        this.isUnique = from.isUnique;
        this.autoGenerated = from.autoGenerated;
    }

    @Override
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean theAutoGenerated) {
        this.autoGenerated = theAutoGenerated;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public IMember getMember(String uniqueName) {
        return null;
    }

    @Override
    public ISortItem[] getSortItems() {
        return this.sortItems.toArray(new ISortItem[this.sortItems.size()]);
    }

    public void addSortItem(ISortItem item) {
        this.sortItemsLock.writeLock().lock();
        try {
            this.sortItems.add(item);
        }
        finally {
            this.sortItemsLock.writeLock().unlock();
        }
    }
}

