/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class Metadata
implements IMetadata {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Metadata.class);
    static final long serialVersionUID = 7647274105530911872L;
    public static final String MULTIPART_NAME_DELIMITER = ".";
    protected IDataType dataType;
    private MetadataConnection connection = null;
    protected Object implementationObject = null;
    protected String name = null;
    protected String caption = null;
    protected String description = null;
    protected String screenTip = null;
    protected String uniqueID = null;
    protected String uniqueName;
    protected String v5UniqueName;
    protected Map<String, Object> dynamicProperties = null;
    protected IMetadata parentObject = null;
    protected List<IMetadata> childMetadataObjects = null;
    protected volatile boolean initialised = false;
    protected volatile boolean initialisedProperties = false;
    protected volatile boolean initialisedChildren = false;
    protected int cachedHashCode = Integer.MIN_VALUE;

    public void setInitialised() {
        this.initialised = true;
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    protected void copyFrom(Metadata from) {
        this.childMetadataObjects = from.childMetadataObjects;
        this.connection = from.connection;
        this.dataType = from.dataType;
        this.implementationObject = from.implementationObject;
        this.initialised = from.initialised;
        this.name = from.name;
        this.uniqueName = from.uniqueName;
        this.caption = from.caption;
        this.description = from.description;
        this.screenTip = from.screenTip;
        this.dynamicProperties = from.dynamicProperties;
    }

    protected void initialiseProperties() {
    }

    protected void initialiseChildren() {
    }

    public Metadata(String objectName) {
        this.name = objectName;
    }

    public Metadata() {
    }

    public String toDebugString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(MULTIPART_NAME_DELIMITER) + 1);
        StringBuilder buffer = new StringBuilder();
        buffer.append(className);
        buffer.append(" : ");
        buffer.append(this.getName());
        return buffer.toString();
    }

    public String toString() {
        return this.getUniqueName();
    }

    @Override
    public String getName() {
        this.initialiseProperties();
        return this.name;
    }

    @Override
    public String getUniqueName() {
        this.initialiseProperties();
        if (null == this.uniqueName) {
            this.uniqueName = UniqueNameGenerator.createUniqueName(this.getName());
        }
        return this.uniqueName;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Override
    public synchronized Object getProperty(String propertyName) {
        if (this.dynamicProperties == null) {
            this.initialiseProperties();
        }
        if (this.dynamicProperties != null) {
            return this.dynamicProperties.get(propertyName);
        }
        return null;
    }

    public synchronized void setProperty(String propertyName, Object value) {
        if (this.dynamicProperties == null) {
            this.dynamicProperties = new HashMap<String, Object>();
        }
        if (null == value) {
            this.dynamicProperties.remove(propertyName);
        } else {
            this.dynamicProperties.put(propertyName, value);
        }
    }

    public synchronized void setDynamicProperties(Map<String, Object> properties) {
        if (this.dynamicProperties == null) {
            this.dynamicProperties = new HashMap<String, Object>();
        }
        this.dynamicProperties.putAll(properties);
    }

    public Object getImplementationObject() {
        return this.implementationObject;
    }

    public void setImplementationObject(Object anImplementationObject) {
        this.implementationObject = anImplementationObject;
    }

    @Override
    public MetadataConnection getConnection() {
        return this.connection;
    }

    public void setConnection(MetadataConnection conn) {
        this.connection = conn;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isMetadata() {
        return true;
    }

    public boolean isResultSet() {
        return false;
    }

    @Override
    public Set<String> getAvailableProperties() {
        Map<String, Object> props = this.getDynamicProperties();
        if (null == props) {
            return Collections.emptySet();
        }
        return new HashSet<String>(props.keySet());
    }

    public synchronized Map<String, Object> getDynamicProperties() {
        if (this.dynamicProperties == null) {
            this.initialiseProperties();
        }
        return this.dynamicProperties;
    }

    protected synchronized boolean hasDynamicProperties() {
        return this.dynamicProperties != null;
    }

    @Override
    public synchronized List<IMetadata> getChildMetadataObjects() {
        if (this.childMetadataObjects == null) {
            this.initialiseChildren();
            this.populateChildren();
        }
        ArrayList<IMetadata> result = null;
        if (this.childMetadataObjects != null) {
            result = new ArrayList<IMetadata>();
            result.addAll(this.childMetadataObjects);
        }
        return result;
    }

    public void populateChildren() {
    }

    @Override
    public IDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(IDataType theDataType) {
        this.dataType = theDataType;
    }

    public synchronized void addChildMetadataObject(IMetadata child) {
        if (this.childMetadataObjects == null) {
            this.childMetadataObjects = new ArrayList<IMetadata>();
        }
        if (!this.childMetadataObjects.contains(child)) {
            this.childMetadataObjects.add(child);
            ((Metadata)child).setParentMetadataObject(this);
        }
    }

    @Override
    public MetadataType getObjectType() {
        throw new UnsupportedOperationException();
    }

    public void toXML(XMLWriter xmlWriter) {
    }

    public Object toJSON() {
        throw new UnsupportedOperationException();
    }

    public Object copy() throws CloneNotSupportedException {
        throw new CloneNotSupportedException(this.getClass().getName());
    }

    public void copyFrom(IValue value) throws ValueMethodNotImplementedException {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".copyFrom(Value dValue)");
    }

    @Override
    public String getID() {
        return this.getV5UniqueName();
    }

    @Override
    public String getV5UniqueName() {
        return this.v5UniqueName;
    }

    public void setV5UniqueName(String theV5UniqueName) {
        this.v5UniqueName = theV5UniqueName;
    }

    public String getParentObjectUniqueName() {
        String parentUniqueName = null;
        if (this.getParentObject() != null) {
            parentUniqueName = this.getParentObject().getUniqueName();
        }
        return parentUniqueName;
    }

    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DEFAULT);
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return true;
    }

    @Override
    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return "";
    }

    @Override
    public String getScreenTip() {
        if (this.screenTip != null) {
            return this.screenTip;
        }
        return "";
    }

    @Override
    public String getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public String getCaption() {
        this.initialiseProperties();
        if (null == this.caption) {
            return this.getName();
        }
        return this.caption;
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public void setScreenTip(String theScreenTip) {
        this.screenTip = theScreenTip;
    }

    public void setUniqueID(String theUniqueID) {
        this.uniqueID = theUniqueID;
    }

    public void setCaption(String theCaption) {
        this.caption = theCaption;
    }

    public void setUniqueName(String theUniqueName) {
        this.uniqueName = theUniqueName;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
        this.parentObject = parent;
    }

    @Override
    public IMetadata getParentObject() {
        return this.parentObject;
    }

    @Override
    public int compareTo(Object other) {
        if (null == other) {
            return -1;
        }
        if (this == other) {
            return 0;
        }
        if (!(other instanceof IMetadata)) {
            return -1;
        }
        IMetadata otherMetadata = (IMetadata)other;
        CompareToBuilder ctb = new CompareToBuilder();
        ctb.append((Object)this.getObjectType(), (Object)otherMetadata.getObjectType());
        ctb.append((Object)this.getUniqueName(), (Object)otherMetadata.getUniqueName());
        return ctb.toComparison();
    }

    public boolean equals(Object other) {
        String otherUN;
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof IMetadata)) {
            return false;
        }
        IMetadata otherMetadata = (IMetadata)other;
        if (this.getObjectType() != otherMetadata.getObjectType()) {
            return false;
        }
        String thisUN = this.getUniqueName();
        return thisUN == (otherUN = otherMetadata.getUniqueName()) || thisUN.equals(otherUN);
    }

    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append(this.getObjectType().ordinal());
            hcb.append((Object)this.getUniqueName());
            this.cachedHashCode = hcb.toHashCode();
            if (this.cachedHashCode == Integer.MIN_VALUE) {
                this.cachedHashCode = 0;
            }
        }
        return this.cachedHashCode;
    }

    public int fastHash() {
        return this.hashCode();
    }

    public Object hashKey() {
        return new MetadataKey(new Object[]{this.getObjectType(), this.getUniqueName()});
    }

    public Object hashKey(Collator collator) {
        return this.hashKey();
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isMFW() {
        return false;
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return null;
    }

    @Override
    public boolean isAccessible() {
        return false;
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        return null;
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isVisible(boolean inShortcut) {
        return false;
    }
}

