/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Folder;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.bean.BeanPropertySupport;

public class QueryItem
extends Metadata
implements IQueryItem {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(QueryItem.class);
    static final long serialVersionUID = 7647274105530911872L;
    IQuerySubject querySubject = null;
    protected IHierarchy hierarchy = null;
    protected ILevel level = null;

    @Override
    public synchronized IQuerySubject getQuerySubject() {
        if (this.querySubject == null) {
            IMetadata obj = this.getConnection().getParentObject(this);
            while (obj instanceof Folder) {
                obj = this.getConnection().getParentObject(obj);
            }
            this.querySubject = (IQuerySubject)obj;
        }
        return this.querySubject;
    }

    @Override
    public String getRegularAggregate() {
        this.initialiseProperties();
        return (String)this.getProperty("regularAggregate");
    }

    @Override
    public String getSemiAggregate() {
        this.initialiseProperties();
        return (String)this.getProperty("semiAggregate");
    }

    @Override
    public boolean isNullable() {
        this.initialiseProperties();
        return Boolean.valueOf((String)this.getProperty("nullable"));
    }

    @Override
    public int getDatatypeSize() {
        this.initialiseProperties();
        return Integer.valueOf((String)this.getProperty("size"));
    }

    @Override
    public int getDatatypePrecision() {
        this.initialiseProperties();
        return Integer.valueOf((String)this.getProperty("precision"));
    }

    @Override
    public int getDatatypeScale() {
        this.initialiseProperties();
        return Integer.valueOf((String)this.getProperty("scale"));
    }

    @Override
    public String getDatatypeName() {
        this.initialiseProperties();
        return (String)this.getProperty("datatype");
    }

    @Override
    public String getFormat() {
        this.initialiseProperties();
        return (String)this.getProperty("format");
    }

    @Override
    public String getCurrency() {
        this.initialiseProperties();
        return (String)this.getProperty("currency");
    }

    @Override
    public String getUsage() {
        this.initialiseProperties();
        return (String)this.getProperty("usage");
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.QUERY_ITEM;
    }

    @Override
    public boolean isFact() {
        String usage = this.getUsage();
        return usage != null && usage.equals("fact");
    }

    @Override
    public ILevel getLevel() {
        if (this.level != null) {
            return this.level;
        }
        if (this.hierarchy != null && this.hierarchy.isParentChild()) {
            return this.level;
        }
        ILevel aLevel = null;
        if (this.isProperty()) {
            int levelNameId = 3;
            String identifier = this.getV5UniqueName();
            String[] parts = null;
            try {
                parts = UniqueNameParser.parse(identifier, -1);
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(XQEMessageKeys.V5_InvalidPropertyIdentifier, (Throwable)e, identifier);
            }
            if (parts != null) {
                String levelIdentifier = null;
                levelIdentifier = parts.length == 4 ? UniqueNameGenerator.createUniqueName(parts[0], parts[1], parts[2]) : UniqueNameGenerator.createUniqueName(parts[0], parts[1], parts[2], parts[3]);
                IMetadata metadada = this.getConnection().bindMetadataReference(levelIdentifier);
                if (metadada instanceof IHierarchy) {
                    IHierarchy aHierarchy = (IHierarchy)metadada;
                    if (!aHierarchy.isParentChild()) {
                        throw new XQERuntimeException(XQEMessageKeys.V5_InvalidPropertyIdentifier, identifier);
                    }
                    aLevel = null;
                } else if (metadada instanceof ILevel) {
                    aLevel = (ILevel)metadada;
                } else {
                    throw new XQERuntimeException(XQEMessageKeys.V5_InvalidPropertyIdentifier, identifier);
                }
            }
        }
        return aLevel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IHierarchy getHierarchy() {
        if (this.hierarchy != null) {
            return this.hierarchy;
        }
        IHierarchy aHierarchy = null;
        if (this.isProperty()) {
            int levelNameId = 3;
            String identifier = this.getV5UniqueName();
            String[] parts = null;
            try {
                parts = UniqueNameParser.parse(identifier, -1);
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(XQEMessageKeys.V5_InvalidPropertyIdentifier, (Throwable)e, identifier);
            }
            if (parts == null) throw new XQERuntimeException(XQEMessageKeys.V5_InvalidPropertyIdentifier, identifier);
            String levelIdentifier = null;
            levelIdentifier = parts.length == 4 ? UniqueNameGenerator.createUniqueName(parts[0], parts[1], parts[2]) : UniqueNameGenerator.createUniqueName(parts[0], parts[1], parts[2], parts[3]);
            IMetadata metadada = this.getConnection().bindMetadataReference(levelIdentifier);
            if (metadada instanceof IHierarchy) {
                aHierarchy = (IHierarchy)metadada;
                if (!aHierarchy.isParentChild()) {
                    throw new XQERuntimeException(XQEMessageKeys.V5_InvalidPropertyIdentifier, identifier);
                }
            } else {
                if (!(metadada instanceof ILevel)) throw new XQERuntimeException(XQEMessageKeys.V5_InvalidPropertyIdentifier, identifier);
                aHierarchy = ((ILevel)metadada).getHierarchy();
            }
        }
        this.hierarchy = aHierarchy;
        return aHierarchy;
    }

    @Override
    public String getExpression() {
        this.initialiseProperties();
        return (String)this.getProperty("expression");
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public boolean isProperty() {
        String usage = this.getUsage();
        return usage.equals("attribute") || usage.equals("identifier");
    }

    @Override
    public boolean isBusinessKey() {
        return this.getUsage().equals("identifier");
    }

    @Override
    public String getExpressionOrExternalName() {
        String expr = this.getExpression();
        if (expr != null) {
            return expr;
        }
        expr = (String)this.getProperty("ID");
        return expr.trim();
    }

    @Override
    public IFacet getFacet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHidden() {
        return false;
    }
}

