/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider;

import com.cognos.xqe.metadata.IAlias;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Catalog;
import com.cognos.xqe.metadata.provider.Cube;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SimpleModelDataSource
extends Metadata
implements IModelDataSource {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(SimpleModelDataSource.class);
    private static final String MULTIDIMENSIONAL = "multidimensional";
    private static final String RELATIONAL = "relational";
    private static final String QUERY_TYPE_STR = "queryType";
    private static final String COLON = ":";
    static final long serialVersionUID = 7647274105530911872L;
    protected List<ICube> cubes = new ArrayList<ICube>();
    protected ICube cube = null;
    ICatalog catalog;

    public SimpleModelDataSource(String objectName) {
        super(objectName);
    }

    public SimpleModelDataSource() {
    }

    @Override
    public synchronized List<ICube> getCubes() {
        if (this.cubes.size() == 0 && this.getCube() != null) {
            this.cubes.add(this.getCube());
        }
        return this.cubes;
    }

    @Override
    public ICube getCube() {
        String cubeName;
        if (this.cube == null && (cubeName = (String)this.getProperty("cube")) != null && cubeName.length() > 0) {
            Cube theCube = new Cube(cubeName);
            theCube.setDataSource(this);
            theCube.setCatalog(this.getCatalog());
            theCube.setConnection(this.getConnection());
            this.cube = theCube;
        }
        return this.cube;
    }

    public synchronized void addCube(Cube theCube) {
        this.cubes.add(theCube);
        theCube.setDataSource(this);
        theCube.setConnection(this.getConnection());
    }

    public synchronized Cube addCube(String name) {
        Cube theCube = new Cube(name);
        theCube.setDataSource(this);
        theCube.setCatalog(this.getCatalog());
        theCube.setConnection(this.getConnection());
        return theCube;
    }

    @Override
    public String getQueryType() {
        return (String)this.getProperty(QUERY_TYPE_STR);
    }

    @Override
    public boolean isMultidimensional() {
        return this.getQueryType().equals(MULTIDIMENSIONAL);
    }

    @Override
    public boolean isRelational() {
        return this.getQueryType().equals(RELATIONAL);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public String getInterface() {
        return (String)this.getProperty("interface");
    }

    @Override
    public String getCMDataSourceName() {
        return (String)this.getProperty("cmDataSource");
    }

    @Override
    public String getSchema() {
        return (String)this.getProperty("schema");
    }

    @Override
    protected synchronized void initialiseProperties() {
        if (!this.isInitialised()) {
            super.initialiseProperties();
            this.initialised = true;
            String catalogName = (String)this.getProperty("catalog");
            Catalog theCatalog = new Catalog();
            theCatalog.setName(catalogName);
            theCatalog.setUniqueName(catalogName);
            this.catalog = theCatalog;
        }
    }

    @Override
    public ICatalog getCatalog() {
        this.initialiseProperties();
        return this.catalog;
    }

    @Override
    public IAlias getAlias() {
        String aliasTableMapRef = (String)this.getProperty("aliasTableMapRef");
        if (aliasTableMapRef == null) {
            return null;
        }
        IAlias metadata = (IAlias)this.getConnection().bindMetadataReference(aliasTableMapRef);
        metadata.getChildMetadataObjects();
        return metadata;
    }

    @Override
    public Map<String, Object> getMetadataProperties() {
        return Collections.unmodifiableMap(this.getDynamicProperties());
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.DATASOURCE;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append("dataSource").append(COLON).append(this.getName()).append(";").append("interface").append(COLON).append(this.getInterface()).append(";").append("cube").append(COLON).append(this.getName()).append(";");
        return toString.toString();
    }

    @Override
    public void setCMDataSource(String dataSourceVal) {
    }

    @Override
    public boolean isROLAP() {
        return "RO".equals(this.getInterface());
    }

    @Override
    public List<IVariable> getVariables() {
        return null;
    }

    @Override
    public boolean isContentManager() {
        return true;
    }
}

