/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider.nativeodp;

import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.nativeodp.NativeCube;
import com.cognos.xqe.metadata.provider.nativeodp.NativeHierarchy;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMeasureHierarchy;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadata;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanMethodIntrospection;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@BeanClassIntrospection(enabled=false)
public class NativeDimension
extends NativeMetadata
implements IDimension {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(NativeDimension.class);
    private final NativeCube cube;
    private final DimensionRecord record;
    private volatile List<NativeHierarchy> hierarchies = null;
    private final Object hierarchiesInitLock = new Object();
    private volatile NativeHierarchy defaultHierarchy = null;
    private final Object defaultHierarchyInitLock = new Object();

    NativeDimension(NativeMetadataConnection theMDConnection, DimensionRecord theRecord, NativeCube theCube) {
        super(theMDConnection);
        this.record = theRecord;
        this.cube = theCube;
    }

    @Override
    protected MetadataRecord getRecord() {
        return this.record;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public int getCardinality() {
        return this.record.getCardinality();
    }

    @Override
    public ICube getCube() {
        return this.cube;
    }

    @Override
    public IHierarchy getDefaultHierarchy() {
        this.initializeDefaultHierarchy();
        return this.defaultHierarchy;
    }

    @Override
    public List<IHierarchy> getHierarchies() {
        this.initializeHierarchies();
        List<NativeHierarchy> result = Collections.unmodifiableList(this.hierarchies);
        return CollectionCast.upcast(result, IHierarchy.class);
    }

    @Override
    public IHierarchy getHierarchy(String hierarchyUniqueName) {
        NativeHierarchy result = this.cube.getCachedHierarchy(hierarchyUniqueName);
        if (null != result) {
            return result;
        }
        for (IHierarchy hierarchy : this.getHierarchies()) {
            if (!hierarchy.getUniqueName().equals(hierarchyUniqueName)) continue;
            return hierarchy;
        }
        return null;
    }

    @Override
    public IHierarchy getHierarchy(String hierarchyUniqueName, String keyDate, DateValue validFrom, DateValue validTo) {
        return this.getHierarchy(hierarchyUniqueName);
    }

    @Override
    public IHierarchy getHierarchy(int index) {
        this.initializeHierarchies();
        return this.hierarchies.get(index);
    }

    @Override
    public int getHierarchyCount() {
        this.initializeHierarchies();
        return this.hierarchies.size();
    }

    @Override
    public int getHierarchyIndex(IHierarchy h) {
        this.initializeHierarchies();
        return this.hierarchies.indexOf(h);
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public int getIndex() {
        return this.record.getRank();
    }

    @Override
    public int getIndex(String cubeName) {
        return this.getIndex();
    }

    @Override
    public ILevel getLevel(int index) {
        return this.getDefaultHierarchy().getLevel(index);
    }

    @Override
    public ILevel getLevel(String levelName) {
        return this.getDefaultHierarchy().getLevel(levelName);
    }

    @Override
    public int getLevelCount() {
        return this.getDefaultHierarchy().getLevelCount();
    }

    @Override
    public int getLevelIndex(ILevel l) {
        return this.getDefaultHierarchy().getLevelIndex(l);
    }

    @Override
    public IMember getMember(String memberUniqueName) {
        return this.getDefaultHierarchy().getMember(memberUniqueName);
    }

    @Override
    public IMember[] getMembers() {
        return this.getDefaultHierarchy().getMembers();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean getMembersRollup() {
        return true;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public DimensionTypeEnum getType() {
        return this.record.getType();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isMeasuresDimension() {
        return this.record.getType() == DimensionTypeEnum.MEASURE;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isRegularDimension() {
        return this.record.getType() == DimensionTypeEnum.REGULAR;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isShell() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isTimeDimension() {
        return this.record.getType() == DimensionTypeEnum.TIME;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        List<IHierarchy> result = this.getHierarchies();
        return CollectionCast.upcast(result, IMetadata.class);
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public IDataType getDataType() {
        return DataTypeFactory.getDimensionUniqueNameType();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public MetadataType getObjectType() {
        return MetadataType.DIMENSION;
    }

    @Override
    public IMetadata getParentObject() {
        return this.cube;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        this.initializeHierarchies();
        return this.hierarchies.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHierarchies() {
        if (null != this.hierarchies) {
            return;
        }
        Object object = this.hierarchiesInitLock;
        synchronized (object) {
            if (null == this.hierarchies) {
                NativeMetadataConnection connection = this.getNativeConnection();
                ArrayList<NativeHierarchy> theList = new ArrayList<NativeHierarchy>();
                MetadataRestriction restrictions = new MetadataRestriction();
                restrictions.add(RestrictionType.CATALOG, this.cube.getCatalog().getName());
                restrictions.add(RestrictionType.CUBE, this.cube.getName());
                restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getUniqueName());
                List<HierarchyRecord> hierarchyRecords = this.getMetadataProvider().getHierarchies(restrictions);
                for (HierarchyRecord hierarchyRecord : hierarchyRecords) {
                    NativeHierarchy theHierarchy = null;
                    theHierarchy = this.isMeasuresDimension() ? new NativeMeasureHierarchy(connection, hierarchyRecord, this) : new NativeHierarchy(connection, hierarchyRecord, this);
                    theList.add(theHierarchy);
                    this.cube.putCachedHierarchy(theHierarchy);
                }
                this.hierarchies = theList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDefaultHierarchy() {
        if (null != this.defaultHierarchy) {
            return;
        }
        Object object = this.defaultHierarchyInitLock;
        synchronized (object) {
            if (null == this.defaultHierarchy) {
                String defaultHUN = this.record.getDefaultHierarchyUniqueName();
                if (null != defaultHUN) {
                    this.initializeHierarchies();
                    this.defaultHierarchy = this.cube.getCachedHierarchy(defaultHUN);
                    if (null != this.defaultHierarchy) {
                        return;
                    }
                }
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A default hierarchy was not specified by the OLAP data provider");
            }
        }
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isShareable() {
        return false;
    }

    @Override
    public double getOrderOfMagnitude() {
        return 0.0;
    }

    @Override
    public boolean isUnderNamespaceShortcut() {
        return false;
    }

    @Override
    public boolean isDBMeasureDimension() {
        return false;
    }

    @Override
    public String[] getParentNamespaces() {
        return null;
    }

    @Override
    public boolean isDefaultHierarchyExistInModel() {
        return false;
    }

    @Override
    public IDimension getDimUnderTargetNamespace() {
        return null;
    }

    @Override
    public IScopeRelationship getScopeRelationship(IMetadata otherMetadata) {
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getFilters() {
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getPreviewFilters() {
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getSecurityFilters() {
        return null;
    }

    @Override
    public boolean compareTDHierarchies(IHierarchy hier1, IHierarchy hier2) {
        return false;
    }

    @Override
    public boolean isKeyFigureStructure() {
        return false;
    }

    @Override
    public boolean isAttributeDimension() {
        return false;
    }

    @Override
    public boolean getSortMembersData() {
        return false;
    }

    @Override
    public boolean getSortMembersAndEnableMrf() {
        return false;
    }

    @Override
    public IDimension getShortcutTarget(IDimension dimension) {
        return null;
    }

    @Override
    public boolean isAccessedViaShortcut() {
        return false;
    }

    @Override
    public IShortcut getShortcut() {
        return null;
    }

    @Override
    public boolean convertedFromDBQuerySubject() {
        return false;
    }

    @Override
    public INamespace getParentNamespace() {
        return null;
    }
}

