/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider.nativeodp;

import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.provider.nativeodp.NativeCube;
import com.cognos.xqe.metadata.provider.nativeodp.NativeDimension;
import com.cognos.xqe.metadata.provider.nativeodp.NativeLevel;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMeasureHierarchy;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMeasureLevel;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMember;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadata;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanMethodIntrospection;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@BeanClassIntrospection(enabled=false)
public class NativeHierarchy
extends NativeMetadata
implements IHierarchy {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(NativeHierarchy.class);
    protected final NativeDimension dimension;
    protected final HierarchyRecord record;
    private volatile List<NativeLevel> levels = null;
    private final Object levelsInitLock = new Object();
    private final Object multiRootInitLock = new Object();
    private volatile NativeMember defaultMember = null;
    private final Object defaultMemberInitLock = new Object();
    private volatile NativeMember highestRollupMember = null;
    private final Object highestRollupMemberInitLock = new Object();
    private volatile NativeMember rootMember = null;
    private final Object rootMemberInitLock = new Object();
    private final Map<String, NativeMember> memberCache = new HashMap<String, NativeMember>();
    private final ReadWriteLock memberCacheLock = new ReentrantReadWriteLock(true);
    private Boolean multiRoot = null;

    NativeHierarchy(NativeMetadataConnection theMDConnection, HierarchyRecord theRecord, NativeDimension theDimension) {
        super(theMDConnection);
        this.record = theRecord;
        this.dimension = theDimension;
    }

    @Override
    protected MetadataRecord getRecord() {
        return this.record;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public String createCalculatedMemberUniqueName(String suffix) {
        throw new UnsupportedOperationException();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public int getCardinality() {
        return this.record.getCardinality();
    }

    @Override
    public IMember getDefaultMember() {
        this.initializeDefaultMember();
        return this.defaultMember;
    }

    @Override
    public IDimension getDimension() {
        return this.dimension;
    }

    @Override
    public IMember getHighestLevelRollup() {
        this.initializeHighestRollupMember();
        return this.highestRollupMember;
    }

    @Override
    public ILevel getLevel(int index) {
        this.initializeLevels();
        return this.levels.get(index);
    }

    @Override
    public ILevel getLevel(String levelUniqueName) {
        NativeCube cube = (NativeCube)this.dimension.getCube();
        NativeLevel result = cube.getCachedLevel(levelUniqueName);
        if (null != result) {
            return result;
        }
        for (ILevel level : this.getLevels()) {
            if (!level.getUniqueName().equals(levelUniqueName)) continue;
            return level;
        }
        return null;
    }

    @Override
    public int getLevelCount() {
        this.initializeLevels();
        return this.levels.size();
    }

    @Override
    public int getLevelIndex(ILevel l) {
        this.initializeLevels();
        return this.levels.indexOf(l);
    }

    @Override
    public List<ILevel> getLevels() {
        this.initializeLevels();
        List<NativeLevel> result = Collections.unmodifiableList(this.levels);
        return CollectionCast.upcast(result, ILevel.class);
    }

    public Iterator<IMember> getMemberIterator() {
        Iterator<IMetadata> result = MetadataUtil.descendantsIterator(this.getRootMember(), true);
        return CollectionCast.downcast(result, IMetadata.class, IMember.class);
    }

    @Override
    public IMember[] getMembers() {
        LinkedList<IMember> members = new LinkedList<IMember>();
        Iterator<IMember> memberIter = this.getMemberIterator();
        while (memberIter.hasNext()) {
            members.add(memberIter.next());
        }
        return members.toArray(new IMember[0]);
    }

    @Override
    public IMember getMember(String memberUniqueName) {
        return this.fetchMember(memberUniqueName);
    }

    @Override
    public List<String> getRelatedHierarchyNames(ILevel lowestLevel) {
        return null;
    }

    @Override
    public IMember getRootMember() {
        this.initializeRootMember();
        return this.rootMember;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isAutoGenerated() {
        return this.record.getDynamicFieldAsBoolean("AUTO_GENERATED") == Boolean.TRUE;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isMultiRoot() {
        this.initializeMultiRoot();
        return this.multiRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMultiRoot() {
        if (null != this.multiRoot) {
            return;
        }
        Object object = this.multiRootInitLock;
        synchronized (object) {
            if (null == this.multiRoot) {
                NativeCube cube = (NativeCube)this.dimension.getCube();
                MetadataRestriction restrictions = new MetadataRestriction();
                restrictions.add(RestrictionType.CATALOG, cube.getCatalog().getName());
                restrictions.add(RestrictionType.CUBE, cube.getName());
                restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.dimension.getUniqueName());
                restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
                List<MemberRecord> memberRecords = this.getMetadataProvider().getHierarchyRootMembers(restrictions);
                this.multiRoot = memberRecords.size() > 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
        }
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isParentChild() {
        return this.record.isParentChild();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isRagged() {
        return this.record.isRagged();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isShell() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isUnbalanced() {
        return !this.record.isBalanced();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public IDataType getDataType() {
        return DataTypeFactory.getHierarchyUniqueNameType();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public MetadataType getObjectType() {
        return MetadataType.HIERARCHY;
    }

    @Override
    public IMetadata getParentObject() {
        return this.dimension;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        this.initializeLevels();
        return this.levels.size() > 0;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        this.initializeLevels();
        List<NativeLevel> result = Collections.unmodifiableList(this.levels);
        return CollectionCast.upcast(result, IMetadata.class);
    }

    public NativeMember fetchMember(String memberUniqueName) {
        NativeMember result = this.getCachedMember(memberUniqueName);
        if (null != result) {
            return result;
        }
        NativeMetadataConnection connection = this.getNativeConnection();
        NativeCube cube = (NativeCube)this.dimension.getCube();
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, cube.getCatalog().getName());
        restrictions.add(RestrictionType.CUBE, cube.getName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.dimension.getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
        restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, memberUniqueName);
        restrictions.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.SELF));
        List<MemberRecord> memberRecords = this.getMetadataProvider().getMembers(restrictions);
        if (!memberRecords.isEmpty()) {
            NativeLevel level = (NativeLevel)this.getLevel(memberRecords.get(0).getLevelNumber());
            result = new NativeMember(connection, memberRecords.get(0), level);
            this.putCachedMember(result);
        }
        return result;
    }

    public NativeMember fetchParentMember(String memberUniqueName) {
        NativeMetadataConnection connection = this.getNativeConnection();
        NativeCube cube = (NativeCube)this.dimension.getCube();
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, cube.getCatalog().getName());
        restrictions.add(RestrictionType.CUBE, cube.getName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.dimension.getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
        restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, memberUniqueName);
        restrictions.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.PARENT));
        List<MemberRecord> memberRecords = this.getMetadataProvider().getMembers(restrictions);
        NativeMember result = null;
        if (!memberRecords.isEmpty()) {
            MemberRecord tempRecord = memberRecords.get(0);
            result = this.getCachedMember(tempRecord.getUniqueName());
            if (null != result) {
                return result;
            }
            NativeLevel level = (NativeLevel)this.getLevel(tempRecord.getLevelNumber());
            result = new NativeMember(connection, tempRecord, level);
            this.putCachedMember(result);
        }
        return result;
    }

    public List<NativeMember> fetchChildMembers(String memberUniqueName) {
        NativeMetadataConnection connection = this.getNativeConnection();
        NativeCube cube = (NativeCube)this.dimension.getCube();
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, cube.getCatalog().getName());
        restrictions.add(RestrictionType.CUBE, cube.getName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.dimension.getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
        restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, memberUniqueName);
        restrictions.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.CHILDREN));
        List<MemberRecord> memberRecords = this.getMetadataProvider().getMembers(restrictions);
        if (memberRecords.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NativeMember> children = new ArrayList<NativeMember>(memberRecords.size());
        for (MemberRecord memberRecord : memberRecords) {
            NativeMember member = this.getCachedMember(memberRecord.getUniqueName());
            if (null == member) {
                NativeLevel level = (NativeLevel)this.getLevel(memberRecord.getLevelNumber());
                member = new NativeMember(connection, memberRecord, level);
                this.putCachedMember(member);
            }
            children.add(member);
        }
        return children;
    }

    NativeMember getCachedMember(String memberUniqueName) {
        try {
            this.memberCacheLock.readLock().lock();
            NativeMember nativeMember = this.memberCache.get(memberUniqueName);
            return nativeMember;
        }
        finally {
            this.memberCacheLock.readLock().unlock();
        }
    }

    void putCachedMember(NativeMember theMember) {
        try {
            this.memberCacheLock.writeLock().lock();
            this.memberCache.put(theMember.getUniqueName(), theMember);
        }
        finally {
            this.memberCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLevels() {
        if (null != this.levels) {
            return;
        }
        Object object = this.levelsInitLock;
        synchronized (object) {
            if (null == this.levels) {
                NativeMetadataConnection connection = this.getNativeConnection();
                NativeCube cube = (NativeCube)this.dimension.getCube();
                ArrayList<NativeLevel> theList = new ArrayList<NativeLevel>();
                MetadataRestriction restrictions = new MetadataRestriction();
                restrictions.add(RestrictionType.CATALOG, cube.getCatalog().getName());
                restrictions.add(RestrictionType.CUBE, cube.getName());
                restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.dimension.getUniqueName());
                restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
                List<LevelRecord> levelRecords = this.getMetadataProvider().getLevels(restrictions);
                theList.ensureCapacity(levelRecords.size());
                for (int i = 0; i < levelRecords.size(); ++i) {
                    theList.add(null);
                }
                for (LevelRecord levelRecord : levelRecords) {
                    NativeLevel theLevel = null;
                    if (null != theList.get(levelRecord.getLevelNumber())) {
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Hierarchy has non-unique level number.");
                    }
                    theLevel = this.getDimension().isMeasuresDimension() ? new NativeMeasureLevel(connection, levelRecord, (NativeMeasureHierarchy)this) : new NativeLevel(connection, levelRecord, this);
                    theList.set(levelRecord.getLevelNumber(), theLevel);
                    cube.putCachedLevel(theLevel);
                }
                this.levels = theList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDefaultMember() {
        if (null != this.defaultMember) {
            return;
        }
        Object object = this.defaultMemberInitLock;
        synchronized (object) {
            if (null == this.defaultMember) {
                String defaultMUN = this.record.getDefaultMemberUniqueName();
                this.defaultMember = null == defaultMUN ? (NativeMember)this.getHighestLevelRollup() : this.fetchMember(defaultMUN);
                if (null != this.defaultMember) {
                    return;
                }
                this.defaultMember = (NativeMember)this.getLevel(0).getMembers(0, 1).get(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeHighestRollupMember() {
        if (null != this.highestRollupMember) {
            return;
        }
        Object object = this.highestRollupMemberInitLock;
        synchronized (object) {
            if (null == this.highestRollupMember) {
                String highestRollupMUN = this.record.getHighestRollupMemberUniqueName();
                if (null != highestRollupMUN) {
                    this.highestRollupMember = this.fetchMember(highestRollupMUN);
                }
                if (null != this.highestRollupMember) {
                    return;
                }
                this.highestRollupMember = (NativeMember)this.getLevel(0).getMembers(0, 1).get(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRootMember() {
        if (null != this.rootMember || this.isMultiRoot()) {
            return;
        }
        Object object = this.rootMemberInitLock;
        synchronized (object) {
            List<IMember> rootLevelMembers;
            if (null == this.rootMember && (rootLevelMembers = this.getLevel(0).getMembers(0, 2)).size() == 1) {
                this.rootMember = (NativeMember)rootLevelMembers.get(0);
            }
        }
    }

    @Override
    public IMember[] getMembers(InterpreterContext ic) {
        return null;
    }

    @Override
    public List<IMember> getCalculatedMembers() {
        return null;
    }

    @Override
    public String getValidFrom() {
        return null;
    }

    @Override
    public String getValidTo() {
        return null;
    }

    @Override
    public IMember getDefaultMemberFromProvider() {
        return null;
    }
}

