/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider.nativeodp;

import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.nativeodp.NativeCube;
import com.cognos.xqe.metadata.provider.nativeodp.NativeDimension;
import com.cognos.xqe.metadata.provider.nativeodp.NativeHierarchy;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMember;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadata;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.metadata.provider.nativeodp.NativeProperty;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanMethodIntrospection;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@BeanClassIntrospection(enabled=false)
public class NativeLevel
extends NativeMetadata
implements ILevel {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(NativeLevel.class);
    protected final NativeHierarchy hierarchy;
    protected final LevelRecord record;
    private volatile List<NativeProperty> memberProperties = null;
    private final Object memberPropertiesInitLock = new Object();
    private volatile List<NativeMember> members = null;
    private final Object membersInitLock = new Object();

    NativeLevel(NativeMetadataConnection theMDConnection, LevelRecord theRecord, NativeHierarchy theHierarchy) {
        super(theMDConnection);
        this.record = theRecord;
        this.hierarchy = theHierarchy;
    }

    @Override
    protected MetadataRecord getRecord() {
        return this.record;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public int getCardinality() {
        return this.record.getCardinality();
    }

    @Override
    public IDimension getDimension() {
        return this.hierarchy.getDimension();
    }

    @Override
    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public int getIndex() {
        return this.record.getLevelNumber();
    }

    @Override
    public List<IProperty> getMemberProperties() {
        this.initializeMemberProperties();
        List<NativeProperty> result = Collections.unmodifiableList(this.memberProperties);
        return CollectionCast.upcast(result, IProperty.class);
    }

    @Override
    public IProperty getMemberProperty(String name) {
        this.initializeMemberProperties();
        for (IProperty iProperty : this.memberProperties) {
            if (!iProperty.getName().equals(name)) continue;
            return iProperty;
        }
        return null;
    }

    @Override
    public List<IMember> getMembers() {
        this.initializeMembers();
        List<NativeMember> result = Collections.unmodifiableList(this.members);
        return CollectionCast.upcast(result, IMember.class);
    }

    @Override
    public List<IMember> getMembers(int startIndex, int count) {
        List<IMember> allMembers = this.getMembers();
        if (allMembers.size() < startIndex + count) {
            count = allMembers.size() - startIndex;
        }
        return allMembers.subList(startIndex, startIndex + count);
    }

    @Override
    public ILevel getNextLevel() {
        int index = this.getIndex();
        if (index < 0) {
            index = this.hierarchy.getLevelIndex(this);
        }
        if (++index < this.hierarchy.getLevelCount()) {
            return this.hierarchy.getLevel(index);
        }
        return null;
    }

    @Override
    public ILevel getPreviousLevel() {
        int index = this.getIndex();
        if (index < 0) {
            index = this.hierarchy.getLevelIndex(this);
        }
        if (--index >= 0) {
            return this.hierarchy.getLevel(index);
        }
        return null;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isLeafLevel() {
        return this.getIndex() == this.hierarchy.getLevelCount() - 1;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isRootLevel() {
        return this.getIndex() == 0;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isUnique() {
        return this.record.hasUniqueMemberNames();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public double getOrderOfMagnitude() {
        return 0.0;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public IDataType getDataType() {
        return DataTypeFactory.getLevelUniqueNameType();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public MetadataType getObjectType() {
        return MetadataType.LEVEL;
    }

    @Override
    public IMetadata getParentObject() {
        return this.hierarchy;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        List<IMember> result = this.getMembers();
        return CollectionCast.upcast(result, IMetadata.class);
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return this.getMembers().size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMemberProperties() {
        if (null != this.memberProperties) {
            return;
        }
        Object object = this.memberPropertiesInitLock;
        synchronized (object) {
            if (null == this.memberProperties) {
                NativeMetadataConnection connection = this.getNativeConnection();
                NativeDimension dimension = (NativeDimension)this.hierarchy.getDimension();
                NativeCube cube = (NativeCube)dimension.getCube();
                ArrayList<NativeProperty> theList = new ArrayList<NativeProperty>();
                MetadataRestriction restrictions = new MetadataRestriction();
                restrictions.add(RestrictionType.CATALOG, cube.getCatalog().getName());
                restrictions.add(RestrictionType.CUBE, cube.getName());
                restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimension.getUniqueName());
                restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.hierarchy.getUniqueName());
                restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, this.getUniqueName());
                restrictions.add(RestrictionType.LEVEL_NUMBER, this.getIndex());
                List<PropertyRecord> propertyRecords = connection.getMetadataProvider().getProperties(restrictions);
                theList.ensureCapacity(propertyRecords.size());
                for (PropertyRecord propertyRecord : propertyRecords) {
                    theList.add(new NativeProperty(connection, propertyRecord, this));
                }
                this.memberProperties = theList;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMembers() {
        if (null != this.members) {
            return;
        }
        Object object = this.membersInitLock;
        synchronized (object) {
            if (null == this.members) {
                NativeMetadataConnection connection = this.getNativeConnection();
                NativeDimension dimension = (NativeDimension)this.hierarchy.getDimension();
                NativeCube cube = (NativeCube)dimension.getCube();
                MetadataRestriction restrictions = new MetadataRestriction();
                restrictions.add(RestrictionType.CATALOG, cube.getCatalog().getName());
                restrictions.add(RestrictionType.CUBE, cube.getName());
                restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimension.getUniqueName());
                restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.hierarchy.getUniqueName());
                restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, this.getUniqueName());
                restrictions.add(RestrictionType.LEVEL_NUMBER, this.getIndex());
                List<MemberRecord> memberRecords = connection.getMetadataProvider().getMembers(restrictions);
                if (memberRecords.isEmpty()) {
                    this.members = Collections.emptyList();
                }
                ArrayList<NativeMember> theList = new ArrayList<NativeMember>(memberRecords.size());
                for (MemberRecord memberRecord : memberRecords) {
                    NativeMember theMember = this.hierarchy.getCachedMember(memberRecord.getUniqueName());
                    if (null == theMember) {
                        theMember = new NativeMember(connection, memberRecord, this);
                        this.hierarchy.putCachedMember(theMember);
                    }
                    theList.add(theMember);
                }
                this.members = theList;
            }
        }
    }

    @Override
    public IMember getMember(String uniqueName) {
        return null;
    }

    @Override
    public ISortItem[] getSortItems() {
        return new ISortItem[0];
    }
}

