/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider.nativeodp;

import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.nativeodp.NativeDimension;
import com.cognos.xqe.metadata.provider.nativeodp.NativeHierarchy;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMeasure;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMeasureLevel;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanMethodIntrospection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@BeanClassIntrospection(enabled=false)
public class NativeMeasureHierarchy
extends NativeHierarchy {
    private volatile NativeMeasure defaultMeasure = null;
    private final Object defaultMeasureInitLock = new Object();

    NativeMeasureHierarchy(NativeMetadataConnection theMDConnection, HierarchyRecord theRecord, NativeDimension theDimension) {
        super(theMDConnection, theRecord, theDimension);
    }

    public IMeasure getDefaultMeasure() {
        this.initializeDefaultMeasure();
        return this.defaultMeasure;
    }

    @Override
    public IMember getDefaultMember() {
        return this.getDefaultMeasure();
    }

    public IMember getAllMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMember getHighestLevelRollup() {
        throw new UnsupportedOperationException();
    }

    public List<IMeasure> getMeasures() {
        List<NativeMeasureLevel> measureLevels = CollectionCast.downcast(this.getLevels(), ILevel.class, NativeMeasureLevel.class);
        ArrayList<IMeasure> result = new ArrayList<IMeasure>();
        for (NativeMeasureLevel level : measureLevels) {
            result.addAll(level.getMeasures());
        }
        return Collections.unmodifiableList(result);
    }

    public IMeasure getMeasure(String measureUniqueName) {
        for (IMeasure measure : this.getMeasures()) {
            if (!measure.getUniqueName().equals(measureUniqueName)) continue;
            return measure;
        }
        return null;
    }

    @Override
    public Iterator<IMember> getMemberIterator() {
        Iterator<IMeasure> result = this.getMeasures().iterator();
        return CollectionCast.upcast(result, IMember.class);
    }

    @Override
    public IMember[] getMembers() {
        return this.getMeasures().toArray(new IMember[0]);
    }

    @Override
    public IMember getMember(String measureUniqueName) {
        return this.getMeasure(measureUniqueName);
    }

    @Override
    public List<String> getRelatedHierarchyNames(ILevel lowestLevel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMember getRootMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isMultiRoot() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isRagged() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isUnbalanced() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDefaultMeasure() {
        if (null != this.defaultMeasure) {
            return;
        }
        Object object = this.defaultMeasureInitLock;
        synchronized (object) {
            if (null == this.defaultMeasure) {
                String defaultMeasureName = this.record.getDefaultMemberUniqueName();
                if (null != defaultMeasureName) {
                    this.defaultMeasure = (NativeMeasure)this.getMeasure(defaultMeasureName);
                }
                if (null == this.defaultMeasure) {
                    this.defaultMeasure = (NativeMeasure)this.getMeasures().get(0);
                }
            }
        }
    }
}

