/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider.nativeodp;

import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.provider.nativeodp.NativeCube;
import com.cognos.xqe.metadata.provider.nativeodp.NativeDimension;
import com.cognos.xqe.metadata.provider.nativeodp.NativeHierarchy;
import com.cognos.xqe.metadata.provider.nativeodp.NativeLevel;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMeasure;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMeasureHierarchy;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanMethodIntrospection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@BeanClassIntrospection(enabled=false)
public class NativeMeasureLevel
extends NativeLevel {
    private volatile List<NativeMeasure> measures = null;
    private final Object measuresInitLock = new Object();

    NativeMeasureLevel(NativeMetadataConnection theMDConnection, LevelRecord theRecord, NativeMeasureHierarchy theHierarchy) {
        super(theMDConnection, theRecord, theHierarchy);
    }

    @Override
    public List<IProperty> getMemberProperties() {
        return Collections.emptyList();
    }

    @Override
    public IProperty getMemberProperty(String name) {
        return null;
    }

    @Override
    public List<IMember> getMembers() {
        return CollectionCast.upcast(this.getMeasures(), IMember.class);
    }

    public List<IMeasure> getMeasures() {
        this.initializeMeasures();
        List<NativeMeasure> result = Collections.unmodifiableList(this.measures);
        return CollectionCast.upcast(result, IMeasure.class);
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isUnique() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeMeasures() {
        if (null != this.measures) {
            return;
        }
        Object object = this.measuresInitLock;
        synchronized (object) {
            if (null == this.measures) {
                NativeMetadataConnection connection = this.getNativeConnection();
                NativeHierarchy hierarchy = (NativeHierarchy)this.getHierarchy();
                NativeDimension dimension = (NativeDimension)hierarchy.getDimension();
                NativeCube cube = (NativeCube)dimension.getCube();
                ArrayList<NativeMeasure> theList = new ArrayList<NativeMeasure>();
                MetadataRestriction restrictions = new MetadataRestriction();
                restrictions.add(RestrictionType.CATALOG, cube.getCatalog().getName());
                restrictions.add(RestrictionType.CUBE, cube.getName());
                restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimension.getUniqueName());
                restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hierarchy.getUniqueName());
                restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, this.getUniqueName());
                List<MeasureRecord> measureRecords = this.getMetadataProvider().getMeasures(restrictions);
                for (MeasureRecord measureRecord : measureRecords) {
                    NativeMeasure theMeasure = new NativeMeasure(connection, measureRecord, this);
                    theList.add(theMeasure);
                }
                this.measures = theList;
            }
        }
    }
}

