/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider.nativeodp;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.nativeodp.NativeHierarchy;
import com.cognos.xqe.metadata.provider.nativeodp.NativeLevel;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadata;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanMethodIntrospection;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.Collections;
import java.util.List;

@BeanClassIntrospection(enabled=false)
public class NativeMember
extends NativeMetadata
implements IMember {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(NativeMember.class);
    private final NativeLevel level;
    private final MemberRecord record;
    private volatile NativeMember parent = null;
    private final Object parentInitLock = new Object();
    private volatile List<NativeMember> children = null;
    private final Object childrenInitLock = new Object();

    public NativeMember(NativeMetadataConnection theMDConnection, MemberRecord theRecord, NativeLevel theLevel) {
        super(theMDConnection);
        this.record = theRecord;
        this.level = theLevel;
    }

    @Override
    protected MetadataRecord getRecord() {
        return this.record;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public Object getBusinessKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value getBusinessKeyValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value getCaptionValue() {
        StringValue v = DataValueFactory.createStringValue();
        ((Value)v).set(this.getCaption());
        return v;
    }

    @Override
    public int getChildIndex(IMember child) {
        return this.getChildren().indexOf(child);
    }

    @Override
    public IMember getChildMember(String memberName) {
        return (IMember)MetadataUtil.findChild(this, MetadataType.MEMBER, memberName);
    }

    @Override
    public IMember[] getChildMembers() {
        return this.getChildren().toArray(new IMember[0]);
    }

    @Override
    public List<IMember> getChildren() {
        this.initializeChildren();
        List<NativeMember> result = Collections.unmodifiableList(this.children);
        return CollectionCast.upcast(result, IMember.class);
    }

    public List<IMember> getChildren(int startIndex, int count) {
        return this.getChildren().subList(startIndex, startIndex + count);
    }

    @Override
    public int getChildrenCardinality() {
        return this.getChildren().size();
    }

    @Override
    public IMember getDataMember() {
        String dataMUN = this.record.getDataMemberUniqueName();
        if (null == dataMUN || this.getUniqueName().equals(dataMUN)) {
            return this;
        }
        NativeHierarchy hierarchy = (NativeHierarchy)this.level.getHierarchy();
        return hierarchy.fetchMember(dataMUN);
    }

    @Override
    public IDimension getDimension() {
        return this.level.getDimension();
    }

    @Override
    public IHierarchy getHierarchy() {
        return this.level.getHierarchy();
    }

    @Override
    public ILevel getLevel() {
        return this.level;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public int getNumberOfParents() {
        return this.record.getParentCount();
    }

    @Override
    public IMember getParent() {
        this.initializeParent();
        return this.parent;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public int getParentLevelNumber() {
        return this.record.getParentLevelNumber();
    }

    @Override
    public String getParentObjectUniqueName() {
        return this.record.getParentUniqueName();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public String getParentUniqueName() {
        return this.record.getParentUniqueName();
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AggregateTypeEnum getSemiAggregate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        throw new UnsupportedOperationException();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public RollupTypeEnum getRollupType() {
        return this.record.getRollupType();
    }

    @Override
    public IMember[] getSiblings(boolean includeSelf) {
        IMember theParent = this.getParent();
        if (null == theParent) {
            return new IMember[0];
        }
        List<IMember> siblings = theParent.getChildren();
        if (!includeSelf) {
            siblings.remove(this);
        }
        return siblings.toArray(new IMember[0]);
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public MemberTypeEnum getType() {
        return this.record.getType();
    }

    @Override
    public String getV5MUN() {
        throw new UnsupportedOperationException();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberTypeChildRef() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberWithFormula() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isProviderDefaultMember() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isContextMember() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isMeasure() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isSuppressed() {
        return false;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        if (this.getLevel().isLeafLevel()) {
            return Collections.emptyList();
        }
        List<IMember> result = this.getChildren();
        return CollectionCast.upcast(result, IMetadata.class);
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public IDataType getDataType() {
        return DataTypeFactory.getMemberType();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public MetadataType getObjectType() {
        return MetadataType.MEMBER;
    }

    @Override
    public IMetadata getParentObject() {
        if (this.getLevel().isRootLevel()) {
            return this.getLevel();
        }
        return this.getParent();
    }

    @Override
    public boolean hasChildMetadataObjects() {
        if (this.getLevel().isLeafLevel()) {
            return false;
        }
        return this.getChildren().size() > 0;
    }

    @Override
    public Object copy() {
        return this;
    }

    @Override
    public void copyFrom(IValue value) {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".copyFrom(IValue)");
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isMetadata() {
        return true;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isPrimitive() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isResultSet() {
        return false;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public boolean isNull() {
        return false;
    }

    @Override
    public void setNull() {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".setNull()");
    }

    @Override
    public int sizeOf() {
        return ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.DEFAULT);
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Member", -1);
        xmlWriter.attribute("Hierarchy", this.getLevel().getHierarchy().getUniqueName());
        xmlWriter.beginElement("UName", -1);
        xmlWriter.data(this.getUniqueName());
        xmlWriter.endElement();
        xmlWriter.beginElement("Caption", -1);
        xmlWriter.data(this.getCaption());
        xmlWriter.endElement();
        xmlWriter.beginElement("LName", -1);
        xmlWriter.data(this.getLevel().getUniqueName());
        xmlWriter.endElement();
        xmlWriter.beginElement("LNum", -1);
        xmlWriter.data(String.valueOf(this.getLevel().getIndex()));
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (other instanceof TextValue) {
            TextValue otherTextValue = (TextValue)other;
            String tmp = this.getCaption();
            if (null == tmp) {
                return otherTextValue.isNull();
            }
            return tmp.equals(otherTextValue.getString());
        }
        return super.equals(other);
    }

    @Override
    public int compareTo(Object other) {
        if (null == other) {
            return -1;
        }
        if (other instanceof TextValue) {
            TextValue otherTextValue = (TextValue)other;
            String tmp = this.getCaption();
            if (null == tmp) {
                if (otherTextValue.isNull()) {
                    return 0;
                }
                return -1;
            }
            return tmp.compareTo(otherTextValue.getString());
        }
        return super.compareTo(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeParent() {
        if (null != this.parent) {
            return;
        }
        Object object = this.parentInitLock;
        synchronized (object) {
            if (null == this.parent) {
                NativeHierarchy hierarchy = (NativeHierarchy)this.level.getHierarchy();
                String parentMUN = this.getParentUniqueName();
                if (null != parentMUN && parentMUN.length() > 0) {
                    this.parent = hierarchy.fetchMember(parentMUN);
                }
                if (null == this.parent) {
                    this.parent = hierarchy.fetchParentMember(this.getUniqueName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeChildren() {
        if (null != this.children) {
            return;
        }
        Object object = this.childrenInitLock;
        synchronized (object) {
            if (null == this.children) {
                NativeHierarchy hierarchy = (NativeHierarchy)this.level.getHierarchy();
                this.children = hierarchy.fetchChildMembers(this.getUniqueName());
            }
        }
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isRelational() {
        return false;
    }

    @Override
    public boolean isDataBaseCalculation() {
        return false;
    }
}

