/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider.nativeodp;

import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.nativeodp.NativeMetadataConnection;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanMethodIntrospection;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.ibm.icu.text.Collator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@BeanClassIntrospection(enabled=false)
public abstract class NativeMetadata
implements IMetadata {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(NativeMetadata.class);
    public static final String AUTO_GENERATED = "AUTO_GENERATED";
    private final NativeMetadataConnection mdConnection;
    private int cachedHashCode = Integer.MIN_VALUE;

    NativeMetadata(NativeMetadataConnection theMDConnection) {
        this.mdConnection = theMDConnection;
    }

    protected abstract MetadataRecord getRecord();

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public Set<String> getAvailableProperties() {
        String[] fieldNames = this.getRecord().getDynamicFieldNames();
        HashSet<String> result = new HashSet<String>();
        for (String field : fieldNames) {
            result.add(field);
        }
        return result;
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public String getCaption() {
        LocalizedString localizedStr = this.getRecord().getCaption();
        if (localizedStr != null) {
            return localizedStr.toString();
        }
        return null;
    }

    @Override
    public MetadataConnection getConnection() {
        return this.mdConnection;
    }

    NativeMetadataConnection getNativeConnection() {
        return this.mdConnection;
    }

    IOLAPMetadataProvider getMetadataProvider() {
        return this.getNativeConnection().getMetadataProvider();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public String getDescription() {
        return this.getRecord().getDescription();
    }

    @Override
    public String getScreenTip() {
        return null;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.getRecord().getDynamicField(propertyName);
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public String getUniqueID() {
        return this.getRecord().getUniqueId();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public String getName() {
        return this.getRecord().getName();
    }

    @Override
    @BeanMethodIntrospection(enabled=true)
    public String getUniqueName() {
        String uniqueName = this.getRecord().getUniqueName();
        if (null == uniqueName) {
            uniqueName = this.getRecord().getName();
        }
        return uniqueName;
    }

    @Override
    public String getV5UniqueName() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "NativeMetadata.getV5UniqueName()");
    }

    @Override
    public String getID() {
        return this.getV5UniqueName();
    }

    @Override
    public int compareTo(Object other) {
        if (null == other) {
            return -1;
        }
        if (this == other) {
            return 0;
        }
        if (!(other instanceof IMetadata)) {
            return -1;
        }
        IMetadata otherMetadata = (IMetadata)other;
        CompareToBuilder ctb = new CompareToBuilder();
        ctb.append((Object)this.getObjectType(), (Object)otherMetadata.getObjectType());
        ctb.append((Object)this.getUniqueName(), (Object)otherMetadata.getUniqueName());
        return ctb.toComparison();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof IMetadata)) {
            return false;
        }
        IMetadata otherMetadata = (IMetadata)other;
        if (this.getObjectType() != otherMetadata.getObjectType()) {
            return false;
        }
        return this.getUniqueName().equals(otherMetadata.getUniqueName());
    }

    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append(this.getObjectType().ordinal());
            hcb.append((Object)this.getUniqueName());
            this.cachedHashCode = hcb.toHashCode();
            if (this.cachedHashCode == Integer.MIN_VALUE) {
                this.cachedHashCode = 0;
            }
        }
        return this.cachedHashCode;
    }

    public int fastHash() {
        return this.hashCode();
    }

    public Object hashKey() {
        return new MetadataKey(new Object[]{this.getObjectType(), this.getUniqueName()});
    }

    public Object hashKey(Collator collator) {
        return this.hashKey();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(this.getObjectType().toString()).append(": ").append(this.getUniqueName());
        buf.append(']');
        return buf.toString();
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isMFW() {
        return false;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        return Collections.emptyList();
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return null;
    }

    @Override
    public boolean isAccessible() {
        return false;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        return null;
    }

    public Object toJSON() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isVisible(boolean inShortcut) {
        return false;
    }
}

