/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.provider.nativeodp;

import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IMultiRequestGateway;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IPhysicalTable;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.nativeodp.NativeCatalog;
import com.cognos.xqe.metadata.provider.nativeodp.NativeCube;
import com.cognos.xqe.metadata.provider.nativeodp.NativeNamespace;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5tocogsql.util.aggregateAwareness.IAggregateAwareness;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.IMetadataContextManager;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.IUndirectedGraph;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IParameterMaps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NativeMetadataConnection
implements MetadataConnection {
    private static final String LOG_EVENT_GROUP = "MetadataConnection.NativeODP";
    private static final String LOGMSG_CONNECTED = "Established connection ";
    private static final String LOGMSG_CONNECTION_FAILED = "Connection failed ";
    private static final String LOGMSG_RELEASING = "Releasing connection ";
    private static final String LOGMSG_CAUSED_BY = "; Caused by: ";
    private static XQELogger logger = null;
    private String rootName = "";
    private IDataSource dataSource = null;
    private IOLAPMetadataProvider metadataProvider = null;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private volatile NativeNamespace rootNamespace = null;
    private final Object rootNamespaceInitLock = new Object();
    private NativeCatalog defaultCatalog = null;
    private final Map<MetadataKey, NativeCube> cubeCache = new HashMap<MetadataKey, NativeCube>();
    private final ReadWriteLock cubeCacheLock = new ReentrantReadWriteLock(true);

    @Override
    public List<IMetadata> queryMetadata(String queryString) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getModelName() {
        return this.rootName;
    }

    IOLAPMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public IMetadata bindMetadataReference(String ref) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IMetadata> getPhysicalMetadata(String aDataSource, String aCatalog, String aSchema, String name, boolean isTable, boolean mdCallbackEnabled) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "NativeMetadataConnection.getPhysicalMetadata()");
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public boolean isStale(boolean ignoreRetainPeriod, boolean isMetadataRequest) {
        return false;
    }

    @Override
    @Deprecated
    public void connect(String connectionString, String expressionLocale, IExecutionEnvironment execEnv, MFWRequestContext requestContext) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "NativeMetadataConnection.connect()");
    }

    public void connect(MetadataQueryArguments queryArguments) {
        if (null == queryArguments) {
            throw new IllegalArgumentException("queryArguments");
        }
        this.dataSource = queryArguments.getDataSource();
        if (!this.connected.compareAndSet(false, true)) {
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionAlreadyOpen, this.dataSource.getDataSourceConnection().getConnectionString(null));
        }
        Map<String, Object> metadataProps = queryArguments.getDataSource().getMetadataProperties();
        String catalogName = (String)metadataProps.get("catalog");
        XQELogger traceLogger = NativeMetadataConnection.getLogger();
        try {
            IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(this.dataSource.getType());
            this.rootName = this.dataSource.getDataSourceConnection().getConnectionString(null);
            this.metadataProvider = dataProvider.getMetadataProvider(queryArguments);
            if (this.metadataProvider != null) {
                INamespace root = this.getRootNamespace();
                this.defaultCatalog = catalogName != null ? (NativeCatalog)MetadataUtil.findChild(root, MetadataType.CATALOG, catalogName) : (NativeCatalog)root.getChildMetadataObjects().get(0);
                if (this.defaultCatalog == null) {
                    CatalogRecord record = new CatalogRecord();
                    record.setName(catalogName);
                    record.setUniqueName(catalogName);
                    record.setCaption(catalogName);
                    this.defaultCatalog = new NativeCatalog(this, record, (NativeNamespace)root);
                }
            }
        }
        catch (Exception ex) {
            if (traceLogger.isOn(LogLevel.ERROR)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append(LOGMSG_CONNECTION_FAILED).append(this.dataSource.getDataSourceConnection().getConnectionString(null));
                logBuf.append(LOGMSG_CAUSED_BY);
                traceLogger.log(LogLevel.ERROR, logBuf.toString(), (Throwable)ex);
            }
            throw new XQERuntimeException(XQEMessageKeys.MD_MetadataConnectionFailed, (Throwable)ex, this.dataSource.getDataSourceConnection().getConnectionString(null));
        }
        if (traceLogger.isOn()) {
            StringBuilder logBuf = new StringBuilder();
            logBuf.append(LOGMSG_CONNECTED).append(this.dataSource.getDataSourceConnection().getConnectionString(null));
            traceLogger.log(logBuf.toString());
        }
    }

    public ICatalog getCatalog(String catalogName) {
        this.checkConnectionStatus();
        INamespace root = this.getRootNamespace();
        return (ICatalog)MetadataUtil.findChild(root, MetadataType.CATALOG, catalogName);
    }

    public ICatalog[] getCatalogs() {
        this.checkConnectionStatus();
        INamespace root = this.getRootNamespace();
        List<IMetadata> catalogs = MetadataUtil.findChildren(root, MetadataType.CATALOG);
        ICatalog[] result = new ICatalog[catalogs.size()];
        int i = 0;
        for (IMetadata catalog : catalogs) {
            result[i++] = (ICatalog)catalog;
        }
        return result;
    }

    public ICatalog getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Override
    public ICube getCube() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICube getCube(String cubeName) {
        this.checkConnectionStatus();
        return this.getDefaultCatalog().getCube(cubeName);
    }

    public ICube getCube(String catalogName, String cubeName) {
        this.checkConnectionStatus();
        NativeCube result = this.getCachedCube(catalogName, cubeName);
        if (null != result) {
            return result;
        }
        ICatalog catalog = this.getCatalog(catalogName);
        if (null == catalog) {
            return null;
        }
        return catalog.getCube(cubeName);
    }

    @Override
    public ICube[] getCubes() {
        this.checkConnectionStatus();
        return this.getDefaultCatalog().getCubes();
    }

    public ICube[] getCubes(String catalogName) {
        this.checkConnectionStatus();
        ICatalog catalog = this.getCatalog(catalogName);
        if (null == catalog) {
            return null;
        }
        return catalog.getCubes();
    }

    @Override
    public List<IModelDataSource> getModelDataSources() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "NativeMetadataConnection.getDatasources()");
    }

    @Override
    public List<String> getModelFunctionSetVendorIDs() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "NativeMetadataConnection.getModelFunctionSetVendorIDs()");
    }

    @Override
    public IModelDataSource getModelDataSource(String dataSourceName) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "NativeMetadataConnection.getDatasource()");
    }

    @Override
    public Map<String, String> getDataSourceProperties() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "NativeMetadataConnection.getDataSourceProperties()");
    }

    public String getNamedAttribute(IMetadata object, String attribute) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "NativeMetadataConnection.getNamedAttribute()");
    }

    @Override
    public IMetadata getParentObject(IMetadata child) {
        this.checkConnectionStatus();
        return child.getParentObject();
    }

    @Override
    public INamespace getRootNamespace() {
        this.checkConnectionStatus();
        this.initializeRootNamespace();
        return this.rootNamespace;
    }

    @Override
    @Deprecated
    public IMetadata initialiseObjectChildren(IMetadata object) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "NativeMetadataConnection.initializeObjectChildren()");
    }

    @Override
    @Deprecated
    public IMetadata initialiseObjectProperties(IMetadata object) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "NativeMetadataConnection.initializeObjectProperties()");
    }

    @Override
    public synchronized void release() {
        if (!this.connected.compareAndSet(true, false)) {
            return;
        }
        XQELogger traceLogger = NativeMetadataConnection.getLogger();
        if (traceLogger.isOn()) {
            StringBuilder logBuf = new StringBuilder();
            logBuf.append(LOGMSG_RELEASING).append(this.dataSource.getDataSourceConnection().getConnectionString(null));
            traceLogger.log(logBuf.toString());
        }
        try {
            if (null != this.metadataProvider) {
                this.metadataProvider.release();
            }
        }
        finally {
            this.metadataProvider = null;
        }
    }

    private void checkConnectionStatus() {
        if (!this.connected.get()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ResourceWasReleased);
        }
        if (null == this.metadataProvider) {
            throw new XQERuntimeException(XQEMessageKeys.MD_ProviderNotConnected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NativeCube getCachedCube(String catalogName, String cubeName) {
        MetadataKey key = new MetadataKey(new Object[]{catalogName, cubeName});
        try {
            this.cubeCacheLock.readLock().lock();
            NativeCube nativeCube = this.cubeCache.get(key);
            return nativeCube;
        }
        finally {
            this.cubeCacheLock.readLock().unlock();
        }
    }

    void putCachedCube(NativeCube theCube) {
        MetadataKey key = new MetadataKey(new Object[]{theCube.getCatalog().getName(), theCube.getName()});
        try {
            this.cubeCacheLock.writeLock().lock();
            this.cubeCache.put(key, theCube);
        }
        finally {
            this.cubeCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRootNamespace() {
        if (null != this.rootNamespace) {
            return;
        }
        Object object = this.rootNamespaceInitLock;
        synchronized (object) {
            if (null == this.rootNamespace) {
                NativeNamespace root = new NativeNamespace(this, this.rootName);
                MetadataRestriction restrictions = new MetadataRestriction();
                List<CatalogRecord> catalogRecords = this.metadataProvider.getCatalogs(restrictions);
                for (CatalogRecord record : catalogRecords) {
                    root.addChildObject(new NativeCatalog(this, record, root));
                }
                this.rootNamespace = root;
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(NativeMetadataConnection.class.getName());
        if (null == this.dataSource) {
            buf.append("(not connected)");
        } else {
            IDataSourceConnection dsConn = this.dataSource.getDataSourceConnection();
            buf.append("(providerType=").append(this.dataSource.getType());
            buf.append(", connectionString=").append(dsConn.getConnectionString(null)).append(")");
        }
        return buf.toString();
    }

    private static XQELogger getLogger() {
        if (null == logger) {
            logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", LOG_EVENT_GROUP, LogLevel.INFO);
        }
        return logger;
    }

    @Override
    public IParameterMaps getParameterMapsModel() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IParameterMaps getQIParameterMapsModel() {
        throw new UnsupportedOperationException();
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public IMetadata getFunction(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IScopeRelationship[] getScopeRelationships(String id) {
        throw new UnsupportedOperationException();
    }

    public List<IMetadata> getShortcuts() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IMetadata> getRelationships() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IMetadata> getRelationshipShortcuts() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IMetadata> getJoins(Governors governors) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IMetadata> getDummyRelationships(Governors governors) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IMetadata> getEntities() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IUndirectedGraph getGraph(Governors governors) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HashMap<String, IMetadata> getIdToJoinMap(Governors governors) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Locale getContentLocale() {
        return null;
    }

    @Override
    public Locale getExpressionLocale() {
        return null;
    }

    @Override
    public Locale getProductLocale() {
        return null;
    }

    @Override
    public Locale getDefaultLocale(IMetadata obj) {
        return null;
    }

    @Override
    public String getModelPath() {
        return this.getModelName();
    }

    @Override
    public List<IShortcut> getAllShortcuts(IMetadata shortcutOrQuerySubject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDefaultLocaleString() {
        return null;
    }

    @Override
    public String getPackageName() {
        return null;
    }

    @Override
    public List<String> getModelDataSecurityObjects(IRequestEnvironment reqEnv) {
        return null;
    }

    @Override
    public long getModelModificationTime(String passport, BIBusEnvelope envelope) {
        return 0L;
    }

    @Override
    public boolean isTreatedAsAlias(IShortcut sc, Governors governors) {
        return false;
    }

    @Override
    public IMetadata getTargetOfReferenceShortcut(IMetadata metadata) {
        return null;
    }

    @Override
    public IMetadata updateIDToMetadataReferenceMap(String ref, IMetadata metadata) {
        return null;
    }

    @Override
    public String verifyModelPath(String modelPath) {
        return null;
    }

    @Override
    public boolean toFile() {
        return false;
    }

    @Override
    public IMultiRequestGateway getGateway() {
        return null;
    }

    @Override
    public Object getModelConnectionItem(String item) {
        return null;
    }

    @Override
    public IAggregateAwareness getAggregateAwareness() {
        return null;
    }

    @Override
    public IMetadataContextManager getMetadataContextManager() {
        return null;
    }

    @Override
    public IPhysicalTable getPhysicalTable(String theDataSource, String theCatalog, String theSchema, String theName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getModelType() {
        return null;
    }

    @Override
    public void refreshMetadata() {
    }

    @Override
    public void transferNags(IExecutionEnvironment execEnv) {
    }

    @Override
    public String getID(IMetadata metadata) {
        return metadata.getID();
    }

    @Override
    public String getV5UniqueName(IMetadata metadata) {
        return metadata.getV5UniqueName();
    }

    @Override
    public String getJoinGraph() {
        return null;
    }

    @Override
    public void setJoinGraph(String joinGraph) {
    }
}

