/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class AliasRecord
extends MetadataRecord {
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement
    private String dimensionUniqueName = "";

    public AliasRecord() {
        this.setCaption(LocalizedString.emptyString());
    }

    @Override
    public RecordType getRecordType() {
        return RecordType.ALIAS;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    public void setCatalogName(String theCatalogName) {
        AliasRecord.assertNotNull(theCatalogName);
        this.catalogName = AliasRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        AliasRecord.assertNotNull(theSchemaName);
        this.schemaName = AliasRecord.internalizeString(theSchemaName);
    }

    public void setCubeName(String theCubeName) {
        AliasRecord.assertNotNull(theCubeName);
        this.cubeName = AliasRecord.internalizeString(theCubeName);
    }

    public void setDimensionUniqueName(String theDimensionUniqueName) {
        this.dimensionUniqueName = AliasRecord.internalizeString(theDimensionUniqueName);
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        ExternalizeUtil.externalizeString(output, this.getDimensionUniqueName());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setDimensionUniqueName(ExternalizeUtil.deexternalizeString(input));
    }

    public void copyTo(AliasRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setDimensionUniqueName(this.getDimensionUniqueName());
    }

    @Override
    public Object copy() {
        AliasRecord clonedRecord = new AliasRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

