/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class CubeRecord
extends MetadataRecord {
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement(callMethod="name")
    private ICube.CubeSuppressionTypeEnum suppressionType = ICube.CubeSuppressionTypeEnum.NULL;
    @XMLElement(callMethod="getString")
    private DateTimeValue createdDate = null;
    @XMLElement(callMethod="getString")
    private DateTimeValue dataUpdateDate = null;
    @XMLElement(callMethod="getString")
    private DateTimeValue schemaUpdateDate = null;
    @XMLElement
    private String currentPeriod = null;
    @XMLElement
    private boolean isOptimized = true;

    @Override
    public RecordType getRecordType() {
        return RecordType.CUBE;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public ICube.CubeSuppressionTypeEnum getSuppressionType() {
        return this.suppressionType;
    }

    public DateTimeValue getCreatedDate() {
        return this.createdDate;
    }

    public DateTimeValue getDataUpdateDate() {
        return this.dataUpdateDate;
    }

    public DateTimeValue getSchemaUpdateDate() {
        return this.schemaUpdateDate;
    }

    public String getCurrentPeriod() {
        return this.currentPeriod;
    }

    public boolean getIsOptimized() {
        return this.isOptimized;
    }

    public DateTimeValue getCubeRevision() {
        if (this.dataUpdateDate == null) {
            return null;
        }
        if (this.schemaUpdateDate == null) {
            return this.dataUpdateDate;
        }
        if (this.dataUpdateDate.compareTo(this.schemaUpdateDate) > 0) {
            return this.dataUpdateDate;
        }
        return this.schemaUpdateDate;
    }

    public void setCatalogName(String theCatalogName) {
        CubeRecord.assertNotNull(theCatalogName);
        this.catalogName = CubeRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        CubeRecord.assertNotNull(theSchemaName);
        this.schemaName = CubeRecord.internalizeString(theSchemaName);
    }

    public void setSuppressionType(ICube.CubeSuppressionTypeEnum theSuppressionType) {
        CubeRecord.assertNotNull((Object)theSuppressionType);
        this.suppressionType = theSuppressionType;
    }

    public void setCreatedDate(DateTimeValue theCreatedDate) {
        this.createdDate = theCreatedDate;
    }

    public void setDataUpdateDate(DateTimeValue theDataUpdateDate) {
        this.dataUpdateDate = theDataUpdateDate;
    }

    public void setSchemaUpdateDate(DateTimeValue theSchemaUpdateDate) {
        this.schemaUpdateDate = theSchemaUpdateDate;
    }

    public void setCurrentPeriod(String theCurrentPeriod) {
        this.currentPeriod = theCurrentPeriod;
    }

    public void setIsOptimized(boolean optimized) {
        this.isOptimized = optimized;
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        String suppressionTypeName = this.getSuppressionType().name();
        ExternalizeUtil.externalizeString(output, suppressionTypeName);
        ExternalizeUtil.externalizeValue(output, this.getCreatedDate());
        ExternalizeUtil.externalizeValue(output, this.getDataUpdateDate());
        ExternalizeUtil.externalizeValue(output, this.getSchemaUpdateDate());
        ExternalizeUtil.externalizeString(output, this.getCurrentPeriod());
        output.writeBoolean(this.getIsOptimized());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        String suppressionTypeName = ExternalizeUtil.deexternalizeString(input);
        this.setSuppressionType(ICube.CubeSuppressionTypeEnum.valueOf(suppressionTypeName));
        this.setCreatedDate((DateTimeValue)ExternalizeUtil.deexternalizeValue(input));
        this.setDataUpdateDate((DateTimeValue)ExternalizeUtil.deexternalizeValue(input));
        this.setSchemaUpdateDate((DateTimeValue)ExternalizeUtil.deexternalizeValue(input));
        this.setCurrentPeriod(ExternalizeUtil.deexternalizeString(input));
        this.setIsOptimized(input.readBoolean());
    }

    public void copyTo(CubeRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setSuppressionType(this.getSuppressionType());
        theCopy.setCreatedDate(this.getCreatedDate());
        theCopy.setDataUpdateDate(this.getDataUpdateDate());
        theCopy.setSchemaUpdateDate(this.getSchemaUpdateDate());
        theCopy.setCurrentPeriod(this.getCurrentPeriod());
        theCopy.setIsOptimized(this.getIsOptimized());
    }

    @Override
    public Object copy() {
        CubeRecord clonedRecord = new CubeRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

