/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class DimensionRecord
extends MetadataRecord {
    private static final String DIMENSION_GROUP_NAME = "Dimension_Group_Name";
    private static final String DIMENSION_GROUP_DESCRIPTION = "Dimension_Group_Description";
    private static final String DIMENSION_TEXT_TABLE_NAME = "Text_Table_Name";
    private static final String DIMENSION_HAS_TD_TEXT = "Has_Time_Dependent_Text";
    private static final String IS_STRUCTURE = "is_Structure";
    private static final String IS_HIDDEN = "Is_Hidden";
    private static final String IS_NOT_ACCESSIBLE = "Is_Not_Accessible";
    private static final String IS_ATTRIBUTE_DIMENSION = "Is_Attribute_Dimension";
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement
    private DimensionTypeEnum type = DimensionTypeEnum.REGULAR;
    @XMLElement
    private int cardinality = 0;
    @XMLElement
    private String defaultHierarchyUniqueName = null;
    @XMLElement
    private boolean membersRollup = true;

    @Override
    public RecordType getRecordType() {
        return RecordType.DIMENSION;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public DimensionTypeEnum getType() {
        return this.type;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public String getDefaultHierarchyUniqueName() {
        return this.defaultHierarchyUniqueName;
    }

    public boolean getMembersRollup() {
        return this.membersRollup;
    }

    public boolean isHidden() {
        Boolean hidden = this.getDynamicFieldAsBoolean(IS_HIDDEN);
        if (null != hidden) {
            return hidden;
        }
        return false;
    }

    public boolean isNotAccessible() {
        Boolean notAccessible = this.getDynamicFieldAsBoolean(IS_NOT_ACCESSIBLE);
        if (null != notAccessible) {
            return notAccessible;
        }
        return false;
    }

    public void setCatalogName(String theCatalogName) {
        DimensionRecord.assertNotNull(theCatalogName);
        this.catalogName = DimensionRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        DimensionRecord.assertNotNull(theSchemaName);
        this.schemaName = DimensionRecord.internalizeString(theSchemaName);
    }

    public void setCubeName(String theCubeName) {
        DimensionRecord.assertNotNull(theCubeName);
        this.cubeName = DimensionRecord.internalizeString(theCubeName);
    }

    public void setType(DimensionTypeEnum theType) {
        this.type = theType;
    }

    public void setCardinality(int theCardinality) {
        this.cardinality = theCardinality;
    }

    public void setDefaultHierarchyUniqueName(String theDefaultHierarchyUniqueName) {
        this.defaultHierarchyUniqueName = DimensionRecord.internalizeString(theDefaultHierarchyUniqueName);
    }

    public void setHidden(Boolean theIsHidden) {
        this.setDynamicFieldAsBoolean(IS_HIDDEN, theIsHidden);
    }

    public void setNotAccessible(Boolean theIsNotAccessible) {
        this.setDynamicFieldAsBoolean(IS_NOT_ACCESSIBLE, theIsNotAccessible);
    }

    public void setMembersRollup(boolean theMembersRollup) {
        this.membersRollup = theMembersRollup;
    }

    public String getDimensionGroupName() {
        String dimGroupName = this.getDynamicFieldAsString(DIMENSION_GROUP_NAME);
        if (null != dimGroupName) {
            return dimGroupName;
        }
        return "";
    }

    public void setDimensionGroupName(String theDimGroupName) {
        this.setDynamicFieldAsString(DIMENSION_GROUP_NAME, theDimGroupName);
    }

    public String getDimensionGroupDescription() {
        String dimGroupDesc = this.getDynamicFieldAsString(DIMENSION_GROUP_DESCRIPTION);
        if (null != dimGroupDesc) {
            return dimGroupDesc;
        }
        return "";
    }

    public void setDimensionGroupDescription(String theDimGroupDesc) {
        this.setDynamicFieldAsString(DIMENSION_GROUP_DESCRIPTION, theDimGroupDesc);
    }

    public Boolean getDimensionHasTDText() {
        return this.getDynamicFieldAsBoolean(DIMENSION_HAS_TD_TEXT);
    }

    public void setDimensionHasTDText(Boolean hasTDText) {
        this.setDynamicFieldAsBoolean(DIMENSION_HAS_TD_TEXT, hasTDText);
    }

    public String getDimensionTextTableName() {
        return this.getDynamicFieldAsString(DIMENSION_TEXT_TABLE_NAME);
    }

    public void setDimensionTextTableName(String theDimTextTableName) {
        this.setDynamicFieldAsString(DIMENSION_TEXT_TABLE_NAME, theDimTextTableName);
    }

    public Boolean getIsStructure() {
        return this.getDynamicFieldAsBoolean(IS_STRUCTURE);
    }

    public void setIsStructure(Boolean isStructure) {
        this.setDynamicFieldAsBoolean(IS_STRUCTURE, isStructure);
    }

    public Boolean getIsAttributeDimension() {
        return this.getDynamicFieldAsBoolean(IS_ATTRIBUTE_DIMENSION);
    }

    public void setIsAttributeDimension(Boolean isAttributeDimension) {
        this.setDynamicFieldAsBoolean(IS_ATTRIBUTE_DIMENSION, isAttributeDimension);
    }

    public Boolean getIsMeasureDimension() {
        return this.getType().equals((Object)DimensionTypeEnum.MEASURE);
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        output.writeInt(this.getType().ordinal());
        output.writeInt(this.getCardinality());
        ExternalizeUtil.externalizeString(output, this.getDefaultHierarchyUniqueName());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setType(DimensionTypeEnum.valueOf(input.readInt()));
        this.setCardinality(input.readInt());
        this.setDefaultHierarchyUniqueName(ExternalizeUtil.deexternalizeString(input));
    }

    public void copyTo(DimensionRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setType(this.getType());
        theCopy.setCardinality(this.getCardinality());
        theCopy.setDefaultHierarchyUniqueName(this.getDefaultHierarchyUniqueName());
        theCopy.setMembersRollup(this.getMembersRollup());
    }

    @Override
    public Object copy() {
        DimensionRecord clonedRecord = new DimensionRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

