/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.IDynamicField;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public abstract class DynamicFieldBase
implements IDynamicField,
Serializable {
    private static final long serialVersionUID = -1368160542439722611L;
    private static final String ERRMSG_ILLEGAL_TYPE_CAST = "Illegal type cast";
    @XMLElement
    private String name = null;

    public DynamicFieldBase() {
    }

    public DynamicFieldBase(String theName) {
        this.name = theName;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isNull() {
        return this.getTypeCode() == -1;
    }

    @Override
    public boolean booleanValue() throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
        return false;
    }

    @Override
    public byte byteValue() throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
        return 0;
    }

    @Override
    public double doubleValue() throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
        return 0.0;
    }

    @Override
    public float floatValue() throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
        return 0.0f;
    }

    @Override
    public int intValue() throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
        return 0;
    }

    @Override
    public long longValue() throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
        return 0L;
    }

    @Override
    public short shortValue() throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
        return 0;
    }

    @Override
    public String stringValue() throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
        return null;
    }

    @Override
    public Value value() throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
        return null;
    }

    @Override
    public void setBooleanValue(boolean theValue) throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
    }

    @Override
    public void setByteValue(byte theValue) throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
    }

    @Override
    public void setShortValue(short theValue) throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
    }

    @Override
    public void setIntValue(int theValue) throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
    }

    @Override
    public void setLongValue(long theValue) throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
    }

    @Override
    public void setFloatValue(float theValue) throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
    }

    @Override
    public void setDoubleValue(double theValue) throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
    }

    @Override
    public void setStringValue(String theValue) throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
    }

    @Override
    public void setValue(Value theValue) throws ClassCastException {
        DynamicFieldBase.throwIllegalTypeCast();
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        this.name = ExternalizeUtil.deexternalizeString(input);
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        ExternalizeUtil.externalizeString(output, this.name);
    }

    protected static void throwIllegalTypeCast() {
        throw new ClassCastException(ERRMSG_ILLEGAL_TYPE_CAST);
    }

    public abstract Object copy() throws CloneNotSupportedException;

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName()).append('=').append(this.objectValue());
        return buf.toString();
    }
}

