/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.record.BooleanField;
import com.cognos.xqe.metadata.record.ByteField;
import com.cognos.xqe.metadata.record.DoubleField;
import com.cognos.xqe.metadata.record.DynamicFieldBase;
import com.cognos.xqe.metadata.record.FloatField;
import com.cognos.xqe.metadata.record.IDynamicField;
import com.cognos.xqe.metadata.record.IntegerField;
import com.cognos.xqe.metadata.record.LongField;
import com.cognos.xqe.metadata.record.NullField;
import com.cognos.xqe.metadata.record.ShortField;
import com.cognos.xqe.metadata.record.StringField;
import com.cognos.xqe.metadata.record.ValueField;
import com.cognos.xqe.util.LocalizedString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ExternalizeUtil {
    private static final String EMPTY_STRING = "";

    private ExternalizeUtil() {
    }

    public static void externalizeDataType(DataOutput output, IDataType dataType) throws IOException {
        if (null == dataType) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            ExternalizeUtil.externalizeString(output, dataType.getTypeName());
            if (dataType.isExactNumeric()) {
                output.writeInt(dataType.getPrecision());
                output.writeInt(dataType.getScale());
            }
        }
    }

    public static IDataType deexternalizeDataType(DataInput input) throws IOException {
        String name;
        IDataType answer = null;
        boolean flag = input.readBoolean();
        if (flag && (answer = DataTypeFactory.getType(name = ExternalizeUtil.deexternalizeString(input))).isExactNumeric()) {
            byte cclDType = answer.getCCLTypeCode();
            int precision = input.readInt();
            int scale = input.readInt();
            answer = DataTypeFactory.getDataType(cclDType, precision, scale);
        }
        return answer;
    }

    public static void externalizeString(DataOutput output, String value) throws IOException {
        if (null == value) {
            output.writeInt(-1);
        } else {
            output.writeInt(value.length());
            output.writeChars(value);
        }
    }

    public static String deexternalizeString(DataInput input) throws IOException {
        int stringLength = input.readInt();
        if (stringLength < 0) {
            return null;
        }
        StringBuilder stringBuf = new StringBuilder(stringLength + 1);
        for (int i = 0; i < stringLength; ++i) {
            stringBuf.append(input.readChar());
        }
        return stringBuf.toString();
    }

    public static void externalizeLocalizedString(DataOutput output, LocalizedString value) throws IOException {
        if (null == value) {
            output.writeBoolean(false);
            return;
        }
        output.writeBoolean(true);
        String defaultLocale = value.getDefaultLocale();
        String defaultValue = value.toString(defaultLocale);
        ExternalizeUtil.externalizeString(output, defaultLocale);
        ExternalizeUtil.externalizeString(output, defaultValue);
        String[] locales = value.getSupportedLocales();
        output.writeInt(locales.length);
        for (String locale : locales) {
            ExternalizeUtil.externalizeString(output, locale);
            ExternalizeUtil.externalizeString(output, value.toString(locale));
        }
    }

    public static LocalizedString deexternalizeLocalizedString(DataInput input) throws IOException {
        boolean isNotNull = input.readBoolean();
        if (!isNotNull) {
            return new LocalizedString(EMPTY_STRING, EMPTY_STRING);
        }
        String defaultLocale = ExternalizeUtil.deexternalizeString(input);
        String defaultValue = ExternalizeUtil.deexternalizeString(input);
        int numberOfLocales = input.readInt();
        LocalizedString answer = new LocalizedString(defaultLocale, defaultValue);
        for (int i = 0; i < numberOfLocales; ++i) {
            String locale = ExternalizeUtil.deexternalizeString(input);
            String value = ExternalizeUtil.deexternalizeString(input);
            answer.put(locale, value);
        }
        return answer;
    }

    public static void externalizeDynamicFields(DataOutput output, List<IDynamicField> value) throws IOException {
        if (null == value) {
            output.writeInt(-1);
        } else {
            output.writeInt(value.size());
            for (IDynamicField field : value) {
                output.writeInt(field.getTypeCode());
                field.externalize(output);
            }
        }
    }

    public static List<IDynamicField> deexternalizeDynamicFields(DataInput input) throws IOException {
        int numFields = input.readInt();
        if (numFields < 0) {
            return null;
        }
        ArrayList<IDynamicField> fields = new ArrayList<IDynamicField>(numFields);
        for (int i = 0; i < numFields; ++i) {
            int typeCode = input.readInt();
            DynamicFieldBase field = null;
            switch (typeCode) {
                case -1: {
                    field = new NullField(EMPTY_STRING);
                    break;
                }
                case 0: {
                    field = new BooleanField(EMPTY_STRING);
                    break;
                }
                case 1: {
                    field = new ByteField(EMPTY_STRING);
                    break;
                }
                case 6: {
                    field = new DoubleField(EMPTY_STRING);
                    break;
                }
                case 5: {
                    field = new FloatField(EMPTY_STRING);
                    break;
                }
                case 3: {
                    field = new IntegerField(EMPTY_STRING);
                    break;
                }
                case 4: {
                    field = new LongField(EMPTY_STRING);
                    break;
                }
                case 2: {
                    field = new ShortField(EMPTY_STRING);
                    break;
                }
                case 7: {
                    field = new StringField(EMPTY_STRING);
                    break;
                }
                case 8: {
                    field = new ValueField(EMPTY_STRING);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected field type code");
                }
            }
            field.deexternalize(input);
            fields.add(field);
        }
        return fields;
    }

    public static void externalizeValue(DataOutput output, Value value) throws IOException {
        if (null == value) {
            ExternalizeUtil.externalizeDataType(output, null);
        } else {
            ExternalizeUtil.externalizeDataType(output, value.getDataType());
            value.encode(output);
        }
    }

    public static Value deexternalizeValue(DataInput input) throws IOException {
        IDataType dataType = ExternalizeUtil.deexternalizeDataType(input);
        if (null == dataType) {
            return null;
        }
        Value value = (Value)dataType.createValue();
        value.decode(input);
        return value;
    }
}

