/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.metadata.record.DynamicFieldBase;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class FloatField
extends DynamicFieldBase {
    private static final long serialVersionUID = 7496094901662041829L;
    @XMLElement
    private float value = 0.0f;

    public FloatField() {
    }

    public FloatField(String theName) {
        super(theName);
    }

    public FloatField(String theName, float theValue) {
        super(theName);
        this.value = theValue;
    }

    @Override
    public int getTypeCode() {
        return 5;
    }

    @Override
    public Object objectValue() throws ClassCastException {
        return Float.valueOf(this.value);
    }

    @Override
    public float floatValue() throws ClassCastException {
        return this.value;
    }

    @Override
    public void setFloatValue(float theValue) throws ClassCastException {
        this.value = theValue;
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.value = input.readFloat();
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        output.writeFloat(this.value);
    }

    @Override
    public int compareTo(Object other) {
        float rhs;
        if (null == other) {
            return -1;
        }
        if (!(other instanceof FloatField)) {
            return -1;
        }
        FloatField otherField = (FloatField)other;
        float lhs = this.floatValue();
        if (lhs < (rhs = otherField.floatValue())) {
            return -1;
        }
        if (lhs > rhs) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof FloatField)) {
            return false;
        }
        FloatField otherField = (FloatField)other;
        return this.floatValue() == otherField.floatValue();
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.floatValue());
        return hcb.toHashCode();
    }

    @Override
    public Object copy() {
        return new FloatField(this.getName(), this.floatValue());
    }
}

