/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class HierarchyNamedSetRecord
extends NamedSetRecord {
    @XMLElement
    private String dimensionName = "";
    @XMLElement
    private String hierarchyName = "";

    @Override
    public RecordType getRecordType() {
        return RecordType.HIERARCHYNAMEDSET;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getHierarchyName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public String getHierarchyName() {
        return this.hierarchyName;
    }

    public void setDimensionName(String theDimensionName) {
        HierarchyNamedSetRecord.assertNotNull(theDimensionName);
        this.dimensionName = HierarchyNamedSetRecord.internalizeString(theDimensionName);
    }

    public void setHierarchyName(String theHierarchyName) {
        HierarchyNamedSetRecord.assertNotNull(theHierarchyName);
        this.hierarchyName = HierarchyNamedSetRecord.internalizeString(theHierarchyName);
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getDimensionName());
        ExternalizeUtil.externalizeString(output, this.getHierarchyName());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setDimensionName(ExternalizeUtil.deexternalizeString(input));
        this.setHierarchyName(ExternalizeUtil.deexternalizeString(input));
    }

    public void copyTo(HierarchyNamedSetRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setDimensionName(this.getDimensionName());
        theCopy.setHierarchyName(this.getHierarchyName());
        theCopy.setExpression(this.getExpression());
    }

    @Override
    public Object copy() {
        HierarchyNamedSetRecord clonedRecord = new HierarchyNamedSetRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

