/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class HierarchyRecord
extends MetadataRecord {
    private static final String ATTRIBUTE_HIERARCHY = "SSAS_Attribute_Hierarchy";
    private static final String DISPLAY_PATH = "Display_Path";
    private static final String VALID_TO = "Valid_To";
    private static final String VALID_FROM = "Valid_From";
    private static final String IS_HIDDEN = "Is_Hidden";
    private static final String IS_NOT_ACCESSIBLE = "Is_Not_Accessible";
    public static final int PARENTCHILD_BIT = 1;
    public static final int RAGGED_BIT = 2;
    public static final int BALANCED_BIT = 4;
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement
    private String dimensionUniqueName = "";
    @XMLElement
    private String defaultMemberUniqueName = "";
    @XMLElement
    private String highestRollupMemberUniqueName = null;
    @XMLElement
    private int cardinality = 0;
    @XMLElement
    private byte structure = 0;

    @Override
    public RecordType getRecordType() {
        return RecordType.HIERARCHY;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    public String getDefaultMemberUniqueName() {
        return this.defaultMemberUniqueName;
    }

    public String getHighestRollupMemberUniqueName() {
        return this.highestRollupMemberUniqueName;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    protected byte getStructure() {
        return this.structure;
    }

    public boolean isHidden() {
        Boolean hidden = this.getDynamicFieldAsBoolean(IS_HIDDEN);
        if (null != hidden) {
            return hidden;
        }
        return false;
    }

    public boolean isNotAccessible() {
        Boolean notAccessible = this.getDynamicFieldAsBoolean(IS_NOT_ACCESSIBLE);
        if (null != notAccessible) {
            return notAccessible;
        }
        return false;
    }

    public boolean isParentChild() {
        return (this.structure & 1) == 1;
    }

    public boolean isRagged() {
        return (this.structure & 2) == 2;
    }

    public boolean isBalanced() {
        return (this.structure & 4) == 4;
    }

    public void setCatalogName(String theCatalogName) {
        HierarchyRecord.assertNotNull(theCatalogName);
        this.catalogName = HierarchyRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        HierarchyRecord.assertNotNull(theSchemaName);
        this.schemaName = HierarchyRecord.internalizeString(theSchemaName);
    }

    public void setCubeName(String theCubeName) {
        HierarchyRecord.assertNotNull(theCubeName);
        this.cubeName = HierarchyRecord.internalizeString(theCubeName);
    }

    public void setDimensionUniqueName(String theDimensionUniqueName) {
        HierarchyRecord.assertNotNull(theDimensionUniqueName);
        this.dimensionUniqueName = HierarchyRecord.internalizeString(theDimensionUniqueName);
    }

    public void setDefaultMemberUniqueName(String theDefaultMemberUniqueName) {
        HierarchyRecord.assertNotNull(theDefaultMemberUniqueName);
        this.defaultMemberUniqueName = HierarchyRecord.internalizeString(theDefaultMemberUniqueName);
    }

    public void setHighestRollupMemberUniqueName(String theHighestRollupMemberUniqueName) {
        this.highestRollupMemberUniqueName = HierarchyRecord.internalizeString(theHighestRollupMemberUniqueName);
    }

    public void setCardinality(int theCardinality) {
        this.cardinality = theCardinality;
    }

    public void setStructure(byte theStructure) {
        this.structure = theStructure;
    }

    public void setParentChild(boolean value) {
        this.structure = value ? (byte)(this.structure | 1) : (byte)(this.structure & 0xFFFFFFFE);
    }

    public void setRagged(boolean value) {
        this.structure = value ? (byte)(this.structure | 2) : (byte)(this.structure & 0xFFFFFFFD);
    }

    public void setBalanced(boolean value) {
        this.structure = value ? (byte)(this.structure | 4) : (byte)(this.structure & 0xFFFFFFFB);
    }

    public void setHidden(Boolean theIsHidden) {
        this.setDynamicFieldAsBoolean(IS_HIDDEN, theIsHidden);
    }

    public void setNotAccessible(Boolean theIsNotAccessible) {
        this.setDynamicFieldAsBoolean(IS_NOT_ACCESSIBLE, theIsNotAccessible);
    }

    public Boolean getAttributeHierarchy() {
        return this.getDynamicFieldAsBoolean(ATTRIBUTE_HIERARCHY);
    }

    public void setAttributeHierarchy(boolean attributeHierarchy) {
        this.setDynamicFieldAsBoolean(ATTRIBUTE_HIERARCHY, attributeHierarchy);
    }

    public String getDisplayPath() {
        return this.getDynamicFieldAsString(DISPLAY_PATH);
    }

    public void setDisplayPath(String displayPath) {
        this.setDynamicFieldAsString(DISPLAY_PATH, displayPath);
    }

    public String getValidFrom() {
        return this.getDynamicFieldAsString(VALID_FROM);
    }

    public void setValidFrom(String validFrom) {
        this.setDynamicFieldAsString(VALID_FROM, validFrom);
    }

    public String getValidTo() {
        return this.getDynamicFieldAsString(VALID_TO);
    }

    public void setValidTo(String validTo) {
        this.setDynamicFieldAsString(VALID_TO, validTo);
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        ExternalizeUtil.externalizeString(output, this.getDimensionUniqueName());
        ExternalizeUtil.externalizeString(output, this.getDefaultMemberUniqueName());
        ExternalizeUtil.externalizeString(output, this.getHighestRollupMemberUniqueName());
        output.writeInt(this.getCardinality());
        output.writeByte(this.getStructure());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setDimensionUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setDefaultMemberUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setHighestRollupMemberUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setCardinality(input.readInt());
        this.setStructure(input.readByte());
    }

    public void copyTo(HierarchyRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setDimensionUniqueName(this.getDimensionUniqueName());
        theCopy.setDefaultMemberUniqueName(this.getDefaultMemberUniqueName());
        theCopy.setHighestRollupMemberUniqueName(this.getHighestRollupMemberUniqueName());
        theCopy.setCardinality(this.getCardinality());
        theCopy.setStructure(this.getStructure());
    }

    @Override
    public Object copy() {
        HierarchyRecord clonedRecord = new HierarchyRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

