/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.record;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.MetadataKey;
import com.cognos.xqe.metadata.VariableEntryTypeEnum;
import com.cognos.xqe.metadata.VariablePromptTypeEnum;
import com.cognos.xqe.metadata.VariableSelectionTypeEnum;
import com.cognos.xqe.metadata.VariableTypeEnum;
import com.cognos.xqe.metadata.record.ExternalizeUtil;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

@XMLElement
public class VariableRecord
extends MetadataRecord {
    @XMLElement
    private String catalogName = "";
    @XMLElement
    private String schemaName = "";
    @XMLElement
    private String cubeName = "";
    @XMLElement
    private String dimensionUniqueName = null;
    @XMLElement
    private String hierarchyUniqueName = null;
    @XMLElement(callMethod="name")
    private VariableTypeEnum type = VariableTypeEnum.MEMBER;
    @XMLElement(callMethod="name")
    private VariableSelectionTypeEnum selectionType = VariableSelectionTypeEnum.VALUE;
    @XMLElement(callMethod="name")
    private VariablePromptTypeEnum promptType = VariablePromptTypeEnum.TYPEIN;
    @XMLElement(callMethod="ordinal")
    private VariableEntryTypeEnum entryType = VariableEntryTypeEnum.OPTIONAL;
    @XMLElement
    private IDataType dataType = DataTypeFactory.getStringType();
    @XMLElement(callMethod="getString")
    private Value defaultLow = null;
    @XMLElement(callMethod="getString")
    private Value defaultHigh = null;
    @XMLElement
    private String lowCaption = null;
    @XMLElement
    private String highCaption = null;
    @XMLElement
    private boolean fixedValue = false;
    @XMLElement
    private boolean keyDate = false;

    @Override
    public RecordType getRecordType() {
        return RecordType.VARIABLE;
    }

    @Override
    public MetadataKey uniqueKey() {
        if (null == this.cachedUniqueKey) {
            Object[] components = new Object[]{this.getRecordType(), this.getCatalogName(), this.getSchemaName(), this.getCubeName(), this.getUniqueName()};
            this.cachedUniqueKey = new MetadataKey(components);
        }
        return this.cachedUniqueKey;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    public String getHierarchyUniqueName() {
        return this.hierarchyUniqueName;
    }

    public VariableTypeEnum getType() {
        return this.type;
    }

    public VariableSelectionTypeEnum getSelectionType() {
        return this.selectionType;
    }

    public VariablePromptTypeEnum getPromptType() {
        return this.promptType;
    }

    public VariableEntryTypeEnum getEntryType() {
        return this.entryType;
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    public Value getDefaultLow() {
        return this.defaultLow;
    }

    public Value getDefaultHigh() {
        return this.defaultHigh;
    }

    public String getLowCaption() {
        return this.lowCaption;
    }

    public String getHighCaption() {
        return this.highCaption;
    }

    public boolean isFixedValue() {
        return this.fixedValue;
    }

    public boolean isKeyDate() {
        return this.keyDate;
    }

    public void setCatalogName(String theCatalogName) {
        VariableRecord.assertNotNull(theCatalogName);
        this.catalogName = VariableRecord.internalizeString(theCatalogName);
    }

    public void setSchemaName(String theSchemaName) {
        VariableRecord.assertNotNull(theSchemaName);
        this.schemaName = VariableRecord.internalizeString(theSchemaName);
    }

    public void setCubeName(String theCubeName) {
        VariableRecord.assertNotNull(theCubeName);
        this.cubeName = VariableRecord.internalizeString(theCubeName);
    }

    public void setDimensionUniqueName(String theDimensionUniqueName) {
        this.dimensionUniqueName = VariableRecord.internalizeString(theDimensionUniqueName);
    }

    public void setHierarchyUniqueName(String theHierarchyUniqueName) {
        this.hierarchyUniqueName = VariableRecord.internalizeString(theHierarchyUniqueName);
    }

    public void setType(VariableTypeEnum theType) {
        this.type = theType;
    }

    public void setSelectionType(VariableSelectionTypeEnum theSelectionType) {
        this.selectionType = theSelectionType;
    }

    public void setPromptType(VariablePromptTypeEnum thePromptType) {
        this.promptType = thePromptType;
    }

    public void setEntryType(VariableEntryTypeEnum theEntryType) {
        this.entryType = theEntryType;
    }

    public void setDataType(IDataType theDataType) {
        VariableRecord.assertNotNull(theDataType);
        this.dataType = theDataType;
    }

    public void setDefaultLow(Value theDefaultLow) {
        this.defaultLow = theDefaultLow;
    }

    public void setDefaultHigh(Value theDefaultHigh) {
        this.defaultHigh = theDefaultHigh;
    }

    public void setLowCaption(String theLowCaption) {
        this.lowCaption = theLowCaption;
    }

    public void setHighCaption(String theHighCaption) {
        this.highCaption = theHighCaption;
    }

    public void setIsFixedValue(boolean theFixedValue) {
        this.fixedValue = theFixedValue;
    }

    public void setKeyDate(boolean theKeyDate) {
        this.keyDate = theKeyDate;
    }

    @Override
    public void externalize(DataOutput output) throws IOException {
        super.externalize(output);
        ExternalizeUtil.externalizeString(output, this.getCatalogName());
        ExternalizeUtil.externalizeString(output, this.getSchemaName());
        ExternalizeUtil.externalizeString(output, this.getCubeName());
        ExternalizeUtil.externalizeString(output, this.getDimensionUniqueName());
        ExternalizeUtil.externalizeString(output, this.getHierarchyUniqueName());
        output.writeInt(this.getType().ordinal());
        output.writeInt(this.getSelectionType().ordinal());
        output.writeInt(this.getPromptType().ordinal());
        output.writeInt(this.getEntryType().ordinal());
        ExternalizeUtil.externalizeDataType(output, this.getDataType());
        ExternalizeUtil.externalizeValue(output, this.getDefaultLow());
        ExternalizeUtil.externalizeValue(output, this.getDefaultHigh());
        ExternalizeUtil.externalizeString(output, this.getLowCaption());
        ExternalizeUtil.externalizeString(output, this.getHighCaption());
        output.writeBoolean(this.isFixedValue());
        output.writeBoolean(this.isKeyDate());
    }

    @Override
    public void deexternalize(DataInput input) throws IOException {
        super.deexternalize(input);
        this.setCatalogName(ExternalizeUtil.deexternalizeString(input));
        this.setSchemaName(ExternalizeUtil.deexternalizeString(input));
        this.setCubeName(ExternalizeUtil.deexternalizeString(input));
        this.setDimensionUniqueName(ExternalizeUtil.deexternalizeString(input));
        this.setHierarchyUniqueName(ExternalizeUtil.deexternalizeString(input));
        int code = input.readInt();
        this.setType(VariableTypeEnum.valueOf(code));
        code = input.readInt();
        this.setSelectionType(VariableSelectionTypeEnum.valueOf(code));
        code = input.readInt();
        this.setPromptType(VariablePromptTypeEnum.valueOf(code));
        code = input.readInt();
        this.setEntryType(VariableEntryTypeEnum.valueOf(code));
        this.setDataType(ExternalizeUtil.deexternalizeDataType(input));
        this.setDefaultLow(ExternalizeUtil.deexternalizeValue(input));
        this.setDefaultHigh(ExternalizeUtil.deexternalizeValue(input));
        this.setLowCaption(ExternalizeUtil.deexternalizeString(input));
        this.setHighCaption(ExternalizeUtil.deexternalizeString(input));
        this.setIsFixedValue(input.readBoolean());
        this.setKeyDate(input.readBoolean());
    }

    public void copyTo(VariableRecord theCopy) {
        super.copyTo(theCopy);
        theCopy.setCatalogName(this.getCatalogName());
        theCopy.setSchemaName(this.getSchemaName());
        theCopy.setCubeName(this.getCubeName());
        theCopy.setDimensionUniqueName(this.getDimensionUniqueName());
        theCopy.setHierarchyUniqueName(this.getHierarchyUniqueName());
        theCopy.setType(this.getType());
        theCopy.setSelectionType(this.getSelectionType());
        theCopy.setEntryType(this.getEntryType());
        theCopy.setDataType(this.getDataType());
        theCopy.setDefaultLow(this.getDefaultLow());
        theCopy.setDefaultHigh(this.getDefaultHigh());
        theCopy.setLowCaption(this.getLowCaption());
        theCopy.setHighCaption(this.getHighCaption());
        theCopy.setIsFixedValue(this.isFixedValue());
        theCopy.setKeyDate(this.isKeyDate());
    }

    @Override
    public Object copy() {
        VariableRecord clonedRecord = new VariableRecord();
        this.copyTo(clonedRecord);
        return clonedRecord;
    }
}

