/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.shell;

import com.cognos.xqe.data.types.HierarchyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IMultiRequestHandle;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.shell.ShellLevel;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ShellHierarchy
implements IHierarchy {
    public static final String LEVEL = "Level";
    public static final int UNKNOWN_DEPTH = 1;
    private ReadWriteLock levelsLock = new ReentrantReadWriteLock(true);
    private String name;
    private int depth;
    private IDimension dimension;
    private ReadWriteLock lock;
    private OrderedMap<ILevel> levels = new OrderedMap();

    public ShellHierarchy(String hierarchyName, int hierarchyDepth, IDimension hierarchyDimension) {
        this.name = hierarchyName;
        this.depth = hierarchyDepth;
        this.dimension = hierarchyDimension;
        this.lock = new ReentrantReadWriteLock(true);
    }

    protected void throwNotImplemented() throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.MD_ShellMetadataInternalError, this.getClass().getName(), this.getName());
    }

    @Override
    public String createCalculatedMemberUniqueName(String suffix) {
        StringBuilder strBuf = new StringBuilder(this.getUniqueName());
        strBuf.append("[").append(suffix).append("]");
        return strBuf.toString();
    }

    @Override
    public int getCardinality() {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public IMember getDefaultMember() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public IDimension getDimension() {
        return this.dimension;
    }

    @Override
    public IMember getHighestLevelRollup() {
        this.throwNotImplemented();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILevel getLevel(int index) {
        ILevel level = null;
        StringBuilder nameBuff = new StringBuilder(LEVEL);
        nameBuff.append(XQEIntegerPool.getInteger(index).toString());
        String levelName = nameBuff.toString();
        this.lock.readLock().lock();
        try {
            level = this.levels.get(levelName);
            if (level != null) {
                ILevel iLevel = level;
                return iLevel;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            level = this.levels.get(levelName);
            if (level != null) {
                ILevel iLevel = level;
                return iLevel;
            }
            level = new ShellLevel(levelName, index, this);
            this.levels.add(level);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILevel getLevel(String levelName) {
        ILevel level = null;
        this.lock.readLock().lock();
        try {
            level = this.levels.get(levelName);
            if (level != null) {
                ILevel iLevel = level;
                return iLevel;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            level = this.levels.get(levelName);
            if (level != null) {
                ILevel iLevel = level;
                return iLevel;
            }
            level = new ShellLevel(levelName, this);
            this.levels.add(level);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return level;
    }

    @Override
    public int getLevelCount() {
        this.throwNotImplemented();
        return 0;
    }

    @Override
    public int getLevelIndex(ILevel level) {
        this.throwNotImplemented();
        return -1;
    }

    @Override
    public List<ILevel> getLevels() {
        this.levelsLock.readLock().lock();
        try {
            ArrayList<ILevel> arrayList = new ArrayList<ILevel>(this.levels.toArrayList());
            return arrayList;
        }
        finally {
            this.levelsLock.readLock().unlock();
        }
    }

    @Override
    public IMember[] getMembers() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public IMember getMember(String memberUniqueName) {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public List<String> getRelatedHierarchyNames(ILevel lowestLevel) {
        this.throwNotImplemented();
        return null;
    }

    public String getRootCaption() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public IMember getRootMember() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public String getUniqueName() {
        return this.getName();
    }

    @Override
    public boolean isMultiRoot() {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean isParentChild() {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean isRagged() {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public boolean isUnbalanced() {
        this.throwNotImplemented();
        return false;
    }

    @Override
    public String getCaption() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public List<IMetadata> getChildMetadataObjects() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public String getV5UniqueName() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public String getID() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public MetadataConnection getConnection() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public IDataType getDataType() {
        return HierarchyType.HIERARCHYTYPE;
    }

    @Override
    public String getDescription() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public String getScreenTip() {
        this.throwNotImplemented();
        return null;
    }

    public Object getImplementationObject() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public Set<String> getAvailableProperties() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public Object getProperty(String propertyName) {
        return null;
    }

    @Override
    public String getUniqueID() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public boolean hasChildMetadataObjects() {
        return false;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.HIERARCHY;
    }

    public void setCaption(String caption) {
        this.throwNotImplemented();
    }

    public void setDescription(String description) {
        this.throwNotImplemented();
    }

    public void setImplementationObject(Object obj) {
        this.throwNotImplemented();
    }

    public void setUniqueID(String uniqueID) {
        this.throwNotImplemented();
    }

    @Override
    public int compareTo(Object arg0) {
        if (arg0 instanceof ShellHierarchy) {
            return this.getName().compareTo(((ShellHierarchy)arg0).getName());
        }
        return -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getDepth() {
        return this.depth;
    }

    protected void setDepth(int hierarchyDepth) {
        this.depth = hierarchyDepth;
    }

    @Override
    public IMetadata getParentObject() {
        return this.getDimension();
    }

    public String toString() {
        StringBuilder toString = new StringBuilder(this.getParentObject().toString());
        toString.append(".").append("[").append(this.getName()).append("]");
        return toString.toString();
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isMFW() {
        return false;
    }

    @Override
    public IMember[] getMembers(InterpreterContext ic) {
        return null;
    }

    @Override
    public IMetadata getParentObjectSkipFolders() {
        return null;
    }

    @Override
    public List<IMember> getCalculatedMembers() {
        return null;
    }

    @Override
    public String getValidFrom() {
        return null;
    }

    @Override
    public String getValidTo() {
        return null;
    }

    @Override
    public boolean isAccessible() {
        return false;
    }

    @Override
    public void setParentMetadataObject(IMetadata parent) {
    }

    @Override
    public IMultiRequestHandle[] getHandles() {
        return null;
    }

    @Override
    public List<IMetadata> getDescendantMetadataObjectsSkipFolders() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isVisible(boolean inShortcut) {
        return false;
    }

    @Override
    public IMember getDefaultMemberFromProvider() {
        return null;
    }
}

