/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper.tabstreamwrapper;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DimensionType;
import com.cognos.xqe.data.types.HierarchyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelType;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.TabStreamWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToLevelWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractProcessor {
    public static final String DIM_PRE = "TBdimension_";
    public static final String HIER_PRE = "TBhierarchy_";
    public static final String PREFIX_LEVELNAME = "TBlevel_";
    public static final String PREFIX_PROPNAME = "TBproperty_";
    public static final String PREFIX_MEASURENAME = "TBmeasure_";
    public static final String ALL_ROWS = "allRows";
    public static final String COLUMN = "column";
    public static final String NONE = "none";
    protected TabStreamWrapper mParentWrapper = null;
    protected ArrayList<CubeDimension> mCubeDimensions = new ArrayList();
    protected ArrayList<CubeItem> mCubeMeasures = new ArrayList();
    protected Object mExprLocale = null;
    protected Object mModelPath = null;
    protected V5Source mOriginalV5Source = null;
    protected int mNextCubeItemId = 0;
    protected PlanningEnvironment mEnvironment = null;
    protected IXQENodeFactory mNodeFactory = null;

    public void process(PlanningEnvironment environment, IXQENodeFactory nodeFactory, V5QuerySet v5QuerySet, V5QueryResultDefinition v5QRD, V5Query v5Query) {
        this.mEnvironment = environment;
        this.mNodeFactory = nodeFactory;
        this.initializeProcess(v5QuerySet);
        this.processSource(v5Query);
        this.processQRD(v5QRD, v5Query);
        this.processSlicer(v5Query);
        this.processFilters(v5QRD, v5Query);
        this.finalizeProcess();
        this.mEnvironment = null;
        this.mNodeFactory = null;
    }

    protected abstract void initializeProcess(V5QuerySet var1);

    protected abstract void processSource(V5Query var1);

    protected abstract void processQRD(V5QueryResultDefinition var1, V5Query var2);

    protected abstract void processSlicer(V5Query var1);

    protected abstract void processFilters(V5QueryResultDefinition var1, V5Query var2);

    protected abstract void finalizeProcess();

    protected abstract V5QuerySet createV5QuerySet(PlanningEnvironment var1, List<IMetadata> var2, String var3, boolean var4);

    protected CubeDimension createCubeDimension(String name) {
        CubeDimension aCubeDim = new CubeDimension();
        aCubeDim.mName = name;
        this.mCubeDimensions.add(aCubeDim);
        return aCubeDim;
    }

    public ILevel getWrapperLevel(IDimension dimension) {
        CubeDimension aDim = this.getCubeDimension(dimension, false);
        if (aDim != null && aDim.mLevels.size() > 0) {
            return aDim.mLevels.get((int)(aDim.mLevels.size() - 1)).mDMRLevel;
        }
        return null;
    }

    protected CubeItem getCubeLevelKeyItem(ILevel level) {
        CubeLevel aCubeLevel = this.getHierarchyLevel(level, false);
        if (aCubeLevel != null) {
            return aCubeLevel.mKeyItems.get(0);
        }
        return null;
    }

    protected CubeLevel getCubeLevelByKeyExpr(IXQEQueryNode expr) {
        int[] types = new int[]{101003, 101004};
        for (CubeDimension aDim : this.mCubeDimensions) {
            for (CubeLevel aLevel : aDim.mLevels) {
                for (CubeItem aItem : aLevel.mKeyItems) {
                    if (!this.isSameExpression(expr, aItem.mTabExpr, types)) continue;
                    return aLevel;
                }
            }
        }
        return null;
    }

    protected boolean isSameExpression(IXQEQueryNode node1, IXQEQueryNode node2, int[] types) {
        if (node1 == node2) {
            return true;
        }
        if ((node1 = this.skipNodes(node1, types)) == (node2 = this.skipNodes(node2, types))) {
            return true;
        }
        if (this.isSameDefinition(node1, node2)) {
            boolean bRt = true;
            IXQEQueryNode[] children1 = node1.getChildren();
            IXQEQueryNode[] children2 = node2.getChildren();
            for (int idx = 0; bRt && idx < children1.length; ++idx) {
                bRt = this.isSameExpression(children1[idx], children2[idx], types);
            }
            return bRt;
        }
        return false;
    }

    protected boolean isSameDefinition(IXQEQueryNode node1, IXQEQueryNode node2) {
        if (node1.getType() != node2.getType() || node1.getNumberChildren() != node2.getNumberChildren() || !((XQEBaseQueryNode)node1).isSameSyntaxProperties(node2)) {
            return false;
        }
        boolean bRt = true;
        String s1 = null;
        String s2 = null;
        switch (node1.getType()) {
            case 201026: 
            case 201042: {
                bRt = node1.isSameExpression(node2, false);
                break;
            }
            case 201014: {
                s1 = ((V5ValueExpression)node1).getNodeSubTypeName();
                s2 = ((V5ValueExpression)node2).getNodeSubTypeName();
                bRt = s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
                break;
            }
            case 201013: {
                bRt = ((V5ComparisonExpression)node1).getOption() == ((V5ComparisonExpression)node2).getOption();
                break;
            }
            case 101003: {
                bRt = ((V5DataItem)node1).getNameProperty().equals(((V5DataItem)node2).getNameProperty()) || ((V5DataItem)node1).getAggregateProperty().equals(((V5DataItem)node2).getAggregateProperty()) && ((V5DataItem)node1).getRollupAggregateProperty().equals(((V5DataItem)node2).getRollupAggregateProperty());
                break;
            }
            case 201097: {
                bRt = ((V5BoundQueryItemReference)node1).getRefQueryItem() == ((V5BoundQueryItemReference)node2).getRefQueryItem();
                break;
            }
            case 201060: {
                bRt = ((V5BoundDataItemReference)node1).getRefDataItem() == ((V5BoundDataItemReference)node2).getRefDataItem();
                break;
            }
            case 201124: {
                bRt = ((V5AggregateFunction)node1).getPrefilter() == ((V5AggregateFunction)node2).getPrefilter() && ((V5AggregateFunction)node1).getDistinct() == ((V5AggregateFunction)node2).getDistinct();
                break;
            }
            case 201117: {
                s1 = ((V5BoundMemberUniqueName)node1).getExternalMemberUniqueName();
                s2 = ((V5BoundMemberUniqueName)node2).getExternalMemberUniqueName();
                bRt = s1 != null && s2 != null && s1.equals(s2);
                break;
            }
            case 201116: {
                s1 = ((V5BoundModelIdentifier)node1).getIdentifier();
                s2 = ((V5BoundModelIdentifier)node2).getIdentifier();
                bRt = s1 != null && s2 != null && s1.equals(s2);
                break;
            }
            default: {
                if (!node1.isOfCategory(201115)) break;
                s1 = ((V5BoundMultiPartIdentifier)node1).getIdentifier();
                s2 = ((V5BoundMultiPartIdentifier)node2).getIdentifier();
                bRt = s1 != null && s2 != null && s1.equals(s2);
            }
        }
        return bRt;
    }

    protected IXQEQueryNode skipNodes(IXQEQueryNode expr, int[] types) {
        IXQEQueryNode realExpr = expr;
        while (realExpr.isOfTypes(types) && realExpr.getNumberChildren() == 1) {
            realExpr = realExpr.getChild(0);
        }
        return realExpr;
    }

    protected CubeItem getCubeMeasure(String measureName) {
        for (CubeItem aCubeItem : this.mCubeMeasures) {
            if (!measureName.equals(aCubeItem.mDMRMeasure.getName())) continue;
            return aCubeItem;
        }
        return null;
    }

    protected CubeItem getCubeMeasureByExpr(IXQEQueryNode expr) {
        int[] types = new int[]{101004};
        for (CubeItem aMeasure : this.mCubeMeasures) {
            if (!this.isSameExpression(expr, aMeasure.mTabExpr, types)) continue;
            return aMeasure;
        }
        return null;
    }

    protected CubeLevel createCubeDimHierLevel(String name, V5DataItem tabExpr, IDataType dataType) {
        int lastDimIndex = this.mCubeDimensions.size();
        String levelName = PREFIX_LEVELNAME + lastDimIndex;
        if (name == null) {
            name = levelName;
        }
        CubeDimension cubeDim = this.createCubeDimension(DIM_PRE + lastDimIndex);
        cubeDim.mDMRDimension = new Dimension(DIM_PRE + lastDimIndex);
        cubeDim.mDMRDimension.setType(DimensionTypeEnum.REGULAR);
        cubeDim.mDMRDimension.setProperty("isManual", "true");
        cubeDim.mDMRDimension.setConnection(this.mParentWrapper.mCubeWrapper.getConnection());
        this.mParentWrapper.mCubeWrapper.addDimension(cubeDim.mDMRDimension);
        CubeHierarchy cubeHierarchy = cubeDim.createCubeHierarchy(HIER_PRE + lastDimIndex);
        cubeHierarchy.mDMRHierarchy = new Hierarchy(HIER_PRE + lastDimIndex);
        cubeHierarchy.mDMRHierarchy.setDimension(cubeDim.mDMRDimension);
        cubeHierarchy.mDMRHierarchy.setProperty("isManual", "true");
        cubeDim.mDMRDimension.addHierarchy(cubeHierarchy.mDMRHierarchy);
        cubeDim.mDMRDimension.setDefaultHierarchy(cubeHierarchy.mDMRHierarchy);
        Level level = (Level)cubeHierarchy.mDMRHierarchy.getLevel(0);
        level.setProperty("isManual", "true");
        Member allMember = new Member("all");
        allMember.setUniqueName(UniqueNameGenerator.appendUniqueName(cubeHierarchy.mDMRHierarchy.getUniqueName(), "all"));
        level.addMember(allMember, allMember);
        level.addChildMetadataObject(allMember);
        cubeHierarchy.mDMRHierarchy.setDefaultMember(allMember);
        CubeLevel cubeLevel = cubeDim.createCubeLevel(levelName);
        cubeHierarchy.mLevels.add(cubeLevel);
        cubeLevel.mDMRLevel = new V5DataItemToLevelWrapper(cubeDim.mDMRDimension, this.mParentWrapper.mCubeWrapper.getConnection(), levelName, name, dataType, Integer.toString(lastDimIndex));
        cubeHierarchy.mDMRHierarchy.addLevel(cubeLevel.mDMRLevel);
        CubeItem cubeItem = this.createCubeItem(name, tabExpr, tabExpr.getAggregateProperty(), tabExpr.getRollupAggregateProperty(), cubeLevel);
        cubeLevel.mDMRLevel.setBinaryExpression(cubeItem.mTabExpr);
        cubeLevel.mKeyItems.add(cubeItem);
        cubeLevel.setContextDependent(tabExpr);
        return cubeLevel;
    }

    protected CubeLevel createCubeDimHierLevel(V5DataItem item) {
        CubeLevel level = null;
        IDataType dataType = item.getDataType();
        if (dataType != null && dataType.getSubType() == DataSubType.METADATATYPE) {
            int[] types = new int[]{101003, 101004};
            IXQEQueryNode exp = this.skipNodes(item, types);
            if (exp.isOfCategory(201029)) {
                level = this.getOrCreateCubeLevelInContext((V5BoundToMetadata)exp, true);
            }
            if (level != null) {
                CubeItem cubeItem = this.createCubeItem(item.getNameProperty(), item, item.getAggregateProperty(), item.getRollupAggregateProperty(), level);
                level.mKeyItems.add(cubeItem);
                level.mDMRLevel.setBinaryExpression(cubeItem.mTabExpr);
            }
        }
        return level;
    }

    void addCustomProperty(V5DataItem property, CubeLevel level) {
        level.addCustomProperty(property);
    }

    IMetadata getParentMetadata(IMetadata md, IDataType type) {
        while (md != null && md.getDataType() != type) {
            if (md.getDataType() == LevelType.LEVELTYPE) {
                md = ((ILevel)md).getHierarchy();
                continue;
            }
            if (md.getDataType() == HierarchyType.HIERARCHYTYPE) {
                md = ((IHierarchy)md).getDimension();
                continue;
            }
            if (md.getDataType() == DimensionType.DIMENSIONTYPE) {
                md = ((IDimension)md).getCube();
                continue;
            }
            md = null;
        }
        return md;
    }

    protected CubeLevel getOrCreateCubeLevelInContext(V5BoundToMetadata expBM, boolean bCreate) {
        IMetadata md = expBM.getMetadata();
        ILevel levelOrg = (ILevel)this.getParentMetadata(md, LevelType.LEVELTYPE);
        CubeLevel level = null;
        if (levelOrg != null) {
            level = this.getHierarchyLevel(levelOrg, bCreate);
        }
        return level;
    }

    protected CubeDimension getCubeDimension(IDimension dim, boolean bCreate) {
        String name = dim.getName();
        for (CubeDimension current : this.mCubeDimensions) {
            if (!current.mName.equals(name)) continue;
            return current;
        }
        CubeDimension aCubeDim = null;
        if (bCreate) {
            aCubeDim = new CubeDimension();
            aCubeDim.mName = name;
            this.mCubeDimensions.add(aCubeDim);
            aCubeDim.mDMRDimension = new Dimension(name);
            aCubeDim.mDMRDimension.setType(DimensionTypeEnum.REGULAR);
            aCubeDim.mDMRDimension.setProperty("isManual", "true");
            aCubeDim.mDMRDimension.setConnection(this.mParentWrapper.mCubeWrapper.getConnection());
            this.mParentWrapper.mCubeWrapper.addDimension(aCubeDim.mDMRDimension);
        }
        return aCubeDim;
    }

    protected CubeHierarchy getDimensionHierarchy(IHierarchy hierarchy, boolean bCreate) {
        IDimension dimOrg = hierarchy.getDimension();
        CubeDimension dim = this.getCubeDimension(dimOrg, bCreate);
        if (dim == null) {
            return null;
        }
        String name = hierarchy.getName();
        for (CubeHierarchy current : dim.mHierarchies) {
            if (!current.mName.equals(name)) continue;
            return current;
        }
        CubeHierarchy aDimHierarchy = null;
        if (bCreate) {
            aDimHierarchy = new CubeHierarchy();
            aDimHierarchy.mName = name;
            aDimHierarchy.mParentDimension = dim;
            dim.mHierarchies.add(aDimHierarchy);
            aDimHierarchy.mDMRHierarchy = new Hierarchy(name);
            aDimHierarchy.mDMRHierarchy.setDimension(dim.mDMRDimension);
            aDimHierarchy.mDMRHierarchy.setProperty("isManual", "true");
            dim.mDMRDimension.addHierarchy(aDimHierarchy.mDMRHierarchy);
            dim.mDMRDimension.setDefaultHierarchy(aDimHierarchy.mDMRHierarchy);
            Level level = (Level)aDimHierarchy.mDMRHierarchy.getLevel(0);
            level.setProperty("isManual", "true");
            Member allMember = new Member("all");
            allMember.setUniqueName(UniqueNameGenerator.appendUniqueName(aDimHierarchy.mDMRHierarchy.getUniqueName(), "all"));
            level.addMember(allMember, allMember);
            level.addChildMetadataObject(allMember);
            aDimHierarchy.mDMRHierarchy.setDefaultMember(allMember);
        }
        return aDimHierarchy;
    }

    protected CubeLevel getHierarchyLevel(ILevel level, boolean bCreate) {
        IHierarchy hierarchyOrg = level.getHierarchy();
        CubeHierarchy hierarchy = this.getDimensionHierarchy(hierarchyOrg, bCreate);
        if (hierarchy == null) {
            return null;
        }
        String name = level.getName();
        for (CubeLevel current : hierarchy.mLevels) {
            if (!current.mName.equals(name)) continue;
            return current;
        }
        CubeLevel aHierarchyLevel = null;
        if (bCreate) {
            aHierarchyLevel = new CubeLevel();
            aHierarchyLevel.mName = name;
            aHierarchyLevel.mParentDimension = hierarchy.mParentDimension;
            hierarchy.mLevels.add(aHierarchyLevel);
            hierarchy.mParentDimension.mLevels.add(aHierarchyLevel);
            aHierarchyLevel.mDMRLevel = new V5DataItemToLevelWrapper(aHierarchyLevel.mParentDimension.mDMRDimension, this.mParentWrapper.mCubeWrapper.getConnection(), name, name, LevelType.LEVELTYPE, name);
            hierarchy.mDMRHierarchy.addLevel(aHierarchyLevel.mDMRLevel);
        }
        return aHierarchyLevel;
    }

    protected CubeItem createCubeItem(String name, IXQEQueryNode tabExpr, String aggr, String rollUp, CubeLevel cubeLevel) {
        CubeItem cubeItem = new CubeItem();
        cubeItem.mId = XQEIntegerPool.getInteger(this.mNextCubeItemId++);
        cubeItem.mParentLevel = cubeLevel;
        cubeItem.mName = name;
        if (tabExpr.getType() != 101003) {
            cubeItem.mTabExpr = this.mNodeFactory.createNode(101003);
            cubeItem.mTabExpr.addChild(this.mNodeFactory.deepCopyNode(tabExpr));
            ((V5DataItem)cubeItem.mTabExpr).setNameProperty(name);
        } else {
            cubeItem.mTabExpr = this.mNodeFactory.deepCopyNode(tabExpr);
        }
        cubeItem.mAggr = aggr;
        cubeItem.mRollUpAggr = rollUp;
        return cubeItem;
    }

    protected CubeItem createCubeMeasure(String name, IXQEQueryNode tabExpr, String aggr, String rollUp, IDataType dataType) {
        int lastMeasureIndex = this.mCubeMeasures.size();
        String measureName = PREFIX_MEASURENAME + lastMeasureIndex;
        if (name == null) {
            name = measureName;
        }
        CubeItem cubeItem = this.createCubeItem(name, tabExpr, aggr, rollUp, null);
        this.mCubeMeasures.add(cubeItem);
        if (aggr.equals(NONE)) {
            cubeItem.mAggr = "calculated";
            if (cubeItem.mTabExpr.getType() == 101003) {
                ((V5DataItem)cubeItem.mTabExpr).setAggregateProperty("calculated");
            }
        }
        if (rollUp.equals(NONE)) {
            cubeItem.mRollUpAggr = "calculated";
            if (cubeItem.mTabExpr.getType() == 101003) {
                ((V5DataItem)cubeItem.mTabExpr).setRollupAggregateProperty("calculated");
            }
        }
        Dimension measuresDim = this.mParentWrapper.mCubeWrapper.createAndReturnMeasuresDimension();
        cubeItem.mDMRMeasure = new V5DataItemToMeasureWrapper(this, measuresDim, this.mParentWrapper.mCubeWrapper.getConnection(), measureName, name, dataType, rollUp);
        cubeItem.mDMRMeasure.setBinaryExpression(cubeItem.mTabExpr);
        cubeItem.mDMRMeasure.setParentMetadataObject(measuresDim);
        Hierarchy measuresHier = (Hierarchy)measuresDim.getDefaultHierarchy();
        Level measuresLevel = (Level)measuresHier.getLevels().get(0);
        measuresLevel.addMember(cubeItem.mDMRMeasure, null);
        measuresHier.setDefaultMember(cubeItem.mDMRMeasure);
        measuresDim.addChildMetadataObject(cubeItem.mDMRMeasure);
        return cubeItem;
    }

    protected void replaceV5DataItemExprWithLevelWrapper(IXQEQueryNode oldNode, CubeLevel cubeLevel) {
        V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)this.mNodeFactory.createNode(201116);
        newNode.setIdentifier(cubeLevel.mDMRLevel.getV5UniqueName());
        newNode.setMetadata(cubeLevel.mDMRLevel);
        IXQEQueryNode v5MembersNode = this.mNodeFactory.createNode(201086);
        newNode.insertParent(v5MembersNode);
        oldNode.exchange(v5MembersNode);
    }

    protected void replaceV5DataItemExprWithMeasureWrapper(IXQEQueryNode oldNode, CubeItem measureItem) {
        V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)this.mNodeFactory.createNode(201116);
        newNode.setIdentifier(measureItem.mDMRMeasure.getV5UniqueName());
        newNode.setMetadata(measureItem.mDMRMeasure);
        oldNode.exchange(newNode);
    }

    protected IXQEQueryNode createV5GroupBody(XQENodeFactory nodeFactory, V5QuerySet querySet, String queryName) {
        IXQEQueryNode qrd = nodeFactory.createNode(101055);
        querySet.addChild(qrd);
        qrd.setPropertyValue("name", queryName);
        qrd.setPropertyValue("refQuery", queryName);
        qrd.setPropertyValue("transferMembers", true);
        IXQEQueryNode edge = nodeFactory.createNode(101049);
        edge.setPropertyValue("name", queryName);
        qrd.addChild(edge);
        IXQEQueryNode edgeGroup = nodeFactory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)nodeFactory.createNode(101057);
        valueSet.setNameProperty(queryName);
        edgeGroup.addChild(valueSet);
        IXQEQueryNode groupBody = nodeFactory.createNode(101051);
        groupBody.setPropertyValue("name", queryName);
        valueSet.addChild(groupBody);
        return groupBody;
    }

    protected class CubeItem {
        protected Integer mId = null;
        protected CubeLevel mParentLevel = null;
        protected String mName;
        protected IXQEQueryNode mTabExpr;
        protected String mAggr;
        protected String mRollUpAggr;
        protected V5DataItemToMeasureWrapper mDMRMeasure = null;

        protected CubeItem() {
        }
    }

    protected class CubeLevel {
        protected CubeDimension mParentDimension;
        protected ArrayList<CubeHierarchy> mUsedInHierarchies = new ArrayList();
        protected String mName;
        protected ArrayList<CubeItem> mKeyItems = new ArrayList();
        V5DataItemToLevelWrapper mDMRLevel;
        private ArrayList<V5DataItem> mCustomProperties;
        private boolean mContextDependent = false;

        protected CubeLevel() {
        }

        public boolean isContextDependent() {
            return this.mContextDependent;
        }

        protected void setContextDependent(IXQEQueryNode expr) {
            this.mContextDependent = expr.getDescendantsOfType(201037, false).length != 0;
        }

        void addCustomProperty(V5DataItem property) {
            if (this.mCustomProperties == null) {
                this.mCustomProperties = new ArrayList();
            }
            this.mCustomProperties.add(property);
        }

        V5DataItem getCustomProperty(int idx) {
            if (this.mCustomProperties == null || idx >= this.mCustomProperties.size()) {
                return null;
            }
            return this.mCustomProperties.get(idx);
        }

        void mergeKeyItems() {
            if (this.mKeyItems.size() > 1) {
                IXQEQueryNode union = AbstractProcessor.this.mNodeFactory.createNode(201111);
                for (CubeItem item : this.mKeyItems) {
                    IXQEQueryNode exp = item.mTabExpr.getChild(0);
                    if (exp.getType() != 201117) continue;
                    IXQEQueryNode set = AbstractProcessor.this.mNodeFactory.createNode(201101);
                    set.addChild(exp);
                    union.addChild(set);
                }
                if (union.getNumberChildren() > 1) {
                    CubeItem cubeItem = AbstractProcessor.this.createCubeItem(this.mKeyItems.get((int)0).mName, union, null, null, this.mKeyItems.get((int)0).mParentLevel);
                    this.mKeyItems.add(0, cubeItem);
                }
            }
        }
    }

    protected class CubeHierarchy {
        protected CubeDimension mParentDimension;
        protected ArrayList<CubeLevel> mLevels = new ArrayList();
        protected String mName;
        protected Hierarchy mDMRHierarchy;

        protected CubeHierarchy() {
        }
    }

    protected class CubeDimension {
        protected ArrayList<CubeHierarchy> mHierarchies = new ArrayList();
        protected ArrayList<CubeLevel> mLevels = new ArrayList();
        protected String mName;
        protected Dimension mDMRDimension = null;

        protected CubeDimension() {
        }

        protected CubeLevel createCubeLevel(String levelName) {
            CubeLevel cubeLevel = new CubeLevel();
            cubeLevel.mName = levelName;
            cubeLevel.mParentDimension = this;
            this.mLevels.add(cubeLevel);
            return cubeLevel;
        }

        protected CubeHierarchy createCubeHierarchy(String hierarchyName) {
            CubeHierarchy cubeHierarchy = new CubeHierarchy();
            cubeHierarchy.mName = hierarchyName;
            this.mHierarchies.add(cubeHierarchy);
            return cubeHierarchy;
        }
    }
}

