/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metadata.wrapper.tabstreamwrapper;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5SummaryFilter;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5Edge;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.AbstractV5Set;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueAnalyticFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DimensionType;
import com.cognos.xqe.data.types.HierarchyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItemOfLevel;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.AbstractProcessor;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.TabStreamWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.transformation.decomposition.DecomposeScalarFunction;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5exptomdxexp.binding.ReplaceBoundMultiPartIdentifier;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ScalarFunctionProcessor
extends AbstractProcessor {
    static final String SUBQUERY_NAME = "SubQueryOLAP";
    static final String PROP_MEASURE_FILTER = "MeasureFilter";
    HashMap<String, V5DataItem> mapDataItemName2DataItem = new HashMap();
    HashMap<IXQEQueryNode, IXQEQueryNode> mapOldToNewExpressions = new HashMap();
    ArrayList<String> processedDataItems = new ArrayList();
    ArrayList<IXQEQueryNode> filtersForSubquery;
    ArrayList<IXQEQueryNode> filtersOnMeasure = null;
    ArrayList<V5DetailFilter> filtersRelational;
    ArrayList<IXQEQueryNode> slicers;
    boolean externalAggregatesChecked = false;
    boolean valueDetailFilterFound = false;
    boolean memberDetailFilterFound = false;
    Set<IHierarchy> projectedHierarchies = new HashSet<IHierarchy>();

    protected ScalarFunctionProcessor(TabStreamWrapper tabWrapper) {
        this.mParentWrapper = tabWrapper;
    }

    boolean isSummary(V5DataItem dataItem) {
        return dataItem.getChild(0).getType() == 201032;
    }

    boolean isCalculatedMember(V5DataItem dataItem) {
        return dataItem.getChild(0).getType() == 201085;
    }

    protected void rebindToCubeDataItem(V5DataItem v5DataItem) {
        V5DataItem dataItemSelection = this.mapDataItemName2DataItem.get(v5DataItem.getNameProperty());
        v5DataItem.setAggregateProperty(dataItemSelection.getAggregateProperty());
        v5DataItem.setRollupAggregateProperty(dataItemSelection.getRollupAggregateProperty());
        if (v5DataItem.getParent().getType() == 201039) {
            IXQEQueryNode nodeNew = this.mNodeFactory.deepCopyNode(dataItemSelection.getChild(0));
            v5DataItem.getChild(0).detach();
            v5DataItem.addChild(nodeNew);
        } else {
            int[] types = new int[]{201117, 201116};
            IXQEQueryNode[] md = dataItemSelection.getDescendantsOfTypes(types, false);
            IXQEQueryNode[] mdDetail = v5DataItem.getDescendantsOfTypes(types, false);
            IXQEQueryNode nodeNew = this.mNodeFactory.deepCopyNode(md[0]);
            mdDetail[0].exchange(nodeNew);
        }
    }

    protected boolean rebindToCubeHierarchy(V5BoundModelIdentifier obj) {
        IHierarchy hierarchy = obj.getHierarchy();
        AbstractProcessor.CubeHierarchy cubeHierarchy = this.getDimensionHierarchy(hierarchy, false);
        if (cubeHierarchy != null) {
            this.rebindCubeHierarchy(obj, cubeHierarchy.mDMRHierarchy);
        }
        return cubeHierarchy != null;
    }

    private void rebindCubeHierarchy(V5BoundModelIdentifier expHierarchy, IHierarchy cubeHierarchy) {
        V5BoundModelIdentifier newObj = (V5BoundModelIdentifier)this.mNodeFactory.deepCopyNode(expHierarchy);
        newObj.setMetadata(cubeHierarchy);
        expHierarchy.exchange(newObj);
    }

    protected IHierarchy resolveHierarchyFromExpression(IXQEQueryNode exp) {
        IXQEQueryNode withinClause;
        if (exp.getType() == 201085 && exp.getChild(0).getType() == 201032 && exp.getChild(0).getNumberChildren() > 1 && (withinClause = exp.getChild(0).getChild(1)).getType() == 201039) {
            V5BoundModelIdentifier node = (V5BoundModelIdentifier)withinClause.getFirstDescendantOfTypeOrdered(201116, false);
            return node.getHierarchy();
        }
        return null;
    }

    protected AbstractProcessor.CubeLevel createCubeDimHierLevelForProperty(V5DataItem v5DataItem) {
        V5BoundToMetadata exp;
        IMetadata md;
        AbstractProcessor.CubeLevel cubeLevel = null;
        IDataType dataType = v5DataItem.getDataType();
        if (dataType != null && dataType.getSubType() != DataSubType.METADATATYPE && v5DataItem.getChild(0).isOfCategory(201029) && (md = (exp = (V5BoundToMetadata)v5DataItem.getChild(0)).getMetadata()) instanceof IQueryItemOfLevel) {
            IQueryItemOfLevel mdLevel = (IQueryItemOfLevel)md;
            cubeLevel = this.getHierarchyLevel(mdLevel.getLevel(), false);
            if (cubeLevel == null) {
                String v5 = mdLevel.getLevel().getV5UniqueName();
                V5DataItem newV5DataItem = (V5DataItem)this.mNodeFactory.deepCopyNode(v5DataItem);
                exp = (V5BoundToMetadata)newV5DataItem.getChild(0);
                exp.setMetadata(mdLevel.getLevel());
                exp.setIdentifier(v5);
                newV5DataItem.setNameProperty(newV5DataItem.getNameProperty() + "_LoadLevel");
                cubeLevel = this.createCubeDimHierLevel(newV5DataItem);
                if (cubeLevel == null) {
                    cubeLevel = this.createCubeDimHierLevel(v5DataItem.getNameProperty(), newV5DataItem, mdLevel.getLevel().getDataType());
                }
            }
            if (cubeLevel != null) {
                this.addCustomProperty((V5DataItem)this.mNodeFactory.deepCopyNode(v5DataItem), cubeLevel);
            }
        }
        return cubeLevel;
    }

    protected boolean processDataItem(V5DataItem v5DataItem, String sort) {
        if (this.processedDataItems.contains(v5DataItem.getNameProperty())) {
            return false;
        }
        if (this.isSummary(v5DataItem) || this.isCalculatedMember(v5DataItem)) {
            this.processExpression(v5DataItem, v5DataItem.getChild(0), false, false, false, false);
        } else if (v5DataItem.getRollupAggregateProperty().equals("none")) {
            AbstractProcessor.CubeLevel cubeLevel = this.getCubeLevelByKeyExpr(v5DataItem);
            if (cubeLevel == null) {
                if (sort != null) {
                    v5DataItem.setPropertyValue("sort", sort);
                }
                if ((cubeLevel = this.createCubeDimHierLevelForProperty(v5DataItem)) == null && (cubeLevel = this.createCubeDimHierLevel(v5DataItem)) == null) {
                    cubeLevel = this.createCubeDimHierLevel(v5DataItem.getNameProperty(), v5DataItem, v5DataItem.getDataType());
                }
            }
            if (v5DataItem.getChild(0).getType() == 201117) {
                V5BoundMemberUniqueName exp = (V5BoundMemberUniqueName)v5DataItem.getChild(0);
                IXQEQueryNode set = this.mNodeFactory.createNode(201101);
                set.addChild(this.createMemberOverLocalLevel(exp));
                exp.exchange(set);
            } else {
                this.replaceV5DataItemExprWithLevelWrapper(v5DataItem.getChild(0), cubeLevel);
            }
        } else {
            AbstractProcessor.CubeItem cubeMeasure = this.getCubeMeasureByExpr(v5DataItem);
            if (cubeMeasure == null) {
                cubeMeasure = this.createCubeMeasure(v5DataItem.getNameProperty(), v5DataItem, v5DataItem.getAggregateProperty(), v5DataItem.getRollupAggregateProperty(), v5DataItem.getDataType());
            }
            this.replaceV5DataItemExprWithMeasureWrapper(v5DataItem.getChild(0), cubeMeasure);
        }
        this.processedDataItems.add(v5DataItem.getNameProperty());
        return true;
    }

    V5BoundMemberUniqueName createMemberOverLocalLevel(V5BoundMemberUniqueName exp) {
        AbstractProcessor.CubeLevel cubeLevel = this.getOrCreateCubeLevelInContext(exp, false);
        V5BoundMemberUniqueName node1 = null;
        if (cubeLevel != null) {
            node1 = (V5BoundMemberUniqueName)this.mNodeFactory.deepCopyNode(exp);
            node1.setIdentifier(cubeLevel.mDMRLevel.getV5UniqueName());
            node1.setMetadata(cubeLevel.mDMRLevel);
            try {
                String[] parentNameParts = UniqueNameParser.parse(node1.getIdentifier());
                String[] newNameParts = new String[parentNameParts.length + 1];
                System.arraycopy(parentNameParts, 0, newNameParts, 0, parentNameParts.length);
                String originalName = node1.getExternalMemberUniqueName();
                originalName = UniqueNameParser.undoEscapedSquareBracket(originalName);
                newNameParts[newNameParts.length - 1] = UniqueNameParser.escapeSquareBrackets(originalName);
                node1.setExternalMemberUniqueName(UniqueNameGenerator.createUniqueName(newNameParts));
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(e);
            }
        } else {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "MUN without its level " + exp.getExternalMemberUniqueName());
        }
        return node1;
    }

    protected void processValueSet(V5ValueSet valueSet) {
        IXQEQueryNode expr;
        V5DataItem dataItem = this.mapDataItemName2DataItem.get(valueSet.getRefDataItemProperty());
        String sort = null;
        V5SortItem sortItem = (V5SortItem)valueSet.getFirstChildByType(101056);
        if (sortItem != null) {
            sort = sortItem.getSortOrder();
        }
        if ((expr = dataItem.getChild(0)).isOfCategory(201120)) {
            MDXHierInfo hierInfo = ((V5SimpleNode)expr).getHierarchyInfo();
            this.projectedHierarchies.addAll(hierInfo.getProjectedHierarchies());
        }
        this.processDataItem(dataItem, sort);
        V5GroupBody groupBody = (V5GroupBody)valueSet.getFirstChildByType(101051);
        if (groupBody != null) {
            IXQEQueryNode[] refDataItems;
            for (IXQEQueryNode current : refDataItems = groupBody.getChildrenOfType(101015)) {
                V5DataItemRef refDI = (V5DataItemRef)current;
                V5DataItem di = this.mapDataItemName2DataItem.get(refDI.getDataItemRefProperty());
                this.processDataItem(di, sort);
            }
        }
        if (sortItem != null) {
            V5DataItem di = this.mapDataItemName2DataItem.get(sortItem.getRefDataItem());
            this.processDataItem(di, null);
        }
    }

    protected void processEdgeGroup(V5EdgeGroup edgeGroup) {
        IXQEQueryNode[] edgeGroups;
        IXQEQueryNode[] valueSets;
        for (IXQEQueryNode valueSet : valueSets = edgeGroup.getChildrenOfTypeOrdered(101057)) {
            this.processValueSet((V5ValueSet)valueSet);
        }
        for (IXQEQueryNode nestedGroup : edgeGroups = edgeGroup.getChildrenOfTypeOrdered(101050)) {
            this.processEdgeGroup((V5EdgeGroup)nestedGroup);
        }
    }

    protected void processEdge(V5Edge edge) {
        IXQEQueryNode[] edgeGroups;
        for (IXQEQueryNode edgeGroup : edgeGroups = edge.getChildrenOfType(101050)) {
            this.processEdgeGroup((V5EdgeGroup)edgeGroup);
        }
    }

    @Override
    protected void processQRD(V5QueryResultDefinition v5QRD, V5Query v5Query) {
        IXQEQueryNode[] edges;
        IXQEQueryNode[] dis;
        v5Query = v5QRD.getV5Query();
        for (IXQEQueryNode di : dis = v5Query.getV5Selection().getChildrenOfType(101003)) {
            IXQEQueryNode current = (V5DataItem)di;
            this.mapDataItemName2DataItem.put(((V5DataItem)current).getNameProperty(), (V5DataItem)current);
        }
        IXQEQueryNode[] allV5CubeCalculatedDefaultMembers = v5Query.getChildrenOfType(101077);
        if (allV5CubeCalculatedDefaultMembers.length != 0) {
            for (IXQEQueryNode current : allV5CubeCalculatedDefaultMembers) {
                current.detach();
            }
        }
        for (IXQEQueryNode edge : edges = v5QRD.getChildrenOfType(101049)) {
            this.processEdge((V5Edge)edge);
        }
    }

    V5QuerySet buildEmptyQuerySet(XQENodeFactory nodeFactory, String queryName) {
        V5QuerySet querySet = (V5QuerySet)nodeFactory.createNode(101002);
        querySet.addToIndex();
        V5Query query = (V5Query)nodeFactory.createNode(101006);
        querySet.addChild(query);
        query.setPropertyValue("name", queryName);
        query.addChild(nodeFactory.createNode(101007));
        query.addChild(nodeFactory.createNode(101009));
        this.createV5GroupBody(nodeFactory, querySet, queryName);
        return querySet;
    }

    @Override
    protected V5QuerySet createV5QuerySet(PlanningEnvironment planningEnv, List<IMetadata> projectedColumns, String queryName, boolean isV5QueryToLoadmembers) {
        IXQEQueryNode[] v5ValueSets;
        IXQEQueryNode[] v5QuerySets;
        queryName = queryName.concat("MultiDimensionalSubquery");
        XQENodeFactory nodeFactory = planningEnv.getNodeFactory();
        V5QuerySet querySet = this.buildEmptyQuerySet(nodeFactory, queryName);
        if (this.mExprLocale != null) {
            querySet.setPropertyValue("expressionLocale", this.mExprLocale);
        }
        if (this.mModelPath != null) {
            querySet.setPropertyValue("modelPath", this.mModelPath);
            ((RequestEnvironment)planningEnv.getRequestEnvironment()).setModelPath((String)this.mModelPath);
        }
        V5Query query = querySet.getV5Query(queryName);
        if (isV5QueryToLoadmembers) {
            query.getV5Selection().setPropertyValue("autoSummary", false);
        }
        this.createV5DataItems(nodeFactory, querySet, projectedColumns, isV5QueryToLoadmembers);
        boolean bLowestScope = this.onlyLowestLevelsRequested(projectedColumns);
        if (!isV5QueryToLoadmembers && this.filtersOnMeasure != null && !bLowestScope) {
            this.fixMeasureScope(nodeFactory, querySet, projectedColumns);
        }
        if (!isV5QueryToLoadmembers && bLowestScope) {
            query.getV5Selection().setPropertyValue("EnforceAutosummary", true);
        }
        if (!isV5QueryToLoadmembers) {
            this.createSubquerySlicers(nodeFactory, query);
        }
        this.createSubqueryFilters(nodeFactory, query, isV5QueryToLoadmembers, bLowestScope);
        for (IXQEQueryNode aQuerySet : v5QuerySets = querySet.getDescendantsOfType(101002, true)) {
            ((V5QuerySet)aQuerySet).setUnreferencedQRDsRemoved();
        }
        for (IXQEQueryNode aValueSet : v5ValueSets = querySet.getDescendantsOfType(101057, false)) {
            ((V5ValueSet)aValueSet).setIsReportDetail(Boolean.TRUE);
        }
        return querySet;
    }

    boolean onlyLowestLevelsRequested(List<IMetadata> projectedColumns) {
        for (AbstractProcessor.CubeDimension dim : this.mCubeDimensions) {
            if (dim.mLevels.size() <= 0) continue;
            AbstractProcessor.CubeLevel level = dim.mLevels.get(dim.mLevels.size() - 1);
            if (projectedColumns.contains(level.mDMRLevel)) continue;
            for (AbstractProcessor.CubeLevel l2 : dim.mLevels) {
                if (!projectedColumns.contains(l2.mDMRLevel)) continue;
                return false;
            }
        }
        return true;
    }

    ArrayList<IMetadata> getMissingLowesLevels(List<IMetadata> projectedColumns) {
        ArrayList<IMetadata> list = new ArrayList<IMetadata>();
        for (AbstractProcessor.CubeDimension dim : this.mCubeDimensions) {
            AbstractProcessor.CubeLevel level = dim.mLevels.get(dim.mLevels.size() - 1);
            if (projectedColumns.contains(level.mDMRLevel)) continue;
            list.add(level.mDMRLevel);
        }
        return list;
    }

    ArrayList<AbstractProcessor.CubeLevel> getLowestLevels() {
        ArrayList<AbstractProcessor.CubeLevel> list = new ArrayList<AbstractProcessor.CubeLevel>();
        for (AbstractProcessor.CubeDimension dim : this.mCubeDimensions) {
            list.add(dim.mLevels.get(dim.mLevels.size() - 1));
        }
        return list;
    }

    void addForClauseWithScope(XQENodeFactory nodeFactory, V5BoundModelIdentifier bmpi, ArrayList<V5DataItem> scopeRef) {
        V5ValueSummaryFunction aggNode;
        V5AggregateBreakClause clauseFor;
        if (bmpi.getParent().isOfCategory(201124) && (clauseFor = (aggNode = (V5ValueSummaryFunction)bmpi.getParent()).getForClause()) == null) {
            clauseFor = (V5AggregateBreakClause)nodeFactory.createNode(201037);
            aggNode.addChild(clauseFor);
            for (V5DataItem md : scopeRef) {
                String newName = UniqueNameGenerator.createUniqueName(md.getNameProperty());
                V5BoundDataItemReference scopeDI = (V5BoundDataItemReference)nodeFactory.createNode(201060);
                scopeDI.setIdentifier(newName);
                scopeDI.setRefDataItem(md);
                clauseFor.addChild(scopeDI);
            }
        }
    }

    void fixMeasureScope(XQENodeFactory nodeFactory, V5QuerySet querySet, List<IMetadata> projectedColumns) {
        IXQEQueryNode[] bmpis;
        IXQEQueryNode[] qrdItems;
        IXQEQueryNode[] di;
        ArrayList<IMetadata> scopeLowestMissing = this.getMissingLowesLevels(projectedColumns);
        if (scopeLowestMissing.size() == 0) {
            return;
        }
        DMRMeasure measure = null;
        ArrayList<IMetadata> scopeQuery = new ArrayList<IMetadata>();
        for (IMetadata md : projectedColumns) {
            if (md instanceof DMRMeasure) {
                measure = (DMRMeasure)md;
                continue;
            }
            scopeQuery.add(md);
        }
        AbstractProcessor.CubeItem ci = this.getCubeItem(measure);
        V5Query query = (V5Query)querySet.getFirstChildByType(101006);
        ArrayList<V5DataItem> scopeRef = new ArrayList<V5DataItem>();
        V5DataItem measureDataItem = null;
        for (IXQEQueryNode current : di = query.getV5Selection().getChildrenOfType(101003)) {
            if (ci.mTabExpr.isSameExpression(current, false)) {
                measureDataItem = (V5DataItem)current;
                continue;
            }
            scopeRef.add((V5DataItem)current);
        }
        String name = measureDataItem.getNameProperty();
        measureDataItem.setNameProperty(name + "_QueryScope");
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)querySet.getFirstChildByType(101055);
        IXQEQueryNode nodeGB = qrd.getFirstDescendantOfTypeOrdered(101051, false);
        for (IXQEQueryNode qrdDataItemRef : qrdItems = nodeGB.getDescendantsOfType(101015, false)) {
            V5DataItemRef item = (V5DataItemRef)qrdDataItemRef;
            if (!item.getDataItemRefProperty().equals(name)) continue;
            item.setStringPropertyValue("refDataItem", measureDataItem.getNameProperty());
        }
        for (IXQEQueryNode currentBMI : bmpis = measureDataItem.getDescendantsOfType(201116, false)) {
            this.addForClauseWithScope(nodeFactory, (V5BoundModelIdentifier)currentBMI, scopeRef);
            V5ValueAnalyticFunction af = (V5ValueAnalyticFunction)currentBMI.getAncestorOfType(201033);
            if (af == null || af.getSubType() != 14) continue;
            af.setDistinct(true);
        }
    }

    boolean isRelatedFilter(V5Query query, IXQEQueryNode filter) {
        IXQEQueryNode[] bmpiF = filter.getDescendantsOfType(201116, false);
        IXQEQueryNode[] bmpiQ = query.getDescendantsOfType(201116, false);
        for (IXQEQueryNode f : bmpiF) {
            V5BoundModelIdentifier cf = (V5BoundModelIdentifier)f;
            for (IXQEQueryNode q : bmpiQ) {
                V5BoundModelIdentifier cq = (V5BoundModelIdentifier)q;
                if (!cf.getMetadata().equals(cq.getMetadata())) continue;
                return true;
            }
        }
        return false;
    }

    void createSubqueryFilters(XQENodeFactory nodeFactory, V5Query query, boolean loadMembers, boolean bLowestScope) {
        IXQEQueryNode groupBody = null;
        V5Selection selection = query.getV5Selection();
        ArrayList<V5DataItem> scopeLowest = null;
        if (this.filtersForSubquery != null) {
            for (IXQEQueryNode filter : this.filtersForSubquery) {
                boolean bMeasureFilter;
                IXQEQueryNode newFilter = nodeFactory.deepCopyNode(filter);
                if (loadMembers && !this.isRelatedFilter(query, newFilter)) continue;
                query.addChild(newFilter);
                boolean bl = bMeasureFilter = this.filtersOnMeasure != null && this.filtersOnMeasure.contains(filter);
                if (!loadMembers && !bLowestScope && scopeLowest == null) {
                    ArrayList<AbstractProcessor.CubeLevel> scope = this.getLowestLevels();
                    scopeLowest = new ArrayList<V5DataItem>();
                    for (AbstractProcessor.CubeLevel level : scope) {
                        AbstractProcessor.CubeItem cubeItem = level.mKeyItems.get(0);
                        V5DataItem di = (V5DataItem)cubeItem.mTabExpr;
                        V5DataItem diSelection = selection.getDataItemByRefName(di.getNameProperty());
                        if (diSelection == null) {
                            diSelection = (V5DataItem)nodeFactory.deepCopyNode(cubeItem.mTabExpr);
                            diSelection.setPropertyValue("isProjected", null);
                            this.addV5DataItem(nodeFactory, selection, null, diSelection, cubeItem.mAggr, cubeItem.mRollUpAggr);
                        }
                        scopeLowest.add(diSelection);
                    }
                }
                if (!bLowestScope && bMeasureFilter) {
                    IXQEQueryNode[] bmpis = newFilter.getDescendantsOfType(201116, false);
                    for (IXQEQueryNode currentBMPI : bmpis) {
                        this.addForClauseWithScope(nodeFactory, (V5BoundModelIdentifier)currentBMPI, scopeLowest);
                    }
                }
                IXQEQueryNode[] dis = newFilter.getDescendantsOfType(101003, false);
                for (IXQEQueryNode current : dis) {
                    IXQEQueryNode[] bmpis;
                    AbstractProcessor.CubeItem cubeItem;
                    V5DataItem di = (V5DataItem)current;
                    V5DataItem diSelection = selection.getDataItemByRefName(di.getNameProperty());
                    if (diSelection == null && (cubeItem = this.getCubeItem(di.getNameProperty())) != null) {
                        diSelection = (V5DataItem)nodeFactory.deepCopyNode(cubeItem.mTabExpr);
                        diSelection.setPropertyValue("isProjected", null);
                        if (groupBody == null) {
                            V5QuerySet querySet = (V5QuerySet)query.getAncestorOfType(101002);
                            groupBody = querySet.getFirstDescendantOfTypeOrdered(101051, false);
                        }
                        this.addV5DataItem(nodeFactory, selection, null, diSelection, cubeItem.mAggr, cubeItem.mRollUpAggr);
                    }
                    if (diSelection == null) continue;
                    V5BoundDataItemReference refNode = (V5BoundDataItemReference)nodeFactory.createNode(201060);
                    refNode.setIdentifier(UniqueNameGenerator.createSingleNamePart(diSelection.getNameProperty()));
                    refNode.setRefDataItem(diSelection);
                    di.exchange(refNode);
                    if (bLowestScope || !bMeasureFilter) continue;
                    for (IXQEQueryNode currentBMPI : bmpis = diSelection.getDescendantsOfType(201116, false)) {
                        this.addForClauseWithScope(nodeFactory, (V5BoundModelIdentifier)currentBMPI, scopeLowest);
                    }
                }
            }
        }
    }

    void createSubquerySlicers(XQENodeFactory nodeFactory, V5Query query) {
        if (this.slicers != null) {
            for (IXQEQueryNode slicer : this.slicers) {
                IXQEQueryNode newSlicer = nodeFactory.deepCopyNode(slicer);
                query.addChild(newSlicer);
                IXQEQueryNode[] dis = newSlicer.getDescendantsOfType(101003, false);
                V5Selection selection = query.getV5Selection();
                for (IXQEQueryNode current : dis) {
                    V5DataItem di = (V5DataItem)current;
                    V5DataItem diSelection = selection.getDataItemByRefName(di.getNameProperty());
                    if (diSelection != null) {
                        V5BoundDataItemReference refNode = (V5BoundDataItemReference)nodeFactory.createNode(201060);
                        refNode.setIdentifier(diSelection.getNameProperty());
                        refNode.setRefDataItem(diSelection);
                        di.exchange(refNode);
                        continue;
                    }
                    di.extract();
                }
            }
        }
    }

    void addSubqueryFilter(IXQEQueryNode filter) {
        IXQEQueryNode[] bmpis;
        if (this.filtersForSubquery == null) {
            this.filtersForSubquery = new ArrayList();
        }
        this.filtersForSubquery.add(filter);
        for (IXQEQueryNode current : bmpis = filter.getDescendantsOfType(201116, false)) {
            V5BoundMultiPartIdentifier bmpi = (V5BoundMultiPartIdentifier)current;
            if (!bmpi.isMeasure()) continue;
            if (this.filtersOnMeasure == null) {
                this.filtersOnMeasure = new ArrayList();
            }
            this.filtersOnMeasure.add(filter);
            break;
        }
    }

    void addSlicer(IXQEQueryNode slicer) {
        if (this.slicers == null) {
            this.slicers = new ArrayList();
        }
        this.slicers.add(slicer);
    }

    void createV5DataItems(XQENodeFactory nodeFactory, V5QuerySet querySet, List<IMetadata> projectedColumns, boolean isV5QueryToLoadmembers) {
        V5Query query = (V5Query)querySet.getChild(0);
        V5Selection selection = query.getV5Selection();
        IXQEQueryNode groupBody = querySet.getFirstDescendantOfTypeOrdered(101051, false);
        for (IMetadata metadata : projectedColumns) {
            AbstractProcessor.CubeItem cubeItem = this.getCubeItem(metadata);
            this.addV5DataItem(nodeFactory, selection, groupBody, cubeItem, isV5QueryToLoadmembers);
            if (!isV5QueryToLoadmembers || !cubeItem.mParentLevel.isContextDependent()) continue;
            ArrayList<AbstractProcessor.CubeLevel> levels = this.getLowestLevels();
            for (AbstractProcessor.CubeLevel cubeLevel : levels) {
                if (cubeLevel == cubeItem.mParentLevel) continue;
                this.addV5DataItem(nodeFactory, selection, groupBody, cubeLevel.mKeyItems.get(0), false);
            }
        }
    }

    protected void addV5DataItem(XQENodeFactory nodeFactory, V5Selection selection, IXQEQueryNode groupBody, AbstractProcessor.CubeItem cubeItem, boolean isV5QueryToLoadmembers) {
        IDataType d = ((V5DataItem)cubeItem.mTabExpr).getDataType();
        if (d.getSubType() != DataSubType.METADATATYPE) {
            V5DataItem dataItem = (V5DataItem)nodeFactory.deepCopyNode(cubeItem.mTabExpr);
            this.addV5DataItem(nodeFactory, selection, groupBody, dataItem, cubeItem.mAggr, cubeItem.mRollUpAggr);
            if (isV5QueryToLoadmembers && groupBody != null) {
                IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
                dataItemRef.setPropertyValue("refDataItem", dataItem.getNameProperty());
                groupBody.addChild(dataItemRef);
            }
            return;
        }
        V5DataItem dataItemP = (V5DataItem)nodeFactory.deepCopyNode(cubeItem.mTabExpr);
        this.addV5DataItem(nodeFactory, selection, groupBody, dataItemP, cubeItem.mAggr, cubeItem.mRollUpAggr);
        if (isV5QueryToLoadmembers) {
            V5DataItem property;
            int idx = 0;
            while ((property = cubeItem.mParentLevel.getCustomProperty(idx++)) != null) {
                property = (V5DataItem)nodeFactory.deepCopyNode(property);
                this.addV5DataItem(nodeFactory, selection, groupBody, property, cubeItem.mAggr, cubeItem.mRollUpAggr);
            }
        }
    }

    protected void addV5DataItem(XQENodeFactory nodeFactory, V5Selection selection, IXQEQueryNode groupBody, V5DataItem dataItem, String aggr, String rollupAggr) {
        if (aggr != null) {
            dataItem.setAggregateProperty(aggr);
        }
        if (rollupAggr != null) {
            dataItem.setRollupAggregateProperty(rollupAggr);
        }
        dataItem.setIsProjected();
        dataItem.setIsReferenced();
        dataItem.setReferencesWalked();
        selection.addChild(dataItem);
        if (groupBody != null) {
            IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", dataItem.getNameProperty());
            groupBody.addChild(dataItemRef);
        }
    }

    AbstractProcessor.CubeItem getCubeItem(IMetadata metadata) {
        if (metadata instanceof DMRLevel) {
            DMRLevel level = (DMRLevel)metadata;
            return this.getCubeLevelKeyItem(level);
        }
        if (metadata instanceof DMRMeasure) {
            DMRMeasure dmrMeasure = (DMRMeasure)metadata;
            String measureName = dmrMeasure.getName();
            return this.getCubeMeasure(measureName);
        }
        return null;
    }

    AbstractProcessor.CubeItem getCubeItem(String dataItemName) {
        for (AbstractProcessor.CubeDimension cd : this.mCubeDimensions) {
            for (AbstractProcessor.CubeLevel cl : cd.mLevels) {
                for (AbstractProcessor.CubeItem ci : cl.mKeyItems) {
                    if (ci.mName != dataItemName) continue;
                    return ci;
                }
            }
        }
        for (AbstractProcessor.CubeItem ci : this.mCubeMeasures) {
            if (ci.mName != dataItemName) continue;
            return ci;
        }
        return null;
    }

    @Override
    protected void finalizeProcess() {
        for (AbstractProcessor.CubeDimension cd : this.mCubeDimensions) {
            for (AbstractProcessor.CubeLevel cl : cd.mLevels) {
                cl.mergeKeyItems();
            }
        }
    }

    @Override
    protected void initializeProcess(V5QuerySet querySet) {
        this.mExprLocale = querySet.getPropertyValue("expressionLocale");
        this.mModelPath = querySet.getPropertyValue("modelPath");
    }

    @Override
    protected void processFilters(V5QueryResultDefinition v5qrd, V5Query v5Query) {
        IXQEQueryNode[] filters;
        for (IXQEQueryNode aFilter : filters = v5Query.getV5DetailFilters()) {
            this.processDetailFilter((V5DetailFilter)aFilter);
        }
        for (IXQEQueryNode aSumFilter : filters = v5Query.getV5SummaryFilters()) {
            this.processSummaryFilter((V5SummaryFilter)aSumFilter);
        }
    }

    protected void processDetailFilter(V5DetailFilter filter) {
        if (filter.getUseProperty() == "prohibited") {
            return;
        }
        boolean postAutoAggregation = filter.getPostAutoAggregation();
        if (postAutoAggregation && this.moveDetailFilterPreAutoAggregate(filter)) {
            postAutoAggregation = false;
        }
        if (postAutoAggregation) {
            this.processExpression(filter, filter, false, false, false, false);
            if (DecomposeScalarFunction.containsNotSupportedByOlapFunction(filter)) {
                ArrayList<IXQEQueryNode> messageContext = new ArrayList<IXQEQueryNode>();
                messageContext.add(filter);
                XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedRelationalInPAADetailFilter, messageContext);
                throw new XQEOlapUnsupportedQueryException(message);
            }
        } else {
            this.addSubqueryFilter(filter);
            filter.detach();
        }
    }

    boolean moveDetailFilterPreAutoAggregate(V5DetailFilter filter) {
        this.memberDetailFilterFound = false;
        this.valueDetailFilterFound = false;
        HashSet<IHierarchy> filterHier = new HashSet<IHierarchy>();
        if (this.isMemberDetailFilter((AbstractV5BooleanExpression)filter.getChild(0), filterHier)) {
            for (IHierarchy hierarchy : filterHier) {
                if (this.isProjectedHierarchy(hierarchy)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isMemberDetailFilter(AbstractV5BooleanExpression condition, Set<IHierarchy> filterHier) {
        boolean result = false;
        IHierarchy hier = null;
        switch (condition.getType()) {
            case 201013: {
                int subType = condition.getSubType();
                if (subType != 2 && subType != 3 || (hier = this.getMemberComparisonHierarchy(condition.getChild(0))) == null) break;
                filterHier.add(hier);
                result = true;
                break;
            }
            case 201011: {
                hier = this.getMemberComparisonHierarchy(condition.getChild(0));
                if (hier == null) break;
                filterHier.add(hier);
                result = true;
                break;
            }
            case 201003: {
                result = true;
                for (IXQEQueryNode childCondition : condition.getChildren()) {
                    result = result && this.isMemberDetailFilter((AbstractV5BooleanExpression)childCondition, filterHier);
                }
                break;
            }
        }
        if (result) {
            this.memberDetailFilterFound = true;
        } else {
            this.valueDetailFilterFound = true;
        }
        if (this.memberDetailFilterFound && this.valueDetailFilterFound) {
            result = false;
        }
        return result;
    }

    IHierarchy getMemberComparisonHierarchy(IXQEQueryNode lhsNode) {
        IMetadata metadata;
        MDXHierInfo hierInfo;
        IHierarchy hier = null;
        while (!lhsNode.isOfCategory(201120)) {
            lhsNode = lhsNode.getChild(0);
        }
        if (lhsNode.isOfCategory(201122) && (hierInfo = ((AbstractV5Set)lhsNode).getHierarchyInfo()).getNumProjectedHierarchies() == 1) {
            hier = hierInfo.getProjectedHierarchy(0);
        }
        if (lhsNode.getType() == 201116 && MetadataType.isOLAP(metadata = ((V5BoundModelIdentifier)lhsNode).getMetadata()) && !MetadataType.isMeasure(metadata)) {
            hier = MetadataUtil.getHierarchy(metadata);
        }
        return hier;
    }

    boolean isProjectedHierarchy(IHierarchy hierarchy) {
        return this.projectedHierarchies.contains(hierarchy);
    }

    protected boolean processExpression(IXQEQueryNode context, IXQEQueryNode exp, boolean isParentSupported, boolean aggregateCalculated, boolean rollupAggregateCalculated, boolean preventDecomposition) {
        IXQEQueryNode[] nodes;
        boolean ret = false;
        switch (exp.getType()) {
            case 101003: {
                if (context.getType() == 101008 && exp.getChild(0).getType() == 201117) {
                    return this.processExpression(context, exp.getChild(0), isParentSupported, aggregateCalculated, rollupAggregateCalculated, preventDecomposition);
                }
                V5DataItem node = this.mapDataItemName2DataItem.get(((V5DataItem)exp).getNameProperty());
                ret = this.processDataItem(node, null);
                this.rebindToCubeDataItem((V5DataItem)exp);
                return ret;
            }
            case 201117: {
                V5BoundMemberUniqueName node1 = (V5BoundMemberUniqueName)exp;
                exp.exchange(this.createMemberOverLocalLevel(node1));
                break;
            }
            case 201116: {
                Object cubeHierarchy;
                V5BoundModelIdentifier node2 = (V5BoundModelIdentifier)exp;
                IDataType dt = node2.getDataType();
                if (dt == HierarchyType.HIERARCHYTYPE) {
                    IHierarchy h;
                    if (this.rebindToCubeHierarchy(node2) || (h = this.resolveHierarchyFromExpression(exp.getParent())) == null || (cubeHierarchy = this.getDimensionHierarchy(h, false)) == null) break;
                    this.rebindCubeHierarchy(node2, ((AbstractProcessor.CubeHierarchy)cubeHierarchy).mDMRHierarchy);
                    return true;
                }
                if (dt == DimensionType.DIMENSIONTYPE && node2.getHierarchy().getDimension().isMeasuresDimension()) {
                    Dimension measuresDim = this.mParentWrapper.mCubeWrapper.createAndReturnMeasuresDimension();
                    cubeHierarchy = measuresDim.getDefaultHierarchy();
                    if (cubeHierarchy == null) break;
                    this.rebindCubeHierarchy(node2, (IHierarchy)cubeHierarchy);
                    return true;
                }
                if (node2.isMeasure()) {
                    AbstractProcessor.CubeItem cubeMeasure = this.getCubeMeasureByExpr(exp);
                    if (cubeMeasure == null) {
                        String aggr = ((V5DataItem)context).getAggregateProperty();
                        String rollUpAggr = ((V5DataItem)context).getRollupAggregateProperty();
                        cubeMeasure = this.createCubeMeasure(null, exp, aggr, rollUpAggr, node2.getDataType());
                    }
                    this.replaceV5DataItemExprWithMeasureWrapper(node2, cubeMeasure);
                    return true;
                }
                ReplaceBoundMultiPartIdentifier.throwOnFailure(node2.getMetadata(), true);
                break;
            }
        }
        for (IXQEQueryNode node : nodes = exp.getChildren()) {
            ret |= this.processExpression(context, node, isParentSupported, aggregateCalculated, rollupAggregateCalculated, preventDecomposition);
        }
        return ret;
    }

    protected void processSummaryFilter(V5SummaryFilter filter) {
        boolean filterAggrTypeIsCalculated = true;
        if (filter.getNumberChildren() == 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Missing summary filter definition");
        }
        boolean bPushToSubquery = false;
        bPushToSubquery = DecomposeScalarFunction.containsNotSupportedByOlapFunction(filter);
        if (bPushToSubquery) {
            this.addSubqueryFilter(filter);
            filter.detach();
        } else {
            this.processExpression(filter, filter.getChild(0), false, filterAggrTypeIsCalculated, filterAggrTypeIsCalculated, false);
        }
    }

    @Override
    protected void processSlicer(V5Query query) {
        IXQEQueryNode[] v5Slicers;
        for (IXQEQueryNode slicer : v5Slicers = query.getV5Slicers()) {
            this.addSlicer(slicer);
            slicer.detach();
        }
    }

    @Override
    protected void processSource(V5Query query) {
        this.mOriginalV5Source = query.getV5Source();
        query.detachChild(this.mOriginalV5Source);
    }
}

