/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metrics;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.metrics.IProfiledIterator;
import com.cognos.xqe.metrics.IteratorProfilingContext;
import com.cognos.xqe.metrics.ProfileObject;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.rsapi.IRSAPIDataset;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.SingletonHelper;

public final class IteratorProfilingManager {
    private static SingletonHelper<IteratorProfilingManager> singletonHelper = new SingletonHelper<IteratorProfilingManager>(){

        @Override
        protected IteratorProfilingManager newInstance() {
            return new IteratorProfilingManager();
        }

        @Override
        protected void releaseImpl(IteratorProfilingManager theInstance) {
        }

        @Override
        protected void initializeImpl(IteratorProfilingManager theInstance) {
        }
    };

    public static IteratorProfilingManager getInstance() {
        return singletonHelper.getInstance();
    }

    private IteratorProfilingManager() {
    }

    public boolean registerProfiler(XQETrace trace) {
        if (!QueryEngineLoggingUtils.isProfilingEnabled(trace)) {
            return false;
        }
        IteratorProfilingContext.enter();
        return true;
    }

    public void unregisterProfiler() {
        IteratorProfilingContext ctx = IteratorProfilingContext.get();
        if (ctx != null) {
            ctx.exit();
        }
    }

    public boolean isProfilingEnabled() {
        IteratorProfilingContext ctx = IteratorProfilingContext.get();
        return ctx != null;
    }

    public boolean register(IProfiledIterator it) {
        if (!this.isProfilingEnabled()) {
            return false;
        }
        IteratorProfilingContext p = IteratorProfilingContext.get();
        if (p == null) {
            return false;
        }
        p.addProfileObject(new ProfileObject(it));
        return true;
    }

    public void logProfiling(IRSAPIDataset partialDataset, IExecutionEnvironment env) {
        if (!this.isProfilingEnabled() || partialDataset == null) {
            return;
        }
        if (partialDataset.getDescendantsOfCategory(501137, false).size() != 0) {
            return;
        }
        this.addTimingInfo(partialDataset);
        QueryEngineLoggingUtils.dumpProfilingLog(env, partialDataset);
    }

    public void logProfiling(IXQEQueryNode xNode, IExecutionEnvironment env) {
        if (!this.isProfilingEnabled()) {
            return;
        }
        this.addTimingInfo(xNode);
        QueryEngineLoggingUtils.dumpProfilingLog(env, xNode);
    }

    public void logProfiling(IXQEQueryNode xNode, XQETrace trace) {
        if (!this.isProfilingEnabled()) {
            return;
        }
        this.addTimingInfo(xNode);
        xNode.dump(trace);
    }

    private void addTimingInfo(IXQEQueryNode root) {
        IteratorProfilingContext context = IteratorProfilingContext.get();
        if (context == null || !(root instanceof XNode)) {
            return;
        }
        XNode xNode = (XNode)root;
        ProfileObject[] profileObjects = context.getProfileObjects(xNode.getId());
        long totalElapsedTime = xNode.getTotalElapsedTime();
        long totalCPUTime = xNode.getTotalCPUTime();
        long nRows = 0L;
        for (int j = 0; j < profileObjects.length; ++j) {
            Object o = profileObjects[j].getData();
            if (!(o instanceof IProfiledIterator)) continue;
            totalElapsedTime += ((IProfiledIterator)o).getTotalElapsedTime();
            totalCPUTime += ((IProfiledIterator)o).getTotalCPUTime();
            if (!(o instanceof XTabularIterator)) continue;
            nRows += ((XTabularIterator)o).getRowCount();
        }
        if (totalElapsedTime > 0L) {
            xNode.setTotalElapsedTime(totalElapsedTime);
            xNode.setTotalCPUTime(totalCPUTime);
            if (nRows > 0L) {
                xNode.setRowCount(nRows);
            }
        }
        for (IXQEQueryNode child : root.getChildren()) {
            this.addTimingInfo(child);
        }
    }
}

