/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metrics;

import com.cognos.xqe.metrics.Metric;
import com.cognos.xqe.metrics.MetricTimestamp;
import java.util.concurrent.atomic.AtomicLong;

public class MetricsCounter
extends Metric {
    private AtomicLong counter = new AtomicLong();
    private MetricTimestamp updateTimeStamp = null;
    private MetricTimestamp resetTimeStamp = null;

    public MetricTimestamp getUpdateTimeStamp() {
        return this.updateTimeStamp;
    }

    public MetricTimestamp getResetTimeStamp() {
        return this.resetTimeStamp;
    }

    public MetricsCounter(String name) {
        super(name);
        this.init(0L);
    }

    public MetricsCounter(String name, long value) {
        super(name);
        this.init(value);
    }

    public MetricsCounter(String name, String category) {
        super(name, category);
        this.init(0L);
    }

    private void init(long value) {
        this.updateTimeStamp = new MetricTimestamp(this.metricName + "LastUpdateTime");
        this.resetTimeStamp = new MetricTimestamp(this.metricName + "LastResetTime");
        this.counter.set(value);
    }

    @Override
    public long increment() {
        this.updateTimeStamp.update();
        return this.counter.getAndIncrement();
    }

    @Override
    public long decrement() {
        this.updateTimeStamp.update();
        return this.counter.getAndDecrement();
    }

    @Override
    public long increment(long num) {
        this.updateTimeStamp.update();
        return this.counter.getAndAdd(num);
    }

    @Override
    public long decrement(long num) {
        this.updateTimeStamp.update();
        return this.counter.getAndAdd(num * -1L);
    }

    @Override
    public long getLongValue() {
        return this.counter.get();
    }

    @Override
    public void reset() {
        this.counter.set(0L);
        this.updateTimeStamp.reset();
        this.resetTimeStamp.update();
    }

    @Override
    public long setValue(long value) {
        this.updateTimeStamp.update();
        return this.counter.getAndSet(value);
    }

    @Override
    public Object getValue() {
        return this.counter.get();
    }
}

