/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.metrics;

import com.cognos.xqe.metrics.Metric;
import com.cognos.xqe.metrics.MetricsCounter;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MetricsIntervalCounter
extends Metric {
    private ConcurrentLinkedQueue<MetricsCounter> metrics = new ConcurrentLinkedQueue();
    private MetricsCounter activeMetric;

    public ConcurrentLinkedQueue<MetricsCounter> getMetrics() {
        return this.metrics;
    }

    public MetricsIntervalCounter(String name, int intervals) {
        super(name);
        this.metrics.add(new MetricsCounter(name));
        for (int i = 1; i < intervals; ++i) {
            this.metrics.add(new MetricsCounter(name + "_" + i));
        }
        this.activeMetric = this.metrics.peek();
    }

    public void rollMetrics() {
        long previous = 0L;
        for (MetricsCounter metric : this.metrics) {
            previous = metric.setValue(previous);
        }
    }

    @Override
    public long decrement() {
        return this.activeMetric.decrement();
    }

    @Override
    public long decrement(long num) {
        return this.activeMetric.decrement(num);
    }

    @Override
    public long getLongValue() {
        return this.activeMetric.getLongValue();
    }

    @Override
    public Object getValue() {
        return this.activeMetric.getValue();
    }

    @Override
    public long increment() {
        return this.activeMetric.increment();
    }

    @Override
    public long increment(long num) {
        return this.activeMetric.increment(num);
    }

    @Override
    public void reset() {
        this.activeMetric.reset();
    }
}

