/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.olapjapi;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.olapjapi.IXQEODPSession;
import com.cognos.xqe.olapjapi.XQEODPSessionImpl;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.rmi.server.UID;
import java.util.Map;
import org.dom4j.Element;

public final class XQEODPSessionBuilder {
    private String cmDataSourceName = null;
    private String modelDataSourceName = null;
    private String dataSourceType = null;
    private Map<String, Object> dataSourceProps = null;
    private IDataSource customDataSource = null;
    private BIBusEnvelope requestEnvelope = null;
    private Element connectionSpec = null;
    private String productLocale = null;
    private String runLocale = null;
    private String designLocale = null;
    private String sessionContextId = null;
    private String requestId = null;
    private ExecutionEnvironment templateExecEnv = null;
    private final XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQEODP, "XQEODP", "XQEODPSessionFactory", LogLevel.INFO);

    @Deprecated
    public void setDataSource(String theCMDataSourceName, String theDataSourceType, Map<String, Object> theDataSourceProps) {
        this.modelDataSourceName = null;
        this.cmDataSourceName = theCMDataSourceName;
        this.dataSourceType = theDataSourceType;
        this.dataSourceProps = theDataSourceProps;
    }

    public void setDataSource(String theModelDataSourceName, String theCMDataSourceName, String theDataSourceType, Map<String, Object> theDataSourceProps) {
        this.modelDataSourceName = theModelDataSourceName;
        this.cmDataSourceName = theCMDataSourceName;
        this.dataSourceType = theDataSourceType;
        this.dataSourceProps = theDataSourceProps;
    }

    public void setCustomDataSource(IDataSource theDataSource) {
        this.customDataSource = theDataSource;
    }

    public void setRequestEnvelope(BIBusEnvelope theRequestEnvelope) {
        this.requestEnvelope = theRequestEnvelope;
    }

    public void setConnectionSpec(Element theConnectionSpec) {
        this.connectionSpec = theConnectionSpec;
    }

    public void setProductLocale(String theProductLocale) {
        this.productLocale = theProductLocale;
    }

    public void setRunLocale(String theRunLocale) {
        this.runLocale = theRunLocale;
    }

    public void setDesignLocale(String theDesignLocale) {
        this.designLocale = theDesignLocale;
    }

    public void setSessionContextId(String theSessionContextId) {
        this.sessionContextId = theSessionContextId;
    }

    public void setRequestId(String theRequestId) {
        this.requestId = theRequestId;
    }

    public void setExecutionEnvironment(ExecutionEnvironment theExecEnv) {
        this.templateExecEnv = theExecEnv;
    }

    public IXQEODPSession createSession() {
        ExecutionEnvironment execEnv = null;
        RequestEnvironment reqEnv = null;
        IDataSource dataSource = null;
        ExecutionEnvironment threadBoundExecEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null != threadBoundExecEnv) {
            this.templateExecEnv = threadBoundExecEnv;
        }
        boolean manageMultiRequestContext = false;
        if (null != this.templateExecEnv && null != this.templateExecEnv.getRequestEnvironment()) {
            if (this.logger.isOn()) {
                this.logger.log("Creating session with existing ExecutionEnvironment " + this.templateExecEnv.toString());
            }
            reqEnv = ((RequestEnvironment)this.templateExecEnv.getRequestEnvironment()).duplicate();
            execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
            this.templateExecEnv.copyTo(execEnv);
            execEnv.setRequestEnvironment(reqEnv);
            execEnv.getMultiRequestContext();
            manageMultiRequestContext = false;
        } else {
            if (null == this.requestEnvelope) {
                throw new NullPointerException("requestEnvelope was null");
            }
            if (null == this.connectionSpec) {
                throw new NullPointerException("connectionSpec was null");
            }
            this.logger.log("Creating session with new ExecutionEnvironment");
            reqEnv = new RequestEnvironment(this.requestEnvelope);
            QueryEngine.getInstance().configureRequestEnvironment(reqEnv);
            execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
            execEnv.setConnectionElement(this.connectionSpec);
            if (this.logger.isOn()) {
                this.logger.log("Using Connection Spec: " + this.connectionSpec.asXML());
            }
            if (null != this.productLocale) {
                reqEnv.setProductLocale(this.productLocale);
                if (this.logger.isOn()) {
                    this.logger.log("Using Product Locale: " + this.productLocale);
                }
            }
            if (null != this.runLocale) {
                reqEnv.setRunLocale(this.runLocale);
                if (this.logger.isOn()) {
                    this.logger.log("Using Run Locale: " + this.runLocale);
                }
            }
            if (null != this.requestId) {
                reqEnv.setRequestID(this.requestId);
                if (this.logger.isOn()) {
                    this.logger.log("Using Request Id: " + this.requestId);
                }
            }
            if (null != this.sessionContextId) {
                reqEnv.setSessionContextID(this.sessionContextId);
            } else {
                reqEnv.setSessionContextID(new UID().toString());
            }
            if (this.logger.isOn()) {
                this.logger.log("Using Session Context Id: " + reqEnv.getSessionContextID());
            }
            QueryEngine.getInstance().configureMultiRequestContext(reqEnv, null);
            manageMultiRequestContext = true;
        }
        if (this.customDataSource != null) {
            dataSource = this.customDataSource;
            if (this.logger.isOn()) {
                this.logger.log("Using custom Data Source: " + this.customDataSource.toString());
            }
        } else {
            if (null == this.cmDataSourceName) {
                throw new NullPointerException("dataSourceName was null");
            }
            if (null == this.dataSourceProps) {
                throw new NullPointerException("dataSourceProps was null");
            }
            if (null == this.modelDataSourceName) {
                StringBuilder modelNameBuffer = new StringBuilder("%TMP%_");
                String catalogName = (String)this.dataSourceProps.get("catalog");
                String cubeName = (String)this.dataSourceProps.get("cube");
                modelNameBuffer.append(this.cmDataSourceName);
                if (null != catalogName) {
                    modelNameBuffer.append('_').append(catalogName);
                }
                if (null != cubeName) {
                    modelNameBuffer.append('_').append(cubeName);
                }
                this.modelDataSourceName = modelNameBuffer.toString();
            }
            if (this.logger.isOn()) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append("Creating new Data Source with model name '").append(this.modelDataSourceName).append("', CM name '").append(this.cmDataSourceName).append("', type '").append(this.dataSourceType).append("' and properties ").append(this.dataSourceProps);
                this.logger.log(logBuf.toString());
            }
            dataSource = DataSourceTypeEnum.isROLAP(this.dataSourceType) ? execEnv.getOrAddDataSource(this.modelDataSourceName, this.cmDataSourceName, this.dataSourceType, this.dataSourceProps) : execEnv.getOrAddDataSource(this.modelDataSourceName, this.cmDataSourceName, null, this.dataSourceProps);
        }
        XQEODPSessionImpl session = new XQEODPSessionImpl(dataSource, execEnv, this.designLocale, manageMultiRequestContext);
        session.initialize();
        return session;
    }
}

