/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.olapjapi;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.olapjapi.IXQEODPSession;
import com.cognos.xqe.olapjapi.MDXQueryArgs;
import com.cognos.xqe.olapjapi.MetadataQueryArgs;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.List;
import java.util.Locale;
import org.dom4j.Element;

class XQEODPSessionImpl
implements IXQEODPSession {
    private final boolean manageMultiRequestContext;
    private final IDataSource dataSource;
    private final Locale designLocale;
    private final ExecutionEnvironment execEnv;
    private IOLAPDataProvider dataProvider = null;
    private IOLAPMetadataProvider metadataProvider = null;
    private volatile boolean initialized = false;
    private volatile boolean released = false;
    private static final String CUBE_PREFIX = ", cube =";
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQEODP, "XQEODP", "XQEODPSessionImpl", LogLevel.INFO);
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    XQEODPSessionImpl(IDataSource theDataSource, ExecutionEnvironment theExecEnv, String theDesignLocale, boolean shouldManageMultiRequestContext) {
        this.dataSource = theDataSource;
        this.execEnv = theExecEnv;
        this.designLocale = LocaleConverter.strToLocale(theDesignLocale);
        this.manageMultiRequestContext = shouldManageMultiRequestContext;
    }

    void initialize() {
        if (!XQEService.isInitialized()) {
            throw new XQERuntimeException(XQEMessageKeys.INI_XQEServiceWasNotInitialized);
        }
        if (this.manageMultiRequestContext && 1 != this.execEnv.getMultiRequestContext().incrementRefCount()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Expected ref count 1, but found " + this.execEnv.getMultiRequestContext().getRefCount());
        }
        TraceContext traceContext = this.enterTraceContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(this.execEnv);
        try {
            this.dataProvider = ProviderManager.getInstance().getOLAPProvider(this.dataSource.getType());
            if (null == this.dataProvider) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Failed to load OLAP Data Provider");
            }
            MetadataQueryArguments mdQueryArgs = new MetadataQueryArguments(this.dataSource, null, this.designLocale){

                @Override
                public ExecutionEnvironment getExecutionEnvironment() {
                    return XQEODPSessionImpl.this.getExecutionEnvironment();
                }
            };
            this.metadataProvider = this.dataProvider.getMetadataProvider(mdQueryArgs);
            if (null == this.metadataProvider) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Failed to load OLAP Metadata Provider");
            }
        }
        catch (RuntimeException ex) {
            if (this.manageMultiRequestContext) {
                this.execEnv.getMultiRequestContext().decrementRefCount();
            }
            throw ex;
        }
        finally {
            executionEnvironmentContext.exit();
            traceContext.exit();
        }
        this.initialized = true;
    }

    private ExecutionEnvironment getExecutionEnvironment() {
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == executionEnvironment) {
            ERROR_LOGGER.log(LogLevel.ERROR, "XQEODPSessionImpl.getExecutionEnvironment(): null == executionEnvironment");
            executionEnvironment = this.execEnv;
        }
        return executionEnvironment;
    }

    @Override
    @Deprecated
    public Element getBIBusHeader() {
        return ((RequestEnvironment)this.getExecutionEnvironment().getRequestEnvironment()).getBibusHeader();
    }

    @Override
    public BIBusEnvelope getRequestEnvelope() {
        return ((RequestEnvironment)this.getExecutionEnvironment().getRequestEnvironment()).getRequestEnvelope();
    }

    @Override
    public IDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Locale getProductLocale() {
        return ((RequestEnvironment)this.getExecutionEnvironment().getRequestEnvironment()).getProductLocale();
    }

    @Override
    public Locale getRunLocale() {
        return ((RequestEnvironment)this.getExecutionEnvironment().getRequestEnvironment()).getRunLocale();
    }

    @Override
    public Locale getDesignLocale() {
        return this.designLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDataSourceLocales(String catalog, String cube) {
        this.assertSessionIsValid();
        MetadataRestriction restrictions = new MetadataRestriction();
        if (null != catalog) {
            restrictions.add(RestrictionType.CATALOG, catalog);
        }
        if (null != cube) {
            restrictions.add(RestrictionType.CUBE, cube);
        }
        TraceContext traceContext = this.enterTraceContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(this.getExecutionEnvironment());
        try {
            if (LOGGER.isOn(LogLevel.TRACE)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append("Fetching data source locales for catalog =").append(catalog).append(CUBE_PREFIX).append(cube);
                LOGGER.log(LogLevel.TRACE, logBuf.toString());
            }
            List<String> list = this.metadataProvider.getDatasourceLocales(restrictions);
            return list;
        }
        finally {
            executionEnvironmentContext.exit();
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDataSourceLocales(IRestrictions restrictions) {
        this.assertSessionIsValid();
        TraceContext traceContext = this.enterTraceContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(this.getExecutionEnvironment());
        try {
            if (LOGGER.isOn(LogLevel.TRACE)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append("Fetching data source locales for catalog=").append(restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class)).append(CUBE_PREFIX).append(restrictions.getTypedValueOf(RestrictionType.CUBE, String.class));
                LOGGER.log(LogLevel.TRACE, logBuf.toString());
            }
            List<String> list = this.metadataProvider.getDatasourceLocales(restrictions);
            return list;
        }
        finally {
            executionEnvironmentContext.exit();
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getNamedSetLevelUniqueNames(String catalog, String cube, String setUniqueName) {
        this.assertSessionIsValid();
        MetadataRestriction restrictions = new MetadataRestriction();
        if (null != catalog) {
            restrictions.add(RestrictionType.CATALOG, catalog);
        }
        if (null != cube) {
            restrictions.add(RestrictionType.CUBE, cube);
        }
        if (null != setUniqueName) {
            restrictions.add(RestrictionType.SET, setUniqueName);
        }
        TraceContext traceContext = this.enterTraceContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(this.getExecutionEnvironment());
        try {
            if (LOGGER.isOn(LogLevel.TRACE)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append("Fetching named set LUNs for catalog=").append(catalog).append(CUBE_PREFIX).append(cube).append(",set =").append(setUniqueName);
                LOGGER.log(LogLevel.TRACE, logBuf.toString());
            }
            List<String> list = this.metadataProvider.getNamedSetLevelUniqueNames(restrictions);
            return list;
        }
        finally {
            executionEnvironmentContext.exit();
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getNamedSetLevelUniqueNames(IRestrictions restrictions) {
        this.assertSessionIsValid();
        TraceContext traceContext = this.enterTraceContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(this.getExecutionEnvironment());
        try {
            if (LOGGER.isOn(LogLevel.TRACE)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append("Fetching named set LUNs for catalog =").append(restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class)).append(CUBE_PREFIX).append(restrictions.getTypedValueOf(RestrictionType.CUBE, String.class)).append(", set =").append(restrictions.getTypedValueOf(RestrictionType.SET, String.class));
                LOGGER.log(LogLevel.TRACE, logBuf.toString());
            }
            List<String> list = this.metadataProvider.getNamedSetLevelUniqueNames(restrictions);
            return list;
        }
        finally {
            executionEnvironmentContext.exit();
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCubeDefaultMeasure(IRestrictions restrictions) {
        this.assertSessionIsValid();
        String catalog = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cube = (String)restrictions.getValueOf(RestrictionType.CUBE);
        TraceContext traceContext = this.enterTraceContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(this.getExecutionEnvironment());
        try {
            if (LOGGER.isOn(LogLevel.TRACE)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append("Fetching default cube measure for catalog =").append(catalog).append(CUBE_PREFIX).append(cube);
                LOGGER.log(LogLevel.TRACE, logBuf.toString());
            }
            String string = this.metadataProvider.getCubeDefaultMeasure(restrictions);
            return string;
        }
        finally {
            executionEnvironmentContext.exit();
            traceContext.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends MetadataRecord> List<T> getMetadata(MetadataQueryArgs args) {
        this.assertSessionIsValid();
        MetadataOperation operation = args.getOperation();
        IRestrictions restrictions = args.getRestrictions();
        TraceContext traceContext = this.enterTraceContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(this.getExecutionEnvironment());
        try {
            if (LOGGER.isOn(LogLevel.TRACE)) {
                StringBuilder logBuf = new StringBuilder();
                logBuf.append("Fetching metadata with arguments ").append(args);
                LOGGER.log(LogLevel.TRACE, logBuf.toString());
            }
            List<MetadataRecord> list = MetadataOperation.invoke(operation, this.metadataProvider, restrictions);
            return list;
        }
        finally {
            executionEnvironmentContext.exit();
            traceContext.exit();
        }
    }

    @Override
    @Deprecated
    public <T extends MetadataRecord> List<T> getMetadata(MetadataQueryArgs args, ExecutionEnvironment theExecEnv) {
        return this.getMetadata(args);
    }

    @Override
    public ICubeResultSet executeQuery(MDXQueryArgs args) {
        this.assertSessionIsValid();
        if (LOGGER.isOn(LogLevel.TRACE)) {
            StringBuilder logBuf = new StringBuilder();
            logBuf.append("Executing data query with arguments ").append(args);
            LOGGER.log(LogLevel.TRACE, logBuf.toString());
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "XQEODPSessionImpl.executeQuery()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release() {
        if (!this.initialized || this.released) {
            return;
        }
        this.released = true;
        LOGGER.log(LogLevel.INFO, "Releasing XQEODPSessionImpl");
        ExecutionEnvironmentContext ctx = ExecutionEnvironmentContext.enter(this.getExecutionEnvironment());
        try {
            if (this.manageMultiRequestContext && 0 != this.execEnv.getMultiRequestContext().decrementRefCount()) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Expected ref count 0, but found " + this.execEnv.getMultiRequestContext().getRefCount());
            }
        }
        finally {
            try {
                this.metadataProvider.release();
            }
            finally {
                this.metadataProvider = null;
                ctx.exit();
            }
        }
    }

    private void assertSessionIsValid() {
        if (!this.initialized || this.released) {
            throw new IllegalStateException("Session no longer valid");
        }
    }

    private TraceContext enterTraceContext() {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("requestId", ((RequestEnvironment)this.execEnv.getRequestEnvironment()).getRequestID());
        traceContext.addAttribute("sessionId", this.execEnv.getMultiRequestContext().getSessionContextID());
        return traceContext;
    }
}

