/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class RefCountingMap<K, V> {
    private final Map<K, Entry<K, V>> mHashMap = new HashMap<K, Entry<K, V>>();

    public int size() {
        return this.mHashMap.size();
    }

    public boolean isEmpty() {
        return this.mHashMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<K, V> put(K key, V value) {
        Entry<K, V> entry = null;
        Map<K, Entry<K, V>> map = this.mHashMap;
        synchronized (map) {
            entry = this.mHashMap.get(key);
            if (null != entry) {
                entry.takeReference();
            } else {
                entry = new Entry<K, V>(key, value);
                this.mHashMap.put(key, entry);
            }
        }
        return entry;
    }

    public Entry<K, V> replace(K key, V value) {
        Map<K, Entry<K, V>> map = this.mHashMap;
        synchronized (map) {
            Entry<K, V> oldEntry = this.mHashMap.get(key);
            if (null != oldEntry) {
                Entry<K, V> newEntry = new Entry<K, V>(key, value);
                ((Entry)newEntry).mReferenceCount = ((Entry)oldEntry).mReferenceCount;
                this.mHashMap.put(key, newEntry);
                return newEntry;
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "com.cognos.xqe.pool.RefCountingMap.replace(K, V) cannot replace an absent value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<K, V> get(Object key) {
        Map<K, Entry<K, V>> map = this.mHashMap;
        synchronized (map) {
            return this.mHashMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<K, V> remove(Object key) {
        Map<K, Entry<K, V>> map = this.mHashMap;
        synchronized (map) {
            Entry<K, V> entry = this.mHashMap.get(key);
            if (null != entry && entry.releaseReference() == 0) {
                this.mHashMap.remove(key);
            }
            return entry;
        }
    }

    public void clear() {
        this.mHashMap.clear();
    }

    public Collection<Entry<K, V>> entries() {
        return this.mHashMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keySet() {
        Map<K, Entry<K, V>> map = this.mHashMap;
        synchronized (map) {
            return this.mHashMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<V> values() {
        Map<K, Entry<K, V>> map = this.mHashMap;
        synchronized (map) {
            HashSet<V> vals = new HashSet<V>();
            for (Entry<K, V> ent : this.mHashMap.values()) {
                vals.add(ent.getReferencedObject());
            }
            return vals;
        }
    }

    public String toString() {
        return this.mHashMap.toString();
    }

    public static final class Entry<K, V> {
        private final K mKey;
        private final V mReferencedObject;
        private int mReferenceCount;

        Entry(K key, V value) {
            this.mKey = key;
            this.mReferencedObject = value;
            this.mReferenceCount = 1;
        }

        public K getKey() {
            return this.mKey;
        }

        public int getReferenceCount() {
            return this.mReferenceCount;
        }

        int takeReference() {
            return ++this.mReferenceCount;
        }

        int releaseReference() {
            if (this.mReferenceCount <= 0) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "mReferenceCount (" + this.mReferenceCount + ") <= 0");
            }
            return --this.mReferenceCount;
        }

        public V getReferencedObject() {
            return this.mReferencedObject;
        }

        public String toString() {
            return "Ref count for: " + this.mReferencedObject + " = " + this.mReferenceCount;
        }
    }
}

