/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection;

import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.security.IEncryptedObject;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class AbstractConnectionParameter<T>
implements IConnectionParameter<T> {
    private String name = null;
    protected T value = null;
    private boolean loggable = false;
    private boolean matchable = true;
    protected int cachedHashCode = Integer.MIN_VALUE;

    private AbstractConnectionParameter() {
    }

    public AbstractConnectionParameter(String theName, T theValue, boolean isLoggable, boolean isMatchable) {
        this.name = theName;
        this.loggable = isLoggable;
        this.value = theValue;
        this.matchable = isMatchable;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final T value() {
        return this.value;
    }

    @Override
    public boolean isLoggable() {
        return this.loggable;
    }

    @Override
    public boolean isMatchable() {
        return this.matchable;
    }

    @Override
    public boolean matches(IConnectionParameter<?> other) {
        Object otherValue;
        if (this.getClass() != other.getClass()) {
            return false;
        }
        T thisValue = this.value();
        if (thisValue == (otherValue = other.value())) {
            return true;
        }
        if (null == thisValue) {
            return null == otherValue;
        }
        if (null == otherValue) {
            return false;
        }
        return thisValue.equals(otherValue);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name).append('=');
        if (this.isLoggable() || this.value instanceof IEncryptedObject) {
            buffer.append(this.value);
        } else {
            buffer.append('?').append(System.identityHashCode(this.value)).append('?');
        }
        return buffer.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof IConnectionParameter) {
            return this.matches((IConnectionParameter)other);
        }
        return false;
    }

    public int hashCode() {
        if (Integer.MIN_VALUE == this.cachedHashCode) {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.name);
            hcb.append(this.value);
            this.cachedHashCode = hcb.toHashCode();
            if (Integer.MIN_VALUE == this.cachedHashCode) {
                this.cachedHashCode = 0;
            }
        }
        return this.cachedHashCode;
    }
}

