/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection.decoration;

import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IPooledConnection;

public abstract class ConnectionFactoryDecorator
implements IConnectionFactory {
    private final IConnectionFactory mConnectionFactory;

    protected ConnectionFactoryDecorator(IConnectionFactory connectionFactory) {
        this.mConnectionFactory = connectionFactory;
    }

    @Override
    public Object createConnection(ConnectionParameters connectionParameters) {
        Object object = this.mConnectionFactory.createConnection(connectionParameters);
        this.afterCreateConnection(connectionParameters, object);
        return object;
    }

    @Override
    public void destroyConnection(IPooledConnection pooledConnection) {
        this.mConnectionFactory.destroyConnection(pooledConnection);
        this.afterDestroyConnection(pooledConnection);
    }

    protected void afterCreateConnection(ConnectionParameters connectionParameters, Object connection) {
    }

    protected void afterDestroyConnection(IPooledConnection pooledConnection) {
    }
}

