/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection.impl;

import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPool;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPoolFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ConnectionPool
implements IConnectionPool {
    private final Map<String, IProviderConnectionPool> mProviderConnectionPoolMap = new HashMap<String, IProviderConnectionPool>();
    final IProviderConnectionPoolFactory mProviderConnectionPoolFactory;

    public ConnectionPool(IProviderConnectionPoolFactory providerConnectionPoolFactory) {
        this.mProviderConnectionPoolFactory = providerConnectionPoolFactory;
    }

    @Override
    public IPooledConnection borrowConnection(String adapterName, ConnectionParameters connectionParameters, IConnectionSelector connectionSelector, IConnectionFactory connectionFactory) {
        return this.getOrCreateProviderConnectionPool(adapterName).borrowConnection(connectionParameters, connectionSelector, connectionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Map<String, IProviderConnectionPool> map = this.mProviderConnectionPoolMap;
        synchronized (map) {
            Iterator<IProviderConnectionPool> providerConnectionPoolIterator = this.mProviderConnectionPoolMap.values().iterator();
            while (providerConnectionPoolIterator.hasNext()) {
                providerConnectionPoolIterator.next().release();
            }
            this.mProviderConnectionPoolMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProviderConnectionPool getOrCreateProviderConnectionPool(String providerName) {
        IProviderConnectionPool providerConnectionPool = null;
        Map<String, IProviderConnectionPool> map = this.mProviderConnectionPoolMap;
        synchronized (map) {
            providerConnectionPool = this.mProviderConnectionPoolMap.get(providerName);
        }
        if (null == providerConnectionPool) {
            Thread.yield();
            IProviderConnectionPool newProviderConnectionPool = this.mProviderConnectionPoolFactory.createProviderConnectionPool(providerName);
            IProviderConnectionPool providerConnectionPoolFromMap = null;
            Map<String, IProviderConnectionPool> map2 = this.mProviderConnectionPoolMap;
            synchronized (map2) {
                providerConnectionPoolFromMap = this.mProviderConnectionPoolMap.get(providerName);
                if (null == providerConnectionPoolFromMap) {
                    providerConnectionPool = newProviderConnectionPool;
                    this.mProviderConnectionPoolMap.put(providerName, newProviderConnectionPool);
                } else {
                    providerConnectionPool = providerConnectionPoolFromMap;
                }
            }
            if (newProviderConnectionPool != providerConnectionPool) {
                newProviderConnectionPool.release();
            }
        }
        return providerConnectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getBorrowedConnectionStatistics() {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        Map<String, IProviderConnectionPool> map = this.mProviderConnectionPoolMap;
        synchronized (map) {
            for (Map.Entry<String, IProviderConnectionPool> entry : this.mProviderConnectionPoolMap.entrySet()) {
                int providerNumberOfBorrowedConnections = entry.getValue().getNumberOfBorrowedConnections();
                if (providerNumberOfBorrowedConnections <= 0) continue;
                result.put(entry.getKey(), providerNumberOfBorrowedConnections);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Integer> getIdleConnectionStatistics() {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        Map<String, IProviderConnectionPool> map = this.mProviderConnectionPoolMap;
        synchronized (map) {
            for (Map.Entry<String, IProviderConnectionPool> entry : this.mProviderConnectionPoolMap.entrySet()) {
                int providerNumberOfIdleConnections = entry.getValue().getNumberOfIdleConnections();
                if (providerNumberOfIdleConnections <= 0) continue;
                result.put(entry.getKey(), providerNumberOfIdleConnections);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<IPooledConnection, Set<Object>>> getCachingStatistics() {
        TreeMap<String, Map<IPooledConnection, Set<Object>>> result = new TreeMap<String, Map<IPooledConnection, Set<Object>>>();
        Map<String, IProviderConnectionPool> map = this.mProviderConnectionPoolMap;
        synchronized (map) {
            for (Map.Entry<String, IProviderConnectionPool> entry : this.mProviderConnectionPoolMap.entrySet()) {
                Map<IPooledConnection, Set<Object>> providerStatitics = entry.getValue().getCachingStatistics();
                if (null == providerStatitics) continue;
                result.put(entry.getKey(), providerStatitics);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnAllBorrowedConnections() {
        Map<String, IProviderConnectionPool> map = this.mProviderConnectionPoolMap;
        synchronized (map) {
            for (IProviderConnectionPool providerConnectionPool : this.mProviderConnectionPoolMap.values()) {
                providerConnectionPool.returnAllBorrowedConnections();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAllIdleConnections() {
        Map<String, IProviderConnectionPool> map = this.mProviderConnectionPoolMap;
        synchronized (map) {
            for (IProviderConnectionPool providerConnectionPool : this.mProviderConnectionPoolMap.values()) {
                providerConnectionPool.closeAllIdleConnections();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Map<String, IProviderConnectionPool> map = this.mProviderConnectionPoolMap;
        synchronized (map) {
            Iterator<Map.Entry<String, IProviderConnectionPool>> providerConnectionPoolIterator = this.mProviderConnectionPoolMap.entrySet().iterator();
            while (providerConnectionPoolIterator.hasNext()) {
                if (buffer.length() != 0) {
                    buffer.append("\n");
                }
                Map.Entry<String, IProviderConnectionPool> entry = providerConnectionPoolIterator.next();
                buffer.append(entry.getKey().toString());
                buffer.append(": ");
                buffer.append(entry.getValue().toString());
            }
        }
        return buffer.toString();
    }
}

