/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection.impl;

import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.impl.PoolRecord;
import com.cognos.xqe.pool.connection.impl.SelectorContext;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class PoolRecordList {
    private final int mMaxNumberOfConcurrentConnectionUsers;
    private final Queue<PoolRecord> mRecords;

    PoolRecordList(int maxNumberOfConcurrentConnectionUsers) {
        this.mMaxNumberOfConcurrentConnectionUsers = maxNumberOfConcurrentConnectionUsers;
        this.mRecords = new ConcurrentLinkedQueue<PoolRecord>();
    }

    PoolRecord selectPoolRecord(ConnectionParameters connectionParameters, IConnectionSelector connectionSelector) {
        PoolRecord returnedPoolRecord = null;
        LinkedList<PoolRecord> skipList = new LinkedList<PoolRecord>();
        Queue<PoolRecord> currentPass = this.mRecords;
        LinkedList<PoolRecord> nextPass = new LinkedList<PoolRecord>();
        SelectorContext context = new SelectorContext();
        context.setSelectionPass(1);
        while (returnedPoolRecord == null && !currentPass.isEmpty()) {
            returnedPoolRecord = PoolRecordList.selectPoolRecordInternal(currentPass, connectionParameters, context, connectionSelector, skipList, nextPass, this.mMaxNumberOfConcurrentConnectionUsers);
            if (returnedPoolRecord == null && !skipList.isEmpty()) {
                returnedPoolRecord = PoolRecordList.selectPoolRecordInternal(skipList, connectionParameters, context, connectionSelector, null, nextPass, this.mMaxNumberOfConcurrentConnectionUsers);
            }
            currentPass = new LinkedList<PoolRecord>();
            currentPass.addAll(nextPass);
            nextPass.clear();
            context.setSelectionPass(context.getSelectionPass() + 1);
        }
        return returnedPoolRecord;
    }

    private static PoolRecord selectPoolRecordInternal(Queue<PoolRecord> recordList, ConnectionParameters connectionParameters, SelectorContext context, IConnectionSelector connectionSelector, Queue<PoolRecord> skipList, Queue<PoolRecord> nextPass, int maxNumberOfConcurrentConnectionUsers) {
        PoolRecord returnedPoolRecord = null;
        for (PoolRecord poolRecord : recordList) {
            IConnectionSelector.ReturnCode status = poolRecord.selectConnection(connectionSelector, connectionParameters, context, skipList, maxNumberOfConcurrentConnectionUsers);
            if (status == IConnectionSelector.ReturnCode.MATCH) {
                returnedPoolRecord = poolRecord;
                break;
            }
            if (status != IConnectionSelector.ReturnCode.NEXT_PASS) continue;
            nextPass.add(poolRecord);
        }
        return returnedPoolRecord;
    }

    void tryReleasingExpiredAndInvalidatedPoolRecords(IExpirationPolicy policy) {
        Iterator iterator = this.mRecords.iterator();
        while (iterator.hasNext()) {
            boolean attemptRelease;
            PoolRecord poolRecord = (PoolRecord)iterator.next();
            if (poolRecord.isReusable()) {
                IExpirationPolicy.ExpirationResponse response = policy.canExpire(poolRecord);
                if (IExpirationPolicy.ExpirationResponse.RELEASE_IMMEDIATELY == response) {
                    poolRecord.setNotReusable();
                    attemptRelease = true;
                } else {
                    attemptRelease = IExpirationPolicy.ExpirationResponse.RELEASE_IF_IDLE == response;
                }
            } else {
                attemptRelease = true;
            }
            if (!attemptRelease || !poolRecord.releaseIfIdle(false)) continue;
            iterator.remove();
        }
    }

    boolean releaseOldestPoolRecord() {
        Iterator iterator = this.mRecords.iterator();
        while (iterator.hasNext()) {
            PoolRecord r = (PoolRecord)iterator.next();
            if (!r.releaseIfIdle(true)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    int size() {
        return this.mRecords.size();
    }

    void addCreatedPoolRecord(PoolRecord r) {
        this.mRecords.add(r);
    }

    void getRecordsByType(Queue<PoolRecord> idle, Queue<PoolRecord> borrowed, Queue<PoolRecord> notReusable) {
        for (PoolRecord r : this.mRecords) {
            if (idle != null && r.isIdle() && r.isReusable()) {
                idle.add(r);
                continue;
            }
            if (borrowed != null && !r.isIdle() && r.isReusable()) {
                borrowed.add(r);
                continue;
            }
            if (notReusable == null || r.isReusable()) continue;
            notReusable.add(r);
        }
    }

    Queue<PoolRecord> getBorrowedPoolRecords() {
        LinkedList<PoolRecord> records = new LinkedList<PoolRecord>();
        this.getRecordsByType(null, records, null);
        return records;
    }

    Queue<PoolRecord> getIdlePoolRecords() {
        LinkedList<PoolRecord> records = new LinkedList<PoolRecord>();
        this.getRecordsByType(records, null, null);
        return records;
    }

    long getRetainedSize() {
        long size = 0L;
        for (PoolRecord r : this.mRecords) {
            if (!r.isReusable()) continue;
            size += r.getSize();
        }
        return size;
    }

    void release() {
        Iterator iterator = this.mRecords.iterator();
        while (iterator.hasNext()) {
            PoolRecord r = (PoolRecord)iterator.next();
            if (!r.releaseIfIdle(true)) continue;
            iterator.remove();
        }
    }
}

