/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection.impl;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.impl.ProviderConnectionPoolBounded;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.Timer;

public class ProviderConnectionPoolRetainedSizeLimited
extends ProviderConnectionPoolBounded {
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Connection.Pool", LogLevel.INFO);
    private final long mMaxRetainedSize;

    public ProviderConnectionPoolRetainedSizeLimited(Timer expirationTimer, IExpirationPolicy connectionExpirationPolicy, int connectionExpirationCheckPeriod, long maxRetainedSize, int maxNumberOfConnections) {
        this(expirationTimer, connectionExpirationPolicy, connectionExpirationCheckPeriod, maxNumberOfConnections, maxRetainedSize, 1);
    }

    public ProviderConnectionPoolRetainedSizeLimited(Timer expirationTimer, IExpirationPolicy connectionExpirationPolicy, int connectionExpirationCheckPeriod, int maxNumberOfConnections, long maxRetainedSize, int connectionMaxConcurrentReuse) {
        super(expirationTimer, connectionExpirationPolicy, connectionExpirationCheckPeriod, maxNumberOfConnections, connectionMaxConcurrentReuse);
        if (maxRetainedSize <= 0L) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "maxRetainedSize (" + maxRetainedSize + ")<= 0");
        }
        this.mMaxRetainedSize = maxRetainedSize;
    }

    @Override
    protected void prepareForConnectionCreation() {
        this.checkRetainedMemory();
        super.prepareForConnectionCreation();
    }

    @Override
    protected void destroyExpiredConnections() {
        super.destroyExpiredConnections();
        this.checkRetainedMemory();
    }

    private void checkRetainedMemory() {
        long poolRetainedSize = this.mPoolRecordList.getRetainedSize();
        while (poolRetainedSize > this.mMaxRetainedSize) {
            boolean poolRecordToDestroyed;
            if (LOGGER.isOn(LogLevel.WARN)) {
                LOGGER.log(LogLevel.WARN, String.format("ProviderConnectionPoolRetainedSizeLimited: poolRetainedSize (%d) > mMaxRetainedSize (%d)", poolRetainedSize, this.mMaxRetainedSize));
            }
            if (!(poolRecordToDestroyed = this.mPoolRecordList.releaseOldestPoolRecord())) {
                if (!LOGGER.isOn(LogLevel.WARN)) break;
                LOGGER.log(LogLevel.WARN, String.format("ProviderConnectionPoolRetainedSizeLimited: Pool limit maxRetainedSize (%d) was exceeded but no idle records could be reclaimed at this time", this.mMaxRetainedSize));
                break;
            }
            LOGGER.log(LogLevel.WARN, "ProviderConnectionPoolRetainedSizeLimited: Oldest idle pool record was destroyed");
            poolRetainedSize = this.mPoolRecordList.getRetainedSize();
        }
    }
}

