/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection.impl;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPool;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ProviderContextualConnectionPool
implements IProviderConnectionPool {
    private static final int MAX_NUMBER_OF_CONNECTION_USERS = Integer.MAX_VALUE;
    private final IProviderConnectionPool mGlobalProviderConnectionPool;
    protected final Set<ContextualPoolRecord> mContextualBorrowedSet;

    public ProviderContextualConnectionPool(IProviderConnectionPool providerConnectionPool) {
        this.mGlobalProviderConnectionPool = providerConnectionPool;
        this.mContextualBorrowedSet = new HashSet<ContextualPoolRecord>();
    }

    @Override
    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IConnectionSelector connectionSelector, IConnectionFactory connectionFactory) {
        ContextualPoolRecord borrowedTwoStagePoolRecord = null;
        Iterator<ContextualPoolRecord> iterator = this.mContextualBorrowedSet.iterator();
        while (null == borrowedTwoStagePoolRecord && iterator.hasNext()) {
            ContextualPoolRecord contextualPoolRecord = iterator.next();
            if (contextualPoolRecord.selectConnection(connectionSelector, connectionParameters, Integer.MAX_VALUE) != IConnectionSelector.ReturnCode.MATCH) continue;
            borrowedTwoStagePoolRecord = contextualPoolRecord;
        }
        if (null == borrowedTwoStagePoolRecord) {
            borrowedTwoStagePoolRecord = new ContextualPoolRecord(this.mGlobalProviderConnectionPool.borrowConnection(connectionParameters, connectionSelector, connectionFactory));
            this.mContextualBorrowedSet.add(borrowedTwoStagePoolRecord);
        }
        return borrowedTwoStagePoolRecord;
    }

    @Override
    public void returnConnection(IPooledConnection pooledConnection) {
        ContextualPoolRecord returnedPooledConnection = (ContextualPoolRecord)pooledConnection;
        if (1 == returnedPooledConnection.getContextualCurrentUseCount()) {
            if (!this.mContextualBorrowedSet.remove(returnedPooledConnection)) {
                return;
            }
            returnedPooledConnection.getGlobalPooledConnection().returnConnection();
        } else {
            returnedPooledConnection.deselectConnection();
        }
    }

    @Override
    public IConnectionSelector.ReturnCode selectConnection(IPooledConnection pooledConnection, IConnectionSelector connectionSelector, ConnectionParameters connectionParameters, int maxUseCount) {
        return ((ContextualPoolRecord)pooledConnection).selectConnection(connectionSelector, connectionParameters, maxUseCount);
    }

    @Override
    public int deselectConnection(IPooledConnection pooledConnection) {
        return ((ContextualPoolRecord)pooledConnection).deselectConnection();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("In context: ");
        buffer.append("Borrowed#: ");
        buffer.append(this.mContextualBorrowedSet.size());
        buffer.append("\n");
        buffer.append(this.mContextualBorrowedSet.toString());
        buffer.append("\nGlobal: ");
        buffer.append(this.mGlobalProviderConnectionPool.toString());
        return buffer.toString();
    }

    @Override
    public void release() {
    }

    @Override
    public int getNumberOfBorrowedConnections() {
        return this.mGlobalProviderConnectionPool.getNumberOfBorrowedConnections();
    }

    @Override
    public int getNumberOfIdleConnections() {
        return this.mGlobalProviderConnectionPool.getNumberOfIdleConnections();
    }

    @Override
    public Map<IPooledConnection, Set<Object>> getCachingStatistics() {
        return this.mGlobalProviderConnectionPool.getCachingStatistics();
    }

    @Override
    public void returnAllBorrowedConnections() {
        while (!this.mContextualBorrowedSet.isEmpty()) {
            this.mContextualBorrowedSet.iterator().next().returnConnection();
        }
    }

    @Override
    public void closeAllIdleConnections() {
        while (!this.mContextualBorrowedSet.isEmpty()) {
            ContextualPoolRecord rec = this.mContextualBorrowedSet.iterator().next();
            rec.setNotReusable();
            rec.returnConnection();
        }
    }

    private class ContextualPoolRecord
    implements IPooledConnection {
        private final IPooledConnection mGlobalPooledConnection;
        private int mContextualCurrentUseCount;

        ContextualPoolRecord(IPooledConnection pooledConnection) {
            this.mGlobalPooledConnection = pooledConnection;
            this.mContextualCurrentUseCount = 1;
        }

        @Override
        public Object getConnection() {
            return this.mGlobalPooledConnection.getConnection();
        }

        @Override
        public int getCurrentUseCount() {
            return this.mGlobalPooledConnection.getCurrentUseCount();
        }

        @Override
        public void returnConnection() {
            ProviderContextualConnectionPool.this.returnConnection(this);
        }

        @Override
        public void setNotReusable() {
            this.mGlobalPooledConnection.setNotReusable();
        }

        @Override
        public boolean aliveSince(long timeMillis) {
            return this.mGlobalPooledConnection.aliveSince(timeMillis);
        }

        @Override
        public boolean idleSince(long timeMillis) {
            return this.mGlobalPooledConnection.idleSince(timeMillis);
        }

        private IConnectionSelector.ReturnCode selectConnection(IConnectionSelector connectionSelector, ConnectionParameters connectionParameters, int maxUseCount) {
            IConnectionSelector.ReturnCode selected = ProviderContextualConnectionPool.this.mGlobalProviderConnectionPool.selectConnection(this.mGlobalPooledConnection, connectionSelector, connectionParameters, maxUseCount);
            if (selected == IConnectionSelector.ReturnCode.MATCH) {
                ++this.mContextualCurrentUseCount;
            }
            return selected;
        }

        private int deselectConnection() {
            if (this.mContextualCurrentUseCount <= 0) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "mContextualCurrentUseCount (" + this.mContextualCurrentUseCount + ") <= 0");
            }
            --this.mContextualCurrentUseCount;
            return ProviderContextualConnectionPool.this.mGlobalProviderConnectionPool.deselectConnection(this.mGlobalPooledConnection);
        }

        private int getContextualCurrentUseCount() {
            return this.mContextualCurrentUseCount;
        }

        private IPooledConnection getGlobalPooledConnection() {
            return this.mGlobalPooledConnection;
        }

        public String toString() {
            return this.mGlobalPooledConnection.toString();
        }

        @Override
        public long getLastReturnedTimeMillis() {
            return 0L;
        }
    }
}

