/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection.impl;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.impl.ProviderConnectionPool;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPool;
import java.util.Timer;
import java.util.TimerTask;

public class ProviderExpirableConnectionPool
extends ProviderConnectionPool
implements IProviderConnectionPool {
    private static final String DIFFERENT_STRING = "!=";
    private static final int DISABLED = -1;
    private final IExpirationPolicy mExpirationPolicy;
    private final int mExpirationCheckPeriod;
    private final Timer mExpirationTimer;

    public ProviderExpirableConnectionPool() {
        this(null, null, -1, 1);
    }

    public ProviderExpirableConnectionPool(Timer expirationTimer, IExpirationPolicy expirationPolicy, int expirationCheckPeriod) {
        this(expirationTimer, expirationPolicy, expirationCheckPeriod, 1);
    }

    public ProviderExpirableConnectionPool(Timer expirationTimer, IExpirationPolicy expirationPolicy, int expirationCheckPeriod, int connectionMaxConcurrentReuse) {
        super(connectionMaxConcurrentReuse);
        boolean expirationCheckPeriodEnabled;
        boolean expirationTimerEnabled = null != expirationTimer;
        boolean expirationThresholdEnabled = null != expirationPolicy;
        boolean bl = expirationCheckPeriodEnabled = 0 < expirationCheckPeriod;
        if (expirationTimerEnabled != expirationThresholdEnabled) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "expirationTimerEnabled != expirationThresholdEnabled: " + expirationTimerEnabled + DIFFERENT_STRING + expirationThresholdEnabled);
        }
        if (expirationTimerEnabled != expirationCheckPeriodEnabled) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "expirationTimerEnabled != expirationCheckPeriodEnabled: " + expirationTimerEnabled + DIFFERENT_STRING + expirationCheckPeriodEnabled);
        }
        this.mExpirationTimer = expirationTimer;
        this.mExpirationPolicy = expirationPolicy;
        this.mExpirationCheckPeriod = expirationCheckPeriodEnabled ? expirationCheckPeriod : -1;
        if (null != this.mExpirationTimer) {
            this.mExpirationTimer.scheduleAtFixedRate((TimerTask)new ConnectionPoolTimerTask(), this.mExpirationCheckPeriod, (long)this.mExpirationCheckPeriod);
        }
    }

    protected void destroyExpiredConnections() {
        this.mPoolRecordList.tryReleasingExpiredAndInvalidatedPoolRecords(this.mExpirationPolicy);
    }

    private class ConnectionPoolTimerTask
    extends TimerTask {
        private ConnectionPoolTimerTask() {
        }

        @Override
        public void run() {
            ProviderExpirableConnectionPool.this.destroyExpiredConnections();
        }
    }
}

