/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.pool.connection.poolfactory;

import com.cognos.xqe.pool.connection.IExpirationPolicy;
import com.cognos.xqe.pool.connection.impl.ProviderConnectionPoolBounded;
import com.cognos.xqe.pool.connection.impl.ProviderConnectionPoolPassThrough;
import com.cognos.xqe.pool.connection.impl.ProviderConnectionPoolRetainedSizeLimited;
import com.cognos.xqe.pool.connection.impl.ProviderExpirableConnectionPool;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPool;
import com.cognos.xqe.pool.connection.poolfactory.IProviderConnectionPoolFactory;
import java.util.Timer;

public abstract class ProviderConnectionPoolFactory
implements IProviderConnectionPoolFactory {
    public IProviderConnectionPool createProviderConnectionPool(boolean poolingDisabled, Timer expirationTimer, IExpirationPolicy connectionExpirationPolicy, int connectionExpirationCheckPeriod, int connectionMaxNumber, long connectionRetainedSizeLimit, int connectionMaxConcurrentReuse) {
        IProviderConnectionPool providerConnectionPool;
        if (poolingDisabled) {
            providerConnectionPool = new ProviderConnectionPoolPassThrough();
        } else if (connectionRetainedSizeLimit > 0L) {
            if (connectionMaxNumber <= 0) {
                connectionMaxNumber = Integer.MAX_VALUE;
            }
            providerConnectionPool = new ProviderConnectionPoolRetainedSizeLimited(expirationTimer, connectionExpirationPolicy, connectionExpirationCheckPeriod, connectionMaxNumber, connectionRetainedSizeLimit, connectionMaxConcurrentReuse);
        } else {
            providerConnectionPool = connectionMaxNumber > 0 ? new ProviderConnectionPoolBounded(expirationTimer, connectionExpirationPolicy, connectionExpirationCheckPeriod, connectionMaxNumber, connectionMaxConcurrentReuse) : new ProviderExpirableConnectionPool(expirationTimer, connectionExpirationPolicy, connectionExpirationCheckPeriod, connectionMaxConcurrentReuse);
        }
        return providerConnectionPool;
    }
}

